/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.crl.stream.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

class CRLInfo {
    private Integer version;
    private String certificateListSignatureAlgorithmOid;
    private byte[] certificateListSignatureAlgorithmParams;
    private X500Principal issuer;
    private Date thisUpdate;
    private Date nextUpdate;
    private String tbsSignatureAlgorithmOid;
    private byte[] signatureValue;
    private Map<String, byte[]> criticalExtensions = new HashMap<String, byte[]>();
    private Map<String, byte[]> nonCriticalExtensions = new HashMap<String, byte[]>();

    CRLInfo() {
    }

    public Integer getVersion() {
        return this.version;
    }

    void setVersion(Integer version) {
        this.version = version;
    }

    public String getCertificateListSignatureAlgorithmOid() {
        return this.certificateListSignatureAlgorithmOid;
    }

    void setCertificateListSignatureAlgorithmOid(String certificateListSignatureAlgorithmOid) {
        this.certificateListSignatureAlgorithmOid = certificateListSignatureAlgorithmOid;
    }

    byte[] getCertificateListSignatureAlgorithmParams() {
        return this.certificateListSignatureAlgorithmParams;
    }

    void setCertificateListSignatureAlgorithmParams(byte[] certificateListSignatureAlgorithmParams) {
        this.certificateListSignatureAlgorithmParams = certificateListSignatureAlgorithmParams;
    }

    public X500Principal getIssuer() {
        return this.issuer;
    }

    void setIssuer(X500Principal issuer) {
        this.issuer = issuer;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    void setThisUpdate(Date thisUpdate) {
        this.thisUpdate = thisUpdate;
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    void setNextUpdate(Date nextUpdate) {
        this.nextUpdate = nextUpdate;
    }

    public String getTbsSignatureAlgorithmOid() {
        return this.tbsSignatureAlgorithmOid;
    }

    void setTbsSignatureAlgorithmOid(String tbsSignatureAlgorithmOid) {
        this.tbsSignatureAlgorithmOid = tbsSignatureAlgorithmOid;
    }

    public byte[] getSignatureValue() {
        return this.signatureValue;
    }

    void setSignatureValue(byte[] signatureValue) {
        this.signatureValue = signatureValue;
    }

    void addCriticalExtension(String oid, byte[] content) {
        this.criticalExtensions.put(oid, content);
    }

    public byte[] getCriticalExtension(String oid) {
        return this.criticalExtensions.get(oid);
    }

    public Map<String, byte[]> getCriticalExtensions() {
        return this.criticalExtensions;
    }

    void addNonCriticalExtension(String oid, byte[] content) {
        this.nonCriticalExtensions.put(oid, content);
    }

    public byte[] getNonCriticalExtension(String oid) {
        return this.nonCriticalExtensions.get(oid);
    }

    public Map<String, byte[]> getNonCriticalExtensions() {
        return this.nonCriticalExtensions;
    }
}

