/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.crl.stream.impl;

import eu.europa.esig.dss.crl.AbstractCRLUtils;
import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.crl.ICRLUtils;
import eu.europa.esig.dss.crl.stream.impl.BinaryFilteringInputStream;
import eu.europa.esig.dss.crl.stream.impl.CRLInfo;
import eu.europa.esig.dss.crl.stream.impl.CRLParser;
import eu.europa.esig.dss.enumerations.KeyUsageBit;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.x509.CertificateToken;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.cert.X509CRLEntry;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x509.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLUtilsStreamImpl
extends AbstractCRLUtils
implements ICRLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CRLUtilsStreamImpl.class);

    public CRLValidity buildCRLValidity(CRLBinary crlBinary, CertificateToken issuerToken) throws IOException {
        CRLValidity crlValidity = new CRLValidity(crlBinary);
        CRLInfo crlInfos = this.getCrlInfo(crlValidity);
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forOidAndParams((String)crlInfos.getCertificateListSignatureAlgorithmOid(), (byte[])crlInfos.getCertificateListSignatureAlgorithmParams());
        crlValidity.setSignatureAlgorithm(signatureAlgorithm);
        crlValidity.setThisUpdate(crlInfos.getThisUpdate());
        crlValidity.setNextUpdate(crlInfos.getNextUpdate());
        crlValidity.setCriticalExtensionsOid(crlInfos.getCriticalExtensions().keySet());
        this.extractIssuingDistributionPointBinary(crlValidity, crlInfos.getCriticalExtension(Extension.issuingDistributionPoint.getId()));
        this.extractExpiredCertsOnCRL(crlValidity, crlInfos.getNonCriticalExtension(Extension.expiredCertsOnCRL.getId()));
        X500Principal x509CRLIssuerX500Principal = crlInfos.getIssuer();
        X500Principal issuerTokenSubjectX500Principal = issuerToken.getSubject().getPrincipal();
        if (x509CRLIssuerX500Principal.equals(issuerTokenSubjectX500Principal)) {
            crlValidity.setIssuerX509PrincipalMatches(true);
        }
        this.checkSignatureValue(crlValidity, crlInfos.getSignatureValue(), signatureAlgorithm, this.getSignedData(crlValidity), issuerToken);
        return crlValidity;
    }

    private ByteArrayOutputStream getSignedData(CRLValidity crlValidity) throws IOException {
        try (InputStream is = crlValidity.toCRLInputStream();){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryFilteringInputStream bfis = new BinaryFilteringInputStream(is, baos);
            CRLParser parser = new CRLParser();
            parser.getSignedData(bfis);
            ByteArrayOutputStream byteArrayOutputStream = baos;
            return byteArrayOutputStream;
        }
    }

    public X509CRLEntry getRevocationInfo(CRLValidity crlValidity, BigInteger serialNumber) {
        CRLParser parser = new CRLParser();
        X509CRLEntry crlEntry = null;
        try (InputStream is = crlValidity.toCRLInputStream();){
            crlEntry = parser.retrieveRevocationInfo(is, serialNumber);
        }
        catch (IOException e) {
            LOG.error("Unable to retrieve the revocation status", (Throwable)e);
        }
        return crlEntry;
    }

    private void checkSignatureValue(CRLValidity crlValidity, byte[] signatureValue, SignatureAlgorithm signatureAlgorithm, ByteArrayOutputStream baos, CertificateToken signer) {
        try {
            Signature signature = Signature.getInstance(signatureAlgorithm.getJCEId());
            signature.initVerify(signer.getPublicKey());
            signature.update(baos.toByteArray());
            if (signature.verify(signatureValue)) {
                crlValidity.setSignatureIntact(true);
                crlValidity.setIssuerToken(signer);
                crlValidity.setCrlSignKeyUsage(signer.checkKeyUsage(KeyUsageBit.CRL_SIGN));
            } else {
                crlValidity.setSignatureInvalidityReason("Signature value not correct");
            }
        }
        catch (GeneralSecurityException e) {
            String msg = String.format("CRL Signature cannot be validated : %s", e.getMessage());
            if (LOG.isTraceEnabled()) {
                LOG.trace(msg, (Throwable)e);
            } else {
                LOG.warn(msg);
            }
            crlValidity.setSignatureInvalidityReason(msg);
        }
    }

    private CRLInfo getCrlInfo(CRLValidity crlValidity) throws IOException {
        try (InputStream is = crlValidity.toCRLInputStream();){
            CRLInfo cRLInfo;
            try (BufferedInputStream bis = new BufferedInputStream(is);){
                CRLParser parser = new CRLParser();
                cRLInfo = parser.retrieveInfo(bis);
            }
            return cRLInfo;
        }
    }
}

