/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.crl;

import eu.europa.esig.dss.crl.CRLInfo;
import eu.europa.esig.dss.crl.DERUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.cert.X509CRLEntry;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.jce.provider.X509CRLEntryObject;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CRLParser {
    private static final Logger LOG = LoggerFactory.getLogger(CRLParser.class);

    CRLParser() {
    }

    public void processDigest(DigestInputStream s) throws IOException {
        s.on(false);
        this.consumeTagIntro(s);
        s.on(true);
        int tag = DERUtil.readTag(s);
        DERUtil.readTagNumber(s, tag);
        int tbsLength = DERUtil.readLength(s);
        this.readNbBytes(s, tbsLength);
        s.on(false);
    }

    /*
     * Unable to fully structure code
     */
    public X509CRLEntry retrieveRevocationInfo(InputStream s, BigInteger serialNumber) throws IOException {
        this.consumeTagIntro(s);
        this.consumeTagIntro(s);
        tag = -1;
        tagNo = 5;
        length = -1;
        do {
            tag = DERUtil.readTag(s);
            tagNo = DERUtil.readTagNumber(s, tag);
            length = DERUtil.readLength(s);
            this.skip(s, length);
        } while (!this.isDate(tagNo));
        tag = DERUtil.readTag(s);
        tagNo = DERUtil.readTagNumber(s, tag);
        length = DERUtil.readLength(s);
        if (this.isDate(tagNo)) {
            this.skip(s, length);
            tag = DERUtil.readTag(s);
            tagNo = DERUtil.readTagNumber(s, tag);
            length = DERUtil.readLength(s);
        }
        if (tagNo == 16) {
            while (true) lbl-1000:
            // 7 sources

            {
                if ((tag = DERUtil.readTag(s)) < 0) {
                    return null;
                }
                tagNo = DERUtil.readTagNumber(s, tag);
                length = DERUtil.readLength(s);
                if (tagNo == 16) {
                    entryArray = this.readNbBytes(s, length);
                    is = new ByteArrayInputStream(entryArray);
                    var8_8 = null;
                    try {
                        entryTag = DERUtil.readTag(is);
                        entryTagNo = DERUtil.readTagNumber(is, entryTag);
                        entryLength = DERUtil.readLength(is);
                        if (2 != entryTagNo || !serialNumber.equals((asn1SerialNumber = this.rebuildASN1Integer(this.readNbBytes(is, entryLength))).getValue())) ** GOTO lbl-1000
                        asn1Sequence = this.rebuildASN1Sequence(entryArray);
                        crlEntry = TBSCertList.CRLEntry.getInstance((Object)asn1Sequence);
                        var15_17 = new X509CRLEntryObject(crlEntry);
                        return var15_17;
                    }
                    catch (Throwable var9_11) {
                        var8_8 = var9_11;
                        throw var9_11;
                    }
                    finally {
                        if (is == null) ** GOTO lbl-1000
                        if (var8_8 != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable var16_18) {
                                var8_8.addSuppressed(var16_18);
                            }
                        }
                        is.close();
                    }
                    continue;
                }
                CRLParser.LOG.debug("Should only contain SEQUENCEs : tagNo = {} (ignored)", (Object)tagNo);
                this.skip(s, length);
            }
        }
        return null;
    }

    public CRLInfo retrieveInfo(InputStream s) throws IOException {
        boolean isTagged;
        Time time;
        byte[] array;
        if (!s.markSupported()) {
            throw new IllegalArgumentException("The InputStream MUST support mark/reset methods !");
        }
        CRLInfo infos = new CRLInfo();
        this.consumeTagIntro(s);
        this.consumeTagIntro(s);
        int tag = DERUtil.readTag(s);
        int tagNo = DERUtil.readTagNumber(s, tag);
        int length = DERUtil.readLength(s);
        if (tagNo == 2) {
            array = this.readNbBytes(s, length);
            LOG.debug("TBSCertList -> version : {}", (Object)Hex.toHexString((byte[])array));
            infos.setVersion(this.rebuildASN1Integer(array).getValue().intValue() + 1);
            tag = DERUtil.readTag(s);
            tagNo = DERUtil.readTagNumber(s, tag);
            length = DERUtil.readLength(s);
        }
        if (tagNo == 16) {
            array = this.readNbBytes(s, length);
            LOG.debug("TBSCertList -> signatureAlgorithm : {}", (Object)Hex.toHexString((byte[])array));
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)this.rebuildASN1Sequence(array).getObjectAt(0);
            infos.setCertificateListSignatureAlgorithmOid(oid.getId());
            tag = DERUtil.readTag(s);
            tagNo = DERUtil.readTagNumber(s, tag);
            length = DERUtil.readLength(s);
        }
        if (tagNo == 16) {
            array = this.readNbBytes(s, length);
            LOG.debug("TBSCertList -> issuer : {}", (Object)Hex.toHexString((byte[])array));
            ASN1Sequence sequence = this.rebuildASN1Sequence(array);
            infos.setIssuer(new X500Principal(sequence.getEncoded()));
            tag = DERUtil.readTag(s);
            tagNo = DERUtil.readTagNumber(s, tag);
            length = DERUtil.readLength(s);
        }
        if (this.isDate(tagNo)) {
            array = this.readNbBytes(s, length);
            LOG.debug("TBSCertList -> thisUpdate : {}", (Object)Hex.toHexString((byte[])array));
            time = this.rebuildASN1Time(tagNo, array);
            infos.setThisUpdate(time.getDate());
            tag = DERUtil.readTag(s);
            tagNo = DERUtil.readTagNumber(s, tag);
            length = DERUtil.readLength(s);
        }
        if (this.isDate(tagNo)) {
            array = this.readNbBytes(s, length);
            LOG.debug("TBSCertList -> nextUpdate : {}", (Object)Hex.toHexString((byte[])array));
            time = this.rebuildASN1Time(tagNo, array);
            infos.setNextUpdate(time.getDate());
            tag = DERUtil.readTag(s);
            tagNo = DERUtil.readTagNumber(s, tag);
            length = DERUtil.readLength(s);
        }
        if (tagNo == 16) {
            s.mark(10);
            int intraTag = DERUtil.readTag(s);
            int intraTagNo = DERUtil.readTagNumber(s, intraTag);
            s.reset();
            if (intraTagNo == 16) {
                this.skip(s, length);
                LOG.debug("TBSCertList -> revokedCertificates : skipped (length={})", (Object)length);
                tag = DERUtil.readTag(s);
                tagNo = DERUtil.readTagNumber(s, tag);
                length = DERUtil.readLength(s);
            }
        }
        boolean bl = isTagged = (tag & 0x80) != 0;
        if (isTagged) {
            byte[] array2 = this.readNbBytes(s, length);
            LOG.debug("TBSCertList -> crlExtensions : {}", (Object)Hex.toHexString((byte[])array2));
            ASN1Sequence sequenceExtensions = (ASN1Sequence)ASN1Sequence.fromByteArray((byte[])array2);
            this.extractExtensions(sequenceExtensions, infos);
            tag = DERUtil.readTag(s);
            tagNo = DERUtil.readTagNumber(s, tag);
            length = DERUtil.readLength(s);
        }
        if (16 == tagNo) {
            byte[] array3 = this.readNbBytes(s, length);
            LOG.debug("CertificateList -> signatureAlgorithm : {}", (Object)Hex.toHexString((byte[])array3));
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)this.rebuildASN1Sequence(array3).getObjectAt(0);
            infos.setTbsSignatureAlgorithmOid(oid.getId());
            tag = DERUtil.readTag(s);
            tagNo = DERUtil.readTagNumber(s, tag);
            length = DERUtil.readLength(s);
        }
        if (3 == tagNo) {
            byte[] array4 = this.readNbBytes(s, length);
            LOG.debug("CertificateList -> signatureValue : {}", (Object)Hex.toHexString((byte[])array4));
            infos.setSignatureValue(this.rebuildASN1BitString(array4).getOctets());
        }
        return infos;
    }

    private boolean isDate(int tagNo) {
        return tagNo == 23 || tagNo == 24;
    }

    private byte[] readNbBytes(InputStream s, int length) throws IOException {
        byte[] array = new byte[length];
        if (Streams.readFully((InputStream)s, (byte[])array) != length) {
            LOG.warn("Cannot read expected length!");
        }
        return array;
    }

    private void skip(InputStream s, int length) throws IOException {
        int skipped = 0;
        while (skipped < length) {
            skipped = (int)((long)skipped + s.skip(length - skipped));
        }
    }

    private void extractExtensions(ASN1Sequence seq, CRLInfo infos) throws IOException {
        Enumeration enumSeq = seq.getObjects();
        while (enumSeq.hasMoreElements()) {
            ASN1Sequence extension = null;
            try {
                ASN1ObjectIdentifier oid;
                extension = (ASN1Sequence)enumSeq.nextElement();
                int seqSize = extension.size();
                if (seqSize == 2) {
                    oid = (ASN1ObjectIdentifier)extension.getObjectAt(0);
                    byte[] content = extension.getObjectAt(1).toASN1Primitive().getEncoded();
                    infos.addNonCriticalExtension(oid.getId(), content);
                    continue;
                }
                if (seqSize == 3) {
                    oid = (ASN1ObjectIdentifier)extension.getObjectAt(0);
                    ASN1Boolean isCritical = (ASN1Boolean)extension.getObjectAt(1);
                    byte[] content = extension.getObjectAt(2).toASN1Primitive().getEncoded();
                    if (isCritical.isTrue()) {
                        infos.addCriticalExtension(oid.getId(), content);
                        continue;
                    }
                    infos.addNonCriticalExtension(oid.getId(), content);
                    continue;
                }
                LOG.warn("Not supported format : {}", (Object)extension);
            }
            catch (Exception e) {
                LOG.warn("Cannot parse extension : {}", (Object)extension, (Object)e.getMessage());
            }
        }
    }

    private void consumeTagIntro(InputStream s) throws IOException {
        int tag = DERUtil.readTag(s);
        DERUtil.readTagNumber(s, tag);
        DERUtil.readLength(s);
    }

    private ASN1Sequence rebuildASN1Sequence(byte[] array) throws IOException {
        return (ASN1Sequence)this.rebuildASN1Primitive(48, array);
    }

    private ASN1BitString rebuildASN1BitString(byte[] array) throws IOException {
        return (ASN1BitString)this.rebuildASN1Primitive(3, array);
    }

    private ASN1Integer rebuildASN1Integer(byte[] array) throws IOException {
        return (ASN1Integer)this.rebuildASN1Primitive(2, array);
    }

    private Time rebuildASN1Time(int tagNo, byte[] array) throws IOException {
        return Time.getInstance((Object)this.rebuildASN1Primitive(tagNo, array));
    }

    private ASN1Primitive rebuildASN1Primitive(int tagNo, byte[] array) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            baos.write(tagNo);
            DERUtil.writeLength(baos, array.length);
            baos.write(array);
            ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray((byte[])baos.toByteArray());
            return aSN1Primitive;
        }
    }
}

