/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.crl;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.crl.AbstractCRLUtils;
import eu.europa.esig.dss.crl.CRLInfo;
import eu.europa.esig.dss.crl.CRLParser;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.crl.ICRLUtils;
import eu.europa.esig.dss.crl.PemToDerConverter;
import eu.europa.esig.dss.tsl.KeyUsageBit;
import eu.europa.esig.dss.x509.CertificateToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.X509CRLEntry;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLUtilsStreamImpl
extends AbstractCRLUtils
implements ICRLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CRLUtilsStreamImpl.class);

    public CRLValidity isValidCRL(InputStream crlStream, CertificateToken issuerToken) throws IOException {
        CRLValidity crlValidity = new CRLValidity();
        try (ByteArrayOutputStream baos = this.getDERContent(crlStream);){
            CRLInfo crlInfos = this.getCrlInfos(baos);
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forOID((String)crlInfos.getCertificateListSignatureAlgorithmOid());
            byte[] digest = this.recomputeDigest(baos, this.getMessageDigest(signatureAlgorithm.getDigestAlgorithm()));
            crlValidity.setCrlEncoded(baos.toByteArray());
            crlValidity.setSignatureAlgorithm(signatureAlgorithm);
            crlValidity.setThisUpdate(crlInfos.getThisUpdate());
            crlValidity.setNextUpdate(crlInfos.getNextUpdate());
            this.checkCriticalExtensions(crlValidity, crlInfos.getCriticalExtensions().keySet(), crlInfos.getCriticalExtension(Extension.issuingDistributionPoint.getId()));
            this.extractExpiredCertsOnCRL(crlValidity, crlInfos.getNonCriticalExtension(Extension.expiredCertsOnCRL.getId()));
            X500Principal x509CRLIssuerX500Principal = crlInfos.getIssuer();
            X500Principal issuerTokenSubjectX500Principal = issuerToken.getSubjectX500Principal();
            if (x509CRLIssuerX500Principal.equals(issuerTokenSubjectX500Principal)) {
                crlValidity.setIssuerX509PrincipalMatches(true);
            }
            this.checkSignatureValue(crlValidity, crlInfos.getSignatureValue(), digest, issuerToken);
        }
        return crlValidity;
    }

    private MessageDigest getMessageDigest(DigestAlgorithm digestAlgorithm) {
        try {
            return MessageDigest.getInstance(digestAlgorithm.getOid(), "BC");
        }
        catch (GeneralSecurityException e) {
            throw new DSSException("Cannot generate a MessageDigest", (Throwable)e);
        }
    }

    public X509CRLEntry getRevocationInfo(CRLValidity crlValidity, BigInteger serialNumber) {
        CRLParser parser = new CRLParser();
        X509CRLEntry crlEntry = null;
        try (InputStream is = crlValidity.getCrlInputStream();){
            crlEntry = parser.retrieveRevocationInfo(is, serialNumber);
        }
        catch (IOException e) {
            LOG.error("Unable to retrieve the revocation status", (Throwable)e);
        }
        return crlEntry;
    }

    private void checkSignatureValue(CRLValidity crlValidity, byte[] signatureValue, byte[] expectedDigest, CertificateToken signer) {
        byte[] extractedDigest = null;
        try {
            extractedDigest = this.getSignedDigest(signatureValue, signer);
        }
        catch (IOException | GeneralSecurityException e) {
            crlValidity.setSignatureInvalidityReason(e.getClass().getSimpleName() + " - " + e.getMessage());
            return;
        }
        if (Arrays.equals(expectedDigest, extractedDigest)) {
            crlValidity.setSignatureIntact(true);
            crlValidity.setIssuerToken(signer);
            crlValidity.setCrlSignKeyUsage(signer.checkKeyUsage(KeyUsageBit.crlSign));
        } else {
            String message = MessageFormat.format("Signed digest '{0}' and computed digest '{1} 'don't match", extractedDigest == null ? "" : Hex.toHexString((byte[])extractedDigest), expectedDigest == null ? "" : Hex.toHexString((byte[])expectedDigest));
            crlValidity.setSignatureInvalidityReason(message);
            LOG.warn(message);
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] recomputeDigest(ByteArrayOutputStream baos, MessageDigest messageDigest) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private CRLInfo getCrlInfos(ByteArrayOutputStream baos) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] getSignedDigest(byte[] signatureValue, CertificateToken signer) throws GeneralSecurityException, IOException {
        PublicKey publicKey = signer.getPublicKey();
        Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
        cipher.init(2, publicKey);
        byte[] decrypted = cipher.doFinal(signatureValue);
        try (ASN1InputStream inputDecrypted = new ASN1InputStream(decrypted);){
            ASN1Sequence seqDecrypt = (ASN1Sequence)inputDecrypted.readObject();
            DigestInfo digestInfo = new DigestInfo(seqDecrypt);
            byte[] byArray = digestInfo.getDigest();
            return byArray;
        }
    }

    private ByteArrayOutputStream getDERContent(InputStream crlStream) throws IOException {
        int n;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int first = crlStream.read();
        baos.write(first);
        byte[] buffer = new byte[4096];
        while (-1 != (n = crlStream.read(buffer))) {
            baos.write(buffer, 0, n);
        }
        if (this.isPemEncoded(first)) {
            baos = PemToDerConverter.convert(baos);
        } else if (!this.isDerEncoded(first)) {
            throw new DSSException("Unsupported CRL");
        }
        return baos;
    }

    private boolean isPemEncoded(int first) {
        return 45 == (byte)first;
    }

    private boolean isDerEncoded(int first) {
        return 48 == first;
    }
}

