/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.crl.stream.impl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1InputStream;

final class DERUtil {
    private DERUtil() {
    }

    public static int readTag(InputStream is) throws IOException {
        return is.read();
    }

    public static int readLength(InputStream s) throws IOException {
        try (ASN1InputStreamDSS dssIS = new ASN1InputStreamDSS(s, Integer.MAX_VALUE);){
            int n = dssIS.readLength();
            return n;
        }
    }

    public static void writeLength(OutputStream os, int length) throws IOException {
        if (length > 127) {
            int size = 1;
            int val = length;
            while ((val >>>= 8) != 0) {
                ++size;
            }
            os.write((byte)(size | 0x80));
            for (int i = (size - 1) * 8; i >= 0; i -= 8) {
                os.write((byte)(length >> i));
            }
        } else {
            os.write((byte)length);
        }
    }

    public static int readTagNumber(InputStream s, int tag) throws IOException {
        int tagNo = tag & 0x1F;
        if (tagNo == 31) {
            tagNo = 0;
            int b = s.read();
            if ((b & 0x7F) == 0) {
                throw new IOException("corrupted stream - invalid high tag number found");
            }
            while (b >= 0 && (b & 0x80) != 0) {
                tagNo |= b & 0x7F;
                tagNo <<= 7;
                b = s.read();
            }
            if (b < 0) {
                throw new EOFException("EOF found inside tag value.");
            }
            tagNo |= b & 0x7F;
        }
        return tagNo;
    }

    private static class ASN1InputStreamDSS
    extends ASN1InputStream {
        public ASN1InputStreamDSS(InputStream input, int limit) {
            super(input, limit);
        }

        protected int readLength() throws IOException {
            return super.readLength();
        }

        public void close() throws IOException {
        }
    }
}

