/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.detailedreport;

import eu.europa.esig.dss.detailedreport.DetailedReportMessageCollector;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificate;
import eu.europa.esig.dss.detailedreport.jaxb.XmlChainItem;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationTimestampQualification;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.enumerations.CertificateQualification;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignatureQualification;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TimestampQualification;
import eu.europa.esig.dss.enumerations.ValidationTime;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DetailedReport {
    private final XmlDetailedReport jaxbDetailedReport;
    private DetailedReportMessageCollector messageCollector;

    public DetailedReport(XmlDetailedReport jaxbDetailedReport) {
        this.jaxbDetailedReport = jaxbDetailedReport;
    }

    public Indication getBasicBuildingBlocksIndication(String tokenId) {
        XmlBasicBuildingBlocks bbb = this.getBasicBuildingBlockById(tokenId);
        if (bbb != null) {
            return bbb.getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getBasicBuildingBlocksSubIndication(String tokenId) {
        XmlBasicBuildingBlocks bbb = this.getBasicBuildingBlockById(tokenId);
        if (bbb != null) {
            return bbb.getConclusion().getSubIndication();
        }
        return null;
    }

    public List<String> getBasicBuildingBlocksCertChain(String tokenId) {
        List<XmlChainItem> chainItems;
        LinkedList<String> certIds = new LinkedList<String>();
        XmlBasicBuildingBlocks bbb = this.getBasicBuildingBlockById(tokenId);
        if (bbb != null && (chainItems = bbb.getCertificateChain().getChainItem()) != null) {
            for (XmlChainItem chainItem : chainItems) {
                certIds.add(chainItem.getId());
            }
        }
        return certIds;
    }

    public XmlBasicBuildingBlocks getBasicBuildingBlockById(String tokenId) {
        List<XmlBasicBuildingBlocks> basicBuildingBlocks = this.jaxbDetailedReport.getBasicBuildingBlocks();
        if (basicBuildingBlocks != null) {
            for (XmlBasicBuildingBlocks xmlBasicBuildingBlocks : basicBuildingBlocks) {
                if (!tokenId.equals(xmlBasicBuildingBlocks.getId())) continue;
                return xmlBasicBuildingBlocks;
            }
        }
        return null;
    }

    public int getBasicBuildingBlocksNumber() {
        return this.jaxbDetailedReport.getBasicBuildingBlocks().size();
    }

    public String getBasicBuildingBlocksSignatureId(int index) {
        XmlBasicBuildingBlocks bbb;
        List<XmlBasicBuildingBlocks> bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        if (bbbs != null && bbbs.size() >= index && (bbb = this.jaxbDetailedReport.getBasicBuildingBlocks().get(index)) != null) {
            return bbb.getId();
        }
        return null;
    }

    public List<String> getSignatureIds() {
        ArrayList<String> result = new ArrayList<String>();
        List<XmlBasicBuildingBlocks> bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks bbb : bbbs) {
            if (Context.SIGNATURE != bbb.getType() && Context.COUNTER_SIGNATURE != bbb.getType()) continue;
            result.add(bbb.getId());
        }
        return result;
    }

    public String getFirstSignatureId() {
        List<String> result = this.getSignatureIds();
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    public List<String> getTimestampIds() {
        ArrayList<String> result = new ArrayList<String>();
        List<XmlBasicBuildingBlocks> bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks bbb : bbbs) {
            if (Context.TIMESTAMP != bbb.getType()) continue;
            result.add(bbb.getId());
        }
        return result;
    }

    public List<String> getRevocationIds() {
        ArrayList<String> result = new ArrayList<String>();
        List<XmlBasicBuildingBlocks> bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks bbb : bbbs) {
            if (Context.REVOCATION != bbb.getType()) continue;
            result.add(bbb.getId());
        }
        return result;
    }

    public Date getBestSignatureTime(String signatureId) {
        XmlProofOfExistence proofOfExistence = this.getBestProofOfExistence(signatureId);
        if (proofOfExistence != null) {
            return proofOfExistence.getTime();
        }
        return null;
    }

    public XmlProofOfExistence getBestProofOfExistence(String signatureId) {
        XmlSignature xmlSignature = this.getXmlSignatureById(signatureId);
        if (xmlSignature != null) {
            if (xmlSignature.getValidationProcessArchivalData() != null) {
                return xmlSignature.getValidationProcessArchivalData().getProofOfExistence();
            }
            if (xmlSignature.getValidationProcessLongTermData() != null) {
                return xmlSignature.getValidationProcessLongTermData().getProofOfExistence();
            }
            if (xmlSignature.getValidationProcessBasicSignature() != null) {
                return xmlSignature.getValidationProcessBasicSignature().getProofOfExistence();
            }
        }
        return null;
    }

    public Indication getBasicValidationIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessBasicSignature() != null && signature.getValidationProcessBasicSignature().getConclusion() != null) {
            return signature.getValidationProcessBasicSignature().getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getBasicValidationSubIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessBasicSignature() != null && signature.getValidationProcessBasicSignature().getConclusion() != null) {
            return signature.getValidationProcessBasicSignature().getConclusion().getSubIndication();
        }
        return null;
    }

    public Indication getTimestampValidationIndication(String timestampId) {
        XmlValidationProcessTimestamp timestampValidationById = this.getTimestampValidationById(timestampId);
        if (timestampValidationById != null && timestampValidationById.getConclusion() != null) {
            return timestampValidationById.getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getTimestampValidationSubIndication(String timestampId) {
        XmlValidationProcessTimestamp timestampValidationById = this.getTimestampValidationById(timestampId);
        if (timestampValidationById != null && timestampValidationById.getConclusion() != null) {
            return timestampValidationById.getConclusion().getSubIndication();
        }
        return null;
    }

    public Indication getLongTermValidationIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessLongTermData() != null && signature.getValidationProcessLongTermData().getConclusion() != null) {
            return signature.getValidationProcessLongTermData().getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getLongTermValidationSubIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessLongTermData() != null && signature.getValidationProcessLongTermData().getConclusion() != null) {
            return signature.getValidationProcessLongTermData().getConclusion().getSubIndication();
        }
        return null;
    }

    public Indication getArchiveDataValidationIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessArchivalData() != null && signature.getValidationProcessArchivalData().getConclusion() != null) {
            return signature.getValidationProcessArchivalData().getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getArchiveDataValidationSubIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessArchivalData() != null && signature.getValidationProcessArchivalData().getConclusion() != null) {
            return signature.getValidationProcessArchivalData().getConclusion().getSubIndication();
        }
        return null;
    }

    public SignatureQualification getSignatureQualification(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationSignatureQualification() != null) {
            return signature.getValidationSignatureQualification().getSignatureQualification();
        }
        return null;
    }

    public TimestampQualification getTimestampQualification(String timestampId) {
        XmlValidationTimestampQualification timestampQualif = this.getXmlTimestampQualificationById(timestampId);
        if (timestampQualif != null) {
            return timestampQualif.getTimestampQualification();
        }
        return null;
    }

    private XmlValidationTimestampQualification getXmlTimestampQualificationById(String timestampId) {
        XmlTimestamp timestamp = this.getXmlTimestampById(timestampId);
        if (timestamp != null) {
            return timestamp.getValidationTimestampQualification();
        }
        return null;
    }

    private XmlValidationProcessTimestamp getTimestampValidationById(String timestampId) {
        XmlTimestamp timestamp = this.getXmlTimestampById(timestampId);
        if (timestamp != null) {
            return timestamp.getValidationProcessTimestamp();
        }
        return null;
    }

    public XmlTimestamp getXmlTimestampById(String timestampId) {
        for (XmlTimestamp xmlTimestamp : this.getIndependentTimestamps()) {
            if (!xmlTimestamp.getId().equals(timestampId)) continue;
            return xmlTimestamp;
        }
        List<XmlSignature> signatures = this.getSignatures();
        for (XmlSignature xmlSignature : signatures) {
            List<XmlTimestamp> timestamps = xmlSignature.getTimestamp();
            for (XmlTimestamp xmlTimestamp : timestamps) {
                if (!xmlTimestamp.getId().equals(timestampId)) continue;
                return xmlTimestamp;
            }
        }
        return null;
    }

    public XmlSignature getXmlSignatureById(String signatureId) {
        List<XmlSignature> signatures = this.getSignatures();
        if (signatures != null) {
            for (XmlSignature xmlSignature : signatures) {
                if (!signatureId.equals(xmlSignature.getId())) continue;
                return xmlSignature;
            }
        }
        return null;
    }

    public XmlCertificate getXmlCertificateById(String certificateId) {
        List<XmlCertificate> certificates = this.getCertificates();
        if (certificates != null) {
            for (XmlCertificate xmlCertificate : certificates) {
                if (!certificateId.equals(xmlCertificate.getId())) continue;
                return xmlCertificate;
            }
        }
        return null;
    }

    public List<XmlSignature> getSignatures() {
        ArrayList<XmlSignature> result = new ArrayList<XmlSignature>();
        for (Serializable element : this.jaxbDetailedReport.getSignatureOrTimestampOrCertificate()) {
            if (!(element instanceof XmlSignature)) continue;
            result.add((XmlSignature)element);
        }
        return result;
    }

    public List<XmlTimestamp> getIndependentTimestamps() {
        ArrayList<XmlTimestamp> result = new ArrayList<XmlTimestamp>();
        for (Serializable element : this.jaxbDetailedReport.getSignatureOrTimestampOrCertificate()) {
            if (!(element instanceof XmlTimestamp)) continue;
            result.add((XmlTimestamp)element);
        }
        return result;
    }

    public List<XmlCertificate> getCertificates() {
        ArrayList<XmlCertificate> result = new ArrayList<XmlCertificate>();
        for (Serializable element : this.jaxbDetailedReport.getSignatureOrTimestampOrCertificate()) {
            if (!(element instanceof XmlCertificate)) continue;
            result.add((XmlCertificate)element);
        }
        return result;
    }

    public XmlTLAnalysis getTLAnalysisById(String tlId) {
        List<XmlTLAnalysis> tlAnalysisBlocks = this.jaxbDetailedReport.getTLAnalysis();
        if (tlAnalysisBlocks != null) {
            for (XmlTLAnalysis xmlTLAnalysis : tlAnalysisBlocks) {
                if (!tlId.equals(xmlTLAnalysis.getId())) continue;
                return xmlTLAnalysis;
            }
        }
        return null;
    }

    public XmlDetailedReport getJAXBModel() {
        return this.jaxbDetailedReport;
    }

    public CertificateQualification getCertificateQualificationAtIssuance(String certificateId) {
        return this.getCertificateQualification(ValidationTime.CERTIFICATE_ISSUANCE_TIME, certificateId);
    }

    public CertificateQualification getCertificateQualificationAtValidation(String certificateId) {
        return this.getCertificateQualification(ValidationTime.VALIDATION_TIME, certificateId);
    }

    private CertificateQualification getCertificateQualification(ValidationTime validationTime, String certificateId) {
        List<XmlValidationCertificateQualification> validationCertificateQualifications;
        XmlCertificate certificate = this.getXmlCertificateById(certificateId);
        if (certificate != null && (validationCertificateQualifications = certificate.getValidationCertificateQualification()) != null) {
            for (XmlValidationCertificateQualification validationCertificateQualification : validationCertificateQualifications) {
                if (validationTime != validationCertificateQualification.getValidationTime()) continue;
                return validationCertificateQualification.getCertificateQualification();
            }
        }
        return CertificateQualification.NA;
    }

    public XmlConclusion getCertificateXCVConclusion(String certificateId) {
        List<XmlCertificate> certificates = this.getCertificates();
        if (certificates == null || certificates.size() == 0) {
            throw new UnsupportedOperationException("Only supported in report for certificate");
        }
        List<XmlBasicBuildingBlocks> basicBuildingBlocks = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks xmlBasicBuildingBlocks : basicBuildingBlocks) {
            XmlXCV xcv = xmlBasicBuildingBlocks.getXCV();
            if (xcv == null) continue;
            List<XmlSubXCV> subXCV = xcv.getSubXCV();
            for (XmlSubXCV xmlSubXCV : subXCV) {
                if (!certificateId.equals(xmlSubXCV.getId())) continue;
                return xmlSubXCV.getConclusion();
            }
            return xcv.getConclusion();
        }
        return null;
    }

    public Indication getFinalIndication(String signatureId) {
        return this.getXmlSignatureById(signatureId).getConclusion().getIndication();
    }

    public SubIndication getFinalSubIndication(String signatureId) {
        return this.getXmlSignatureById(signatureId).getConclusion().getSubIndication();
    }

    public XmlConstraintsConclusion getHighestConclusion(String signatureId) {
        XmlSignature xmlSignature = this.getXmlSignatureById(signatureId);
        if (xmlSignature.getValidationProcessArchivalData() != null) {
            return xmlSignature.getValidationProcessArchivalData();
        }
        if (xmlSignature.getValidationProcessLongTermData() != null) {
            return xmlSignature.getValidationProcessLongTermData();
        }
        return xmlSignature.getValidationProcessBasicSignature();
    }

    public XmlSubXCV getSigningCertificate(String bbbId) {
        List<XmlSubXCV> subXCVs;
        XmlXCV xcv;
        XmlBasicBuildingBlocks basicBuildingBlocks = this.getBasicBuildingBlockById(bbbId);
        if (basicBuildingBlocks != null && (xcv = basicBuildingBlocks.getXCV()) != null && (subXCVs = xcv.getSubXCV()) != null && subXCVs.size() > 0) {
            return subXCVs.get(0);
        }
        return null;
    }

    DetailedReportMessageCollector getMessageCollector() {
        if (this.messageCollector == null) {
            this.messageCollector = new DetailedReportMessageCollector(this);
        }
        return this.messageCollector;
    }

    public Set<String> getErrors(String signatureId) {
        return this.getMessageCollector().getErrors(signatureId);
    }

    public Set<String> getWarnings(String signatureId) {
        return this.getMessageCollector().getWarnings(signatureId);
    }

    public Set<String> getInfos(String signatureId) {
        return this.getMessageCollector().getInfos(signatureId);
    }
}

