/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.CertificateRefWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.FoundCertificatesProxy;
import eu.europa.esig.dss.diagnostic.FoundRevocationsProxy;
import eu.europa.esig.dss.diagnostic.RelatedCertificateWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlBasicSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlChainItem;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.diagnostic.jaxb.XmlModification;
import eu.europa.esig.dss.diagnostic.jaxb.XmlModificationDetection;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFRevision;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSigningCertificate;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractTokenProxy
implements TokenProxy {
    protected abstract XmlBasicSignature getCurrentBasicSignature();

    protected abstract List<XmlChainItem> getCurrentCertificateChain();

    protected abstract XmlSigningCertificate getCurrentSigningCertificate();

    @Override
    public FoundCertificatesProxy foundCertificates() {
        return new FoundCertificatesProxy(null);
    }

    @Override
    public FoundRevocationsProxy foundRevocations() {
        return new FoundRevocationsProxy(null);
    }

    @Override
    public List<XmlDigestMatcher> getDigestMatchers() {
        return Collections.emptyList();
    }

    @Override
    public List<CertificateWrapper> getCertificateChain() {
        ArrayList<CertificateWrapper> result = new ArrayList<CertificateWrapper>();
        List<XmlChainItem> certificateChain = this.getCurrentCertificateChain();
        if (certificateChain != null) {
            for (XmlChainItem xmlChainCertificate : certificateChain) {
                result.add(new CertificateWrapper(xmlChainCertificate.getCertificate()));
            }
        }
        return result;
    }

    @Override
    public boolean isSignatureIntact() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            Boolean signatureIntact = basicSignature.isSignatureIntact();
            return signatureIntact != null && signatureIntact != false;
        }
        return false;
    }

    @Override
    public boolean isSignatureValid() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            Boolean signatureValid = basicSignature.isSignatureValid();
            return signatureValid != null && signatureValid != false;
        }
        return false;
    }

    @Override
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            return basicSignature.getEncryptionAlgoUsedToSignThisToken();
        }
        return null;
    }

    @Override
    public DigestAlgorithm getDigestAlgorithm() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            return basicSignature.getDigestAlgoUsedToSignThisToken();
        }
        return null;
    }

    @Override
    public MaskGenerationFunction getMaskGenerationFunction() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            return basicSignature.getMaskGenerationFunctionUsedToSignThisToken();
        }
        return null;
    }

    @Override
    public String getKeyLengthUsedToSignThisToken() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            return basicSignature.getKeyLengthUsedToSignThisToken();
        }
        return "";
    }

    @Override
    public CertificateWrapper getSigningCertificate() {
        XmlSigningCertificate currentSigningCertificate = this.getCurrentSigningCertificate();
        if (currentSigningCertificate != null && currentSigningCertificate.getCertificate() != null) {
            return new CertificateWrapper(currentSigningCertificate.getCertificate());
        }
        return null;
    }

    @Override
    public byte[] getSigningCertificatePublicKey() {
        XmlSigningCertificate currentSigningCertificate = this.getCurrentSigningCertificate();
        if (currentSigningCertificate != null) {
            return currentSigningCertificate.getPublicKey();
        }
        return null;
    }

    @Override
    public boolean isSigningCertificateReferencePresent() {
        return this.getSigningCertificateReferences().size() > 0;
    }

    @Override
    public boolean isSigningCertificateReferenceUnique() {
        return this.getSigningCertificateReferences().size() == 1;
    }

    @Override
    public CertificateRefWrapper getSigningCertificateReference() {
        List<CertificateRefWrapper> signingCertificateReferences = this.foundCertificates().getRelatedCertificateRefsByRefOrigin(CertificateRefOrigin.SIGNING_CERTIFICATE);
        if (signingCertificateReferences.size() > 0) {
            CertificateWrapper signingCertificate = this.getSigningCertificate();
            if (signingCertificate != null) {
                for (RelatedCertificateWrapper relatedCertificate : this.foundCertificates().getRelatedCertificates()) {
                    if (!signingCertificate.getId().equals(relatedCertificate.getId()) || relatedCertificate.getReferences().size() <= 0) continue;
                    return relatedCertificate.getReferences().iterator().next();
                }
            }
        } else {
            List<CertificateRefWrapper> orphanSigningCertificateReferences = this.foundCertificates().getOrphanCertificateRefsByRefOrigin(CertificateRefOrigin.SIGNING_CERTIFICATE);
            if (orphanSigningCertificateReferences.size() > 0) {
                return orphanSigningCertificateReferences.iterator().next();
            }
        }
        return null;
    }

    @Override
    public List<CertificateRefWrapper> getSigningCertificateReferences() {
        ArrayList<CertificateRefWrapper> certificateRefs = new ArrayList<CertificateRefWrapper>();
        certificateRefs.addAll(this.foundCertificates().getRelatedCertificateRefsByRefOrigin(CertificateRefOrigin.SIGNING_CERTIFICATE));
        certificateRefs.addAll(this.foundCertificates().getOrphanCertificateRefsByRefOrigin(CertificateRefOrigin.SIGNING_CERTIFICATE));
        return certificateRefs;
    }

    @Override
    public boolean isTrustedChain() {
        List<CertificateWrapper> certificateChain = this.getCertificateChain();
        for (CertificateWrapper certificate : certificateChain) {
            List<CertificateSourceType> currentCertSources = certificate.getSources();
            if (!currentCertSources.contains(CertificateSourceType.TRUSTED_STORE) && !currentCertSources.contains(CertificateSourceType.TRUSTED_LIST)) continue;
            return true;
        }
        return false;
    }

    public boolean isCertificateChainFromTrustedStore() {
        for (CertificateWrapper certificate : this.getCertificateChain()) {
            if (!certificate.getSources().contains(CertificateSourceType.TRUSTED_STORE)) continue;
            return true;
        }
        return false;
    }

    public abstract byte[] getBinaries();

    protected boolean arePdfModificationsDetected(XmlPDFRevision pdfRevision) {
        XmlModificationDetection modificationDetection;
        if (pdfRevision != null && (modificationDetection = pdfRevision.getModificationDetection()) != null) {
            return modificationDetection.getAnnotationOverlap().size() != 0 || modificationDetection.getVisualDifference().size() != 0;
        }
        return false;
    }

    protected List<BigInteger> getPdfAnnotationsOverlapConcernedPages(XmlPDFRevision pdfRevision) {
        XmlModificationDetection modificationDetection;
        if (pdfRevision != null && (modificationDetection = pdfRevision.getModificationDetection()) != null) {
            List<XmlModification> annotationOverlap = modificationDetection.getAnnotationOverlap();
            return this.getConcernedPages(annotationOverlap);
        }
        return Collections.emptyList();
    }

    protected List<BigInteger> getPdfVisualDifferenceConcernedPages(XmlPDFRevision pdfRevision) {
        XmlModificationDetection modificationDetection;
        if (pdfRevision != null && (modificationDetection = pdfRevision.getModificationDetection()) != null) {
            List<XmlModification> visualDifference = modificationDetection.getVisualDifference();
            return this.getConcernedPages(visualDifference);
        }
        return Collections.emptyList();
    }

    protected List<BigInteger> getPdfPageDifferenceConcernedPages(XmlPDFRevision pdfRevision) {
        XmlModificationDetection modificationDetection;
        if (pdfRevision != null && (modificationDetection = pdfRevision.getModificationDetection()) != null) {
            List<XmlModification> pageDifference = modificationDetection.getPageDifference();
            return this.getConcernedPages(pageDifference);
        }
        return Collections.emptyList();
    }

    private List<BigInteger> getConcernedPages(List<XmlModification> xmlModifications) {
        ArrayList<BigInteger> pages = new ArrayList<BigInteger>();
        for (XmlModification modification : xmlModifications) {
            pages.add(modification.getPage());
        }
        return pages;
    }

    public String toString() {
        return "Token Id='" + this.getId() + "'";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTokenProxy other = (AbstractTokenProxy)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }
}

