/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.SignatureValidationContext;
import java.util.Date;
import java.util.List;

public class SignatureRequirementsChecker {
    private final CertificateVerifier certificateVerifier;
    private final AbstractSignatureParameters<?> signatureParameters;

    public SignatureRequirementsChecker(CertificateVerifier certificateVerifier, AbstractSignatureParameters<?> signatureParameters) {
        this.certificateVerifier = certificateVerifier;
        this.signatureParameters = signatureParameters;
    }

    public void assertSigningCertificateIsValid(CertificateToken certificateToken) {
        this.assertSigningCertificateIsYetValid(certificateToken);
        this.assertSigningCertificateIsNotExpired(certificateToken);
        this.assertCertificatesAreNotRevoked(certificateToken);
    }

    public void assertSigningCertificateIsValid(AdvancedSignature signature) {
        CertificateToken signingCertificate = signature.getSigningCertificateToken();
        this.assertSigningCertificateIsYetValid(signingCertificate);
        this.assertSigningCertificateIsNotExpired(signingCertificate);
        this.assertCertificatesAreNotRevoked(signature);
    }

    private void assertSigningCertificateIsYetValid(CertificateToken certificateToken) {
        if (this.signatureParameters.isSignWithNotYetValidCertificate()) {
            return;
        }
        if (certificateToken == null) {
            throw new IllegalInputException("Signing certificate token was not found! Unable to verify its validity range. Use method setSignWithNotYetValidCertificate(true) to skip the check.");
        }
        Date notBefore = certificateToken.getNotBefore();
        Date notAfter = certificateToken.getNotAfter();
        Date signingDate = this.signatureParameters.bLevel().getSigningDate();
        if (signingDate.before(notBefore)) {
            throw new IllegalArgumentException(String.format("The signing certificate (notBefore : %s, notAfter : %s) is not yet valid at signing time %s! Change signing certificate or use method setSignWithNotYetValidCertificate(true).", notBefore.toString(), notAfter.toString(), signingDate.toString()));
        }
    }

    private void assertSigningCertificateIsNotExpired(CertificateToken certificateToken) {
        if (this.signatureParameters.isSignWithExpiredCertificate()) {
            return;
        }
        if (certificateToken == null) {
            throw new IllegalInputException("Signing certificate token was not found! Unable to verify its validity range. Use method setSignWithExpiredCertificate(true) to skip the check.");
        }
        Date notBefore = certificateToken.getNotBefore();
        Date notAfter = certificateToken.getNotAfter();
        Date signingDate = this.signatureParameters.bLevel().getSigningDate();
        if (signingDate.after(notAfter)) {
            throw new IllegalArgumentException(String.format("The signing certificate (notBefore : %s, notAfter : %s) is expired at signing time %s! Change signing certificate or use method setSignWithExpiredCertificate(true).", notBefore.toString(), notAfter.toString(), signingDate.toString()));
        }
    }

    private void assertCertificatesAreNotRevoked(CertificateToken certificateToken) {
        if (!this.signatureParameters.isCheckCertificateRevocation()) {
            return;
        }
        SignatureValidationContext validationContext = new SignatureValidationContext();
        validationContext.initialize(this.certificateVerifier);
        validationContext.setCurrentTime(this.signatureParameters.bLevel().getSigningDate());
        List<CertificateToken> certificateChain = this.signatureParameters.getCertificateChain();
        if (Utils.isCollectionEmpty(certificateChain)) {
            throw new NullPointerException("Certificate chain shall be provided for a revocation check! Please use parameters.setCertificateChain(...) method to provide a certificate chain.");
        }
        validationContext.addCertificateTokenForVerification(certificateToken);
        for (CertificateToken certificate : certificateChain) {
            validationContext.addCertificateTokenForVerification(certificate);
        }
        validationContext.validate();
        validationContext.checkAllRequiredRevocationDataPresent();
        validationContext.checkAllCertificatesValid();
    }

    private void assertCertificatesAreNotRevoked(AdvancedSignature signature) {
        if (!this.signatureParameters.isCheckCertificateRevocation()) {
            return;
        }
        SignatureValidationContext validationContext = new SignatureValidationContext();
        validationContext.initialize(this.certificateVerifier);
        validationContext.setCurrentTime(this.signatureParameters.bLevel().getSigningDate());
        validationContext.addSignatureForVerification(signature);
        validationContext.validate();
        validationContext.checkAllRequiredRevocationDataPresent();
        validationContext.checkAllCertificatesValid();
    }
}

