/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.jaxb.diagnostic.DiagnosticData;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ContainerInfo;
import eu.europa.esig.dss.validation.DiagnosticDataBuilder;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.SignaturePolicyProvider;
import eu.europa.esig.dss.validation.SignatureScopeFinder;
import eu.europa.esig.dss.validation.SignatureValidationContext;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.ValidationResourceManager;
import eu.europa.esig.dss.validation.executor.CustomProcessExecutor;
import eu.europa.esig.dss.validation.executor.ProcessExecutor;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.policy.Context;
import eu.europa.esig.dss.validation.policy.EtsiValidationPolicy;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.reports.Reports;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateSourceType;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.crl.ListCRLSource;
import eu.europa.esig.dss.x509.ocsp.ListOCSPSource;
import eu.europa.esig.jaxb.policy.ConstraintsParameters;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignedDocumentValidator
implements DocumentValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SignedDocumentValidator.class);
    protected ProcessExecutor processExecutor = null;
    protected CertificatePool validationCertPool = null;
    protected DSSDocument document;
    protected List<DSSDocument> detachedContents = new ArrayList<DSSDocument>();
    protected CertificateToken providedSigningCertificateToken = null;
    protected CertificateVerifier certificateVerifier;
    protected final SignatureScopeFinder signatureScopeFinder;
    protected SignaturePolicyProvider signaturePolicyProvider;
    private ValidationLevel validationLevel = ValidationLevel.ARCHIVAL_DATA;
    private static List<Class<SignedDocumentValidator>> registredDocumentValidators = new ArrayList<Class<SignedDocumentValidator>>();

    private static void registerDocumentValidator(String type, String clazzToFind) {
        try {
            Class<?> documentValidator = Class.forName(clazzToFind);
            registredDocumentValidators.add(documentValidator);
            LOG.info("Validator '" + documentValidator.getName() + "' is registred");
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Validator not found for signature type " + type);
        }
    }

    protected SignedDocumentValidator(SignatureScopeFinder signatureScopeFinder) {
        this.signatureScopeFinder = signatureScopeFinder;
    }

    public static SignedDocumentValidator fromDocument(DSSDocument dssDocument) {
        if (Utils.isCollectionEmpty(registredDocumentValidators)) {
            throw new DSSException("No validator registred");
        }
        for (Class<SignedDocumentValidator> clazz : registredDocumentValidators) {
            try {
                Constructor<SignedDocumentValidator> defaultAndPrivateConstructor = clazz.getDeclaredConstructor(new Class[0]);
                defaultAndPrivateConstructor.setAccessible(true);
                SignedDocumentValidator validator = defaultAndPrivateConstructor.newInstance(new Object[0]);
                if (!validator.isSupported(dssDocument)) continue;
                Constructor<SignedDocumentValidator> constructor = clazz.getDeclaredConstructor(DSSDocument.class);
                return constructor.newInstance(dssDocument);
            }
            catch (Exception e) {
                LOG.error("Cannot instanciate class '" + clazz.getName() + "' : " + e.getMessage(), (Throwable)e);
            }
        }
        throw new DSSException("Document format not recognized/handled");
    }

    public abstract boolean isSupported(DSSDocument var1);

    @Override
    public void defineSigningCertificate(CertificateToken token) {
        if (token == null) {
            throw new NullPointerException("Token is not defined");
        }
        if (this.validationCertPool == null) {
            throw new NullPointerException("Certificate pool is not instantiated");
        }
        this.providedSigningCertificateToken = this.validationCertPool.getInstance(token, CertificateSourceType.OTHER);
    }

    @Override
    public void setCertificateVerifier(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
        if (this.validationCertPool == null) {
            this.validationCertPool = certificateVerifier.createValidationPool();
        }
    }

    @Override
    public void setDetachedContents(List<DSSDocument> detachedContents) {
        this.detachedContents = detachedContents;
    }

    @Override
    public void setValidationLevel(ValidationLevel validationLevel) {
        this.validationLevel = validationLevel;
    }

    @Override
    public Reports validateDocument() {
        return this.validateDocument((InputStream)null);
    }

    @Override
    public Reports validateDocument(URL validationPolicyURL) {
        if (validationPolicyURL == null) {
            return this.validateDocument((InputStream)null);
        }
        try {
            return this.validateDocument(validationPolicyURL.openStream());
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    @Override
    public Reports validateDocument(String policyResourcePath) {
        if (policyResourcePath == null) {
            return this.validateDocument((InputStream)null);
        }
        return this.validateDocument(this.getClass().getResourceAsStream(policyResourcePath));
    }

    @Override
    public Reports validateDocument(File policyFile) {
        if (policyFile == null || !policyFile.exists()) {
            return this.validateDocument((InputStream)null);
        }
        InputStream inputStream = DSSUtils.toByteArrayInputStream((File)policyFile);
        return this.validateDocument(inputStream);
    }

    @Override
    public Reports validateDocument(InputStream policyDataStream) {
        ConstraintsParameters validationPolicyJaxb = ValidationResourceManager.loadPolicyData(policyDataStream);
        return this.validateDocument(validationPolicyJaxb);
    }

    @Override
    public Reports validateDocument(ConstraintsParameters validationPolicyJaxb) {
        EtsiValidationPolicy validationPolicy = new EtsiValidationPolicy(validationPolicyJaxb);
        return this.validateDocument((ValidationPolicy)validationPolicy);
    }

    @Override
    public Reports validateDocument(ValidationPolicy validationPolicy) {
        LOG.info("Document validation...");
        if (this.certificateVerifier == null) {
            throw new NullPointerException("CertificateVerifier not defined");
        }
        this.ensureSignaturePolicyDetectorInitialized();
        boolean structuralValidation = this.isRequireStructuralValidation(validationPolicy);
        SignatureValidationContext validationContext = new SignatureValidationContext(this.validationCertPool);
        List<AdvancedSignature> allSignatureList = this.processSignaturesValidation(validationContext, structuralValidation);
        DiagnosticDataBuilder builder = new DiagnosticDataBuilder();
        builder.document(this.document).containerInfo(this.getContainerInfo()).foundSignatures(allSignatureList).usedCertificates(validationContext.getProcessedCertificates()).trustedListsCertificateSource(this.certificateVerifier.getTrustedCertSource()).validationDate(validationContext.getCurrentTime());
        return this.processValidationPolicy(builder.build(), validationPolicy);
    }

    @Override
    public List<AdvancedSignature> processSignaturesValidation(ValidationContext validationContext, boolean structuralValidation) {
        List<AdvancedSignature> allSignatureList = this.getAllSignatures();
        this.prepareCertificatesAndTimestamps(allSignatureList, validationContext);
        ListCRLSource signatureCRLSource = this.getSignatureCrlSource(allSignatureList);
        this.certificateVerifier.setSignatureCRLSource(signatureCRLSource);
        ListOCSPSource signatureOCSPSource = this.getSignatureOcspSource(allSignatureList);
        this.certificateVerifier.setSignatureOCSPSource(signatureOCSPSource);
        validationContext.setCurrentTime(this.provideProcessExecutorInstance().getCurrentTime());
        validationContext.initialize(this.certificateVerifier);
        validationContext.validate();
        for (AdvancedSignature signature : allSignatureList) {
            signature.checkSigningCertificate();
            signature.checkSignatureIntegrity();
            signature.validateTimestamps();
            if (structuralValidation) {
                signature.validateStructure();
            }
            signature.checkSignaturePolicy(this.signaturePolicyProvider);
            if (this.signatureScopeFinder == null) continue;
            signature.findSignatureScope(this.signatureScopeFinder);
        }
        return allSignatureList;
    }

    protected ContainerInfo getContainerInfo() {
        return null;
    }

    protected Reports processValidationPolicy(DiagnosticData diagnosticData, ValidationPolicy validationPolicy) {
        ProcessExecutor executor = this.provideProcessExecutorInstance();
        executor.setValidationPolicy(validationPolicy);
        executor.setValidationLevel(this.validationLevel);
        executor.setDiagnosticData(diagnosticData);
        Reports reports = executor.execute();
        return reports;
    }

    @Override
    public void setSignaturePolicyProvider(SignaturePolicyProvider signaturePolicyProvider) {
        this.signaturePolicyProvider = signaturePolicyProvider;
    }

    protected void ensureSignaturePolicyDetectorInitialized() {
        if (this.signaturePolicyProvider == null) {
            this.signaturePolicyProvider = new SignaturePolicyProvider();
            this.signaturePolicyProvider.setDataLoader(this.certificateVerifier.getDataLoader());
        }
    }

    @Override
    public void setProcessExecutor(ProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    public ProcessExecutor provideProcessExecutorInstance() {
        if (this.processExecutor == null) {
            this.processExecutor = new CustomProcessExecutor();
        }
        return this.processExecutor;
    }

    private List<AdvancedSignature> getAllSignatures() {
        ArrayList<AdvancedSignature> allSignatureList = new ArrayList<AdvancedSignature>();
        List<AdvancedSignature> signatureList = this.getSignatures();
        for (AdvancedSignature signature : signatureList) {
            allSignatureList.add(signature);
            allSignatureList.addAll(signature.getCounterSignatures());
        }
        return allSignatureList;
    }

    private ListCRLSource getSignatureCrlSource(List<AdvancedSignature> allSignatureList) {
        ListCRLSource signatureCrlSource = new ListCRLSource();
        for (AdvancedSignature signature : allSignatureList) {
            signatureCrlSource.addAll(signature.getCRLSource());
        }
        return signatureCrlSource;
    }

    private ListOCSPSource getSignatureOcspSource(List<AdvancedSignature> allSignatureList) {
        ListOCSPSource signatureOcspSource = new ListOCSPSource();
        for (AdvancedSignature signature : allSignatureList) {
            signatureOcspSource.addAll(signature.getOCSPSource());
        }
        return signatureOcspSource;
    }

    private void prepareCertificatesAndTimestamps(List<AdvancedSignature> allSignatureList, ValidationContext validationContext) {
        for (AdvancedSignature signature : allSignatureList) {
            List candidates = signature.getCertificateSource().getCertificates();
            for (CertificateToken certificateToken : candidates) {
                validationContext.addCertificateTokenForVerification(certificateToken);
            }
            signature.prepareTimestamps(validationContext);
        }
    }

    private boolean isRequireStructuralValidation(ValidationPolicy validationPolicy) {
        return validationPolicy != null && validationPolicy.getStructuralValidationConstraint(Context.SIGNATURE) != null;
    }

    static {
        Properties properties = new Properties();
        try {
            properties.load(SignedDocumentValidator.class.getResourceAsStream("/document-validators.properties"));
        }
        catch (IOException e) {
            LOG.error("Cannot load properties from document-validators.properties : " + e.getMessage(), (Throwable)e);
        }
        for (String propName : properties.stringPropertyNames()) {
            SignedDocumentValidator.registerDocumentValidator(propName, properties.getProperty(propName));
        }
    }
}

