/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.signature.DocumentSignatureService;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.tsp.TSPSource;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public abstract class AbstractSignatureService<SP extends AbstractSignatureParameters>
implements DocumentSignatureService<SP> {
    protected TSPSource tspSource;
    protected final CertificateVerifier certificateVerifier;

    protected AbstractSignatureService(CertificateVerifier certificateVerifier) {
        if (certificateVerifier == null) {
            throw new NullPointerException("CertificateVerifier cannot be null !");
        }
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    protected void assertSigningDateInCertificateValidityRange(SP parameters) {
        if (parameters.isSignWithExpiredCertificate() || ((AbstractSignatureParameters)((Object)parameters)).getSigningCertificate() == null && parameters.isGenerateTBSWithoutCertificate()) {
            return;
        }
        CertificateToken signingCertificate = ((AbstractSignatureParameters)((Object)parameters)).getSigningCertificate();
        Date notAfter = signingCertificate.getNotAfter();
        Date notBefore = signingCertificate.getNotBefore();
        Date signingDate = parameters.bLevel().getSigningDate();
        if (signingDate.after(notAfter) || signingDate.before(notBefore)) {
            throw new DSSException(String.format("Signing Date (%s) is not in certificate validity range (%s, %s).", signingDate.toString(), notBefore.toString(), notAfter.toString()));
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

