/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.MaskGenerationFunction;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.SignatureForm;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.validation.CRLRef;
import eu.europa.esig.dss.validation.CandidatesForSigningCertificate;
import eu.europa.esig.dss.validation.CertificateRef;
import eu.europa.esig.dss.validation.CertifiedRole;
import eu.europa.esig.dss.validation.CommitmentType;
import eu.europa.esig.dss.validation.OCSPRef;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignaturePolicyProvider;
import eu.europa.esig.dss.validation.SignatureProductionPlace;
import eu.europa.esig.dss.validation.SignatureScope;
import eu.europa.esig.dss.validation.SignatureScopeFinder;
import eu.europa.esig.dss.validation.TimestampReference;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.SignatureCertificateSource;
import eu.europa.esig.dss.x509.SignaturePolicy;
import eu.europa.esig.dss.x509.crl.OfflineCRLSource;
import eu.europa.esig.dss.x509.ocsp.OfflineOCSPSource;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

public interface AdvancedSignature
extends Serializable {
    public String getSignatureFilename();

    public void setSignatureFilename(String var1);

    public List<DSSDocument> getDetachedContents();

    public void setDetachedContents(List<DSSDocument> var1);

    public CertificateToken getProvidedSigningCertificateToken();

    public void setProvidedSigningCertificateToken(CertificateToken var1);

    public SignatureForm getSignatureForm();

    public SignatureAlgorithm getSignatureAlgorithm();

    public EncryptionAlgorithm getEncryptionAlgorithm();

    public DigestAlgorithm getDigestAlgorithm();

    public MaskGenerationFunction getMaskGenerationFunction();

    public Date getSigningTime();

    public SignatureCertificateSource getCertificateSource();

    public OfflineCRLSource getCRLSource();

    public OfflineOCSPSource getOCSPSource();

    public CandidatesForSigningCertificate getCandidatesForSigningCertificate();

    public void setMasterSignature(AdvancedSignature var1);

    public AdvancedSignature getMasterSignature();

    public CertificateToken getSigningCertificateToken();

    public void checkSignatureIntegrity();

    public SignatureCryptographicVerification getSignatureCryptographicVerification();

    public void checkSigningCertificate();

    public SignaturePolicy getPolicyId();

    public SignatureProductionPlace getSignatureProductionPlace();

    public CommitmentType getCommitmentTypeIndication();

    public String getContentType();

    public String getContentIdentifier();

    public String getContentHints();

    public String[] getClaimedSignerRoles();

    public List<CertifiedRole> getCertifiedSignerRoles();

    public List<CertificateToken> getCertificates();

    public List<TimestampToken> getContentTimestamps();

    public byte[] getContentTimestampData(TimestampToken var1);

    public List<TimestampToken> getSignatureTimestamps();

    public byte[] getSignatureTimestampData(TimestampToken var1, String var2);

    public List<TimestampToken> getTimestampsX1();

    public byte[] getTimestampX1Data(TimestampToken var1, String var2);

    public List<TimestampToken> getTimestampsX2();

    public byte[] getTimestampX2Data(TimestampToken var1, String var2);

    public List<TimestampToken> getArchiveTimestamps();

    public byte[] getArchiveTimestampData(TimestampToken var1, String var2);

    public void addExternalTimestamp(TimestampToken var1);

    public List<AdvancedSignature> getCounterSignatures();

    public List<TimestampReference> getTimestampedReferences();

    public List<CertificateRef> getCertificateRefs();

    public List<CRLRef> getCRLRefs();

    public List<OCSPRef> getOCSPRefs();

    public String getId();

    public Set<DigestAlgorithm> getUsedCertificatesDigestAlgorithms();

    public boolean isDataForSignatureLevelPresent(SignatureLevel var1);

    public SignatureLevel getDataFoundUpToLevel();

    public SignatureLevel[] getSignatureLevels();

    public void prepareTimestamps(ValidationContext var1);

    public void validateTimestamps();

    public void validateStructure();

    public String getStructureValidationResult();

    public void checkSignaturePolicy(SignaturePolicyProvider var1);

    public void findSignatureScope(SignatureScopeFinder var1);

    public List<SignatureScope> getSignatureScopes();

    public List<ReferenceValidation> getReferenceValidations();
}

