/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.validation.CertificateValidity;
import eu.europa.esig.dss.x509.CertificateToken;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CandidatesForSigningCertificate
implements Serializable {
    private CertificateValidity theCertificateValidity = null;
    private List<CertificateValidity> certificateValidityList = new ArrayList<CertificateValidity>();

    public List<CertificateValidity> getCertificateValidityList() {
        return this.certificateValidityList;
    }

    public List<CertificateToken> getSigningCertificateTokenList() {
        ArrayList<CertificateToken> signCertificateTokenList = new ArrayList<CertificateToken>();
        for (CertificateValidity certificateValidity : this.certificateValidityList) {
            CertificateToken certificateToken = certificateValidity.getCertificateToken();
            if (certificateToken == null) continue;
            signCertificateTokenList.add(certificateToken);
        }
        return signCertificateTokenList;
    }

    public void add(CertificateValidity certificateValidity) {
        this.certificateValidityList.add(certificateValidity);
    }

    public void setTheCertificateValidity(CertificateValidity theCertificateValidity) throws DSSException {
        if (theCertificateValidity == null) {
            throw new NullPointerException();
        }
        if (!this.certificateValidityList.contains(theCertificateValidity)) {
            throw new DSSException("theSigningCertificateValidity must be the part of the candidates!");
        }
        this.theCertificateValidity = theCertificateValidity;
    }

    public CertificateValidity getTheCertificateValidity() {
        return this.theCertificateValidity;
    }

    public CertificateValidity getTheBestCandidate() {
        CertificateValidity firstCandidate = null;
        for (CertificateValidity certificateValidity : this.certificateValidityList) {
            if (firstCandidate == null) {
                firstCandidate = certificateValidity;
            }
            if (!certificateValidity.isValid()) continue;
            return certificateValidity;
        }
        CertificateValidity signerIdMatchCandidate = this.getBySignerIdMatch();
        if (signerIdMatchCandidate != null) {
            return signerIdMatchCandidate;
        }
        return firstCandidate;
    }

    private CertificateValidity getBySignerIdMatch() {
        for (CertificateValidity certificateValidity : this.certificateValidityList) {
            if (!certificateValidity.isSignerIdMatch()) continue;
            return certificateValidity;
        }
        return null;
    }
}

