/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.validation.CertificateStatusVerifier;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateSourceType;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.RevocationSource;
import eu.europa.esig.dss.x509.RevocationToken;
import eu.europa.esig.dss.x509.Token;
import eu.europa.esig.dss.x509.ocsp.OCSPToken;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.RespID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPCertificateVerifier
implements CertificateStatusVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(OCSPCertificateVerifier.class);
    private final RevocationSource<OCSPToken> ocspSource;
    private final CertificatePool validationCertPool;

    public OCSPCertificateVerifier(RevocationSource<OCSPToken> ocspSource, CertificatePool validationCertPool) {
        this.ocspSource = ocspSource;
        this.validationCertPool = validationCertPool;
    }

    @Override
    public RevocationToken check(CertificateToken toCheckToken) {
        if (this.ocspSource == null) {
            LOG.debug("OCSPSource null");
            return null;
        }
        CertificateToken issuerToken = this.validationCertPool.getIssuer((Token)toCheckToken);
        if (issuerToken == null) {
            LOG.debug("Issuer is null");
            return null;
        }
        try {
            OCSPToken ocspToken = (OCSPToken)this.ocspSource.getRevocationToken(toCheckToken, issuerToken);
            if (ocspToken == null) {
                LOG.debug("{} : No matching OCSP response found for {}", (Object)this.ocspSource.getClass().getSimpleName(), (Object)toCheckToken.getDSSIdAsString());
            } else {
                ocspToken.setRelatedCertificateID(toCheckToken.getDSSIdAsString());
                ocspToken.extractInfo();
                boolean found = this.extractSigningCertificateFromResponse(ocspToken);
                if (!found) {
                    this.extractSigningCertificateFormResponderId(ocspToken);
                }
            }
            return ocspToken;
        }
        catch (DSSException e) {
            LOG.error("OCSP DSS Exception: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private boolean extractSigningCertificateFromResponse(OCSPToken ocspToken) {
        BasicOCSPResp basicOCSPResp = ocspToken.getBasicOCSPResp();
        if (basicOCSPResp != null) {
            for (X509CertificateHolder x509CertificateHolder : basicOCSPResp.getCerts()) {
                CertificateToken certificateToken = DSSASN1Utils.getCertificate((X509CertificateHolder)x509CertificateHolder);
                CertificateToken certToken = this.validationCertPool.getInstance(certificateToken, CertificateSourceType.OCSP_RESPONSE);
                if (!ocspToken.isSignedBy(certToken)) continue;
                ocspToken.setIssuerX500Principal(certToken.getSubjectX500Principal());
                return true;
            }
        }
        return false;
    }

    private void extractSigningCertificateFormResponderId(OCSPToken ocspToken) {
        BasicOCSPResp basicOCSPResp = ocspToken.getBasicOCSPResp();
        if (basicOCSPResp != null) {
            RespID responderId = basicOCSPResp.getResponderId();
            ResponderID responderIdAsASN1Object = responderId.toASN1Primitive();
            DERTaggedObject derTaggedObject = (DERTaggedObject)responderIdAsASN1Object.toASN1Primitive();
            if (1 == derTaggedObject.getTagNo()) {
                ASN1Primitive derObject = derTaggedObject.getObject();
                byte[] derEncoded = DSSASN1Utils.getDEREncoded((ASN1Encodable)derObject);
                X500Principal x500Principal_ = new X500Principal(derEncoded);
                X500Principal x500Principal = DSSUtils.getNormalizedX500Principal((X500Principal)x500Principal_);
                List certificateTokens = this.validationCertPool.get(x500Principal);
                for (CertificateToken issuerCertificateToken : certificateTokens) {
                    if (!ocspToken.isSignedBy(issuerCertificateToken)) continue;
                    ocspToken.setIssuerX500Principal(issuerCertificateToken.getSubjectX500Principal());
                    break;
                }
            } else if (2 == derTaggedObject.getTagNo()) {
                ASN1OctetString hashOctetString = (ASN1OctetString)derTaggedObject.getObject();
                byte[] expectedHash = hashOctetString.getOctets();
                List certificateTokens = this.validationCertPool.getBySki(expectedHash);
                for (CertificateToken issuerCertificateToken : certificateTokens) {
                    if (!ocspToken.isSignedBy(issuerCertificateToken)) continue;
                    ocspToken.setIssuerX500Principal(issuerCertificateToken.getSubjectX500Principal());
                    break;
                }
            } else {
                throw new DSSException("Unsupported tag No " + derTaggedObject.getTagNo());
            }
        }
    }
}

