/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.enumerations.TokenExtractionStategy;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicyFacade;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.DiagnosticDataBuilder;
import eu.europa.esig.dss.validation.ProcessExecutorProvider;
import eu.europa.esig.dss.validation.SignatureValidationContext;
import eu.europa.esig.dss.validation.executor.certificate.CertificateProcessExecutor;
import eu.europa.esig.dss.validation.executor.certificate.DefaultCertificateProcessExecutor;
import eu.europa.esig.dss.validation.reports.CertificateReports;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;

public class CertificateValidator
implements ProcessExecutorProvider<CertificateProcessExecutor> {
    private Date validationTime;
    private final CertificateToken token;
    private CertificateVerifier certificateVerifier;
    private TokenExtractionStategy tokenExtractionStategy = TokenExtractionStategy.NONE;
    private Locale locale = Locale.getDefault();
    private CertificateProcessExecutor processExecutor;

    private CertificateValidator(CertificateToken token) {
        Objects.requireNonNull(token, "The certificate is missing");
        this.token = token;
    }

    public static CertificateValidator fromCertificate(CertificateToken token) {
        return new CertificateValidator(token);
    }

    public void setCertificateVerifier(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public void setTokenExtractionStategy(TokenExtractionStategy tokenExtractionStategy) {
        Objects.requireNonNull(tokenExtractionStategy);
        this.tokenExtractionStategy = tokenExtractionStategy;
    }

    public void setValidationTime(Date validationTime) {
        this.validationTime = validationTime;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private Date getValidationTime() {
        if (this.validationTime == null) {
            this.validationTime = new Date();
        }
        return this.validationTime;
    }

    public CertificateReports validate() {
        ValidationPolicy defaultPolicy = null;
        try {
            defaultPolicy = ValidationPolicyFacade.newFacade().getDefaultValidationPolicy();
        }
        catch (Exception e) {
            throw new DSSException("Unable to load the default policy", (Throwable)e);
        }
        return this.validate(defaultPolicy);
    }

    public CertificateReports validate(ValidationPolicy validationPolicy) {
        SignatureValidationContext svc = new SignatureValidationContext();
        svc.initialize(this.certificateVerifier);
        svc.addCertificateTokenForVerification(this.token);
        svc.setCurrentTime(this.getValidationTime());
        svc.validate();
        XmlDiagnosticData diagnosticData = new DiagnosticDataBuilder().usedCertificates(svc.getProcessedCertificates()).usedRevocations(svc.getProcessedRevocations()).tokenExtractionStategy(this.tokenExtractionStategy).certificateSourceTypes(svc.getCertificateSourceTypes()).trustedCertificateSources(this.certificateVerifier.getTrustedCertSources()).validationDate(this.getValidationTime()).build();
        CertificateProcessExecutor executor = this.provideProcessExecutorInstance();
        executor.setValidationPolicy(validationPolicy);
        executor.setDiagnosticData(diagnosticData);
        executor.setCertificateId(this.token.getDSSIdAsString());
        executor.setLocale(this.locale);
        executor.setCurrentTime(this.getValidationTime());
        return (CertificateReports)executor.execute();
    }

    @Override
    public void setProcessExecutor(CertificateProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    public CertificateProcessExecutor provideProcessExecutorInstance() {
        if (this.processExecutor == null) {
            this.processExecutor = this.getDefaultProcessExecutor();
        }
        return this.processExecutor;
    }

    @Override
    public CertificateProcessExecutor getDefaultProcessExecutor() {
        return new DefaultCertificateProcessExecutor();
    }
}

