/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.CommitmentTypeIndication;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignatureDigestReference;
import eu.europa.esig.dss.validation.SignatureIdentifier;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.SignatureProductionPlace;
import eu.europa.esig.dss.validation.SignerRole;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import eu.europa.esig.dss.validation.timestamp.TimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public interface AdvancedSignature
extends Serializable {
    public String getSignatureFilename();

    public void setSignatureFilename(String var1);

    public List<DSSDocument> getDetachedContents();

    public void setDetachedContents(List<DSSDocument> var1);

    public List<DSSDocument> getContainerContents();

    public void setContainerContents(List<DSSDocument> var1);

    public ManifestFile getManifestFile();

    public void setManifestFile(ManifestFile var1);

    public void setSigningCertificateSource(CertificateSource var1);

    public SignatureForm getSignatureForm();

    public SignatureAlgorithm getSignatureAlgorithm();

    public EncryptionAlgorithm getEncryptionAlgorithm();

    public DigestAlgorithm getDigestAlgorithm();

    public MaskGenerationFunction getMaskGenerationFunction();

    public Date getSigningTime();

    public SignatureCertificateSource getCertificateSource();

    public ListCertificateSource getCompleteCertificateSource();

    public OfflineRevocationSource<CRL> getCRLSource();

    public OfflineRevocationSource<OCSP> getOCSPSource();

    public ListRevocationSource<CRL> getCompleteCRLSource();

    public ListRevocationSource<OCSP> getCompleteOCSPSource();

    public TimestampSource getTimestampSource();

    public CandidatesForSigningCertificate getCandidatesForSigningCertificate();

    public void prepareOfflineCertificateVerifier(CertificateVerifier var1);

    public void setMasterSignature(AdvancedSignature var1);

    public AdvancedSignature getMasterSignature();

    public boolean isCounterSignature();

    public CertificateToken getSigningCertificateToken();

    public void checkSignatureIntegrity();

    public SignatureCryptographicVerification getSignatureCryptographicVerification();

    public SignaturePolicy getSignaturePolicy();

    public SignaturePolicyStore getSignaturePolicyStore();

    public SignatureProductionPlace getSignatureProductionPlace();

    public List<CommitmentTypeIndication> getCommitmentTypeIndications();

    public String getContentType();

    public String getMimeType();

    public List<SignerRole> getSignerRoles();

    public List<SignerRole> getSignedAssertions();

    public List<SignerRole> getClaimedSignerRoles();

    public List<SignerRole> getCertifiedSignerRoles();

    public List<CertificateToken> getCertificates();

    public List<TimestampToken> getContentTimestamps();

    public List<TimestampToken> getSignatureTimestamps();

    public List<TimestampToken> getTimestampsX1();

    public List<TimestampToken> getTimestampsX2();

    public List<TimestampToken> getArchiveTimestamps();

    public List<TimestampToken> getDocumentTimestamps();

    public List<TimestampToken> getAllTimestamps();

    public void addExternalTimestamp(TimestampToken var1);

    public List<AdvancedSignature> getCounterSignatures();

    public SignatureIdentifier getDSSId();

    public String getId();

    public String getDAIdentifier();

    public SignatureLevel getDataFoundUpToLevel();

    public boolean areAllSelfSignedCertificates();

    public void prepareTimestamps(ValidationContext var1);

    public void prepareCounterSignatures(ValidationContext var1);

    public List<String> getStructureValidationResult();

    public void findSignatureScope(SignatureScopeFinder var1);

    public List<SignatureScope> getSignatureScopes();

    public boolean isDocHashOnlyValidation();

    public boolean isHashOnlyValidation();

    public byte[] getSignatureValue();

    public List<ReferenceValidation> getReferenceValidations();

    public SignatureDigestReference getSignatureDigestReference(DigestAlgorithm var1);

    public Digest getDataToBeSignedRepresentation();
}

