/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.CertificateVerifierBuilder;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignatureIdentifier;
import eu.europa.esig.dss.validation.SignatureIdentifierBuilder;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.SignatureValidationContext;
import eu.europa.esig.dss.validation.SignerRole;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import eu.europa.esig.dss.validation.timestamp.TimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class DefaultAdvancedSignature
implements AdvancedSignature {
    private static final long serialVersionUID = 6452189007886779360L;
    protected List<DSSDocument> detachedContents;
    private List<DSSDocument> containerContents;
    protected ManifestFile manifestFile;
    protected List<ReferenceValidation> referenceValidations;
    protected SignatureCryptographicVerification signatureCryptographicVerification;
    protected List<String> structureValidationMessages;
    private CertificateVerifier offlineCertificateVerifier;
    protected CertificateSource signingCertificateSource;
    protected SignatureCertificateSource offlineCertificateSource;
    protected OfflineCRLSource signatureCRLSource;
    protected OfflineOCSPSource signatureOCSPSource;
    protected TimestampSource signatureTimestampSource;
    protected List<AdvancedSignature> counterSignatures;
    private AdvancedSignature masterSignature;
    protected SignaturePolicy signaturePolicy;
    private List<SignatureScope> signatureScopes;
    private String signatureFilename;
    protected SignatureIdentifier signatureIdentifier;

    protected abstract SignatureIdentifierBuilder getSignatureIdentifierBuilder();

    @Override
    public void setSigningCertificateSource(CertificateSource signingCertificateSource) {
        this.signingCertificateSource = signingCertificateSource;
    }

    @Override
    public String getSignatureFilename() {
        return this.signatureFilename;
    }

    @Override
    public void setSignatureFilename(String signatureFilename) {
        this.signatureFilename = signatureFilename;
    }

    @Override
    public List<DSSDocument> getDetachedContents() {
        return this.detachedContents;
    }

    @Override
    public void setDetachedContents(List<DSSDocument> detachedContents) {
        this.detachedContents = detachedContents;
    }

    @Override
    public List<DSSDocument> getContainerContents() {
        return this.containerContents;
    }

    @Override
    public void setContainerContents(List<DSSDocument> containerContents) {
        this.containerContents = containerContents;
    }

    @Override
    public ManifestFile getManifestFile() {
        return this.manifestFile;
    }

    @Override
    public void setManifestFile(ManifestFile manifestFile) {
        this.manifestFile = manifestFile;
    }

    @Override
    public SignatureIdentifier getDSSId() {
        if (this.signatureIdentifier == null) {
            this.signatureIdentifier = this.getSignatureIdentifierBuilder().build();
        }
        return this.signatureIdentifier;
    }

    @Override
    public String getId() {
        return this.getDSSId().asXmlId();
    }

    @Override
    public ListCertificateSource getCompleteCertificateSource() {
        ListCertificateSource certificateSource = new ListCertificateSource((CertificateSource)this.getCertificateSource());
        certificateSource.addAll(this.getTimestampSource().getTimestampCertificateSources());
        certificateSource.addAll(this.getCounterSignaturesCertificateSource());
        return certificateSource;
    }

    public ListCertificateSource getCertificateSourcesExceptLastArchiveTimestamp() {
        ListCertificateSource certificateSource = new ListCertificateSource((CertificateSource)this.getCertificateSource());
        certificateSource.addAll(this.getTimestampSource().getTimestampCertificateSourcesExceptLastArchiveTimestamp());
        certificateSource.addAll(this.getCounterSignaturesCertificateSource());
        return certificateSource;
    }

    @Override
    public ListRevocationSource<CRL> getCompleteCRLSource() {
        ListRevocationSource<CRL> crlSource = new ListRevocationSource<CRL>(this.getCRLSource());
        crlSource.addAll(this.getTimestampSource().getTimestampCRLSources());
        crlSource.addAll(this.getCounterSignaturesCRLSource());
        return crlSource;
    }

    @Override
    public ListRevocationSource<OCSP> getCompleteOCSPSource() {
        ListRevocationSource<OCSP> ocspSource = new ListRevocationSource<OCSP>(this.getOCSPSource());
        ocspSource.addAll(this.getTimestampSource().getTimestampOCSPSources());
        ocspSource.addAll(this.getCounterSignaturesOCSPSource());
        return ocspSource;
    }

    protected ListCertificateSource getCounterSignaturesCertificateSource() {
        ListCertificateSource certificateSource = new ListCertificateSource();
        for (AdvancedSignature counterSignature : this.getCounterSignatures()) {
            certificateSource.addAll(counterSignature.getCompleteCertificateSource());
        }
        return certificateSource;
    }

    protected ListRevocationSource<CRL> getCounterSignaturesCRLSource() {
        ListRevocationSource<CRL> crlSource = new ListRevocationSource<CRL>();
        for (AdvancedSignature counterSignature : this.getCounterSignatures()) {
            crlSource.addAll(counterSignature.getCompleteCRLSource());
        }
        return crlSource;
    }

    protected ListRevocationSource<OCSP> getCounterSignaturesOCSPSource() {
        ListRevocationSource<OCSP> crlSource = new ListRevocationSource<OCSP>();
        for (AdvancedSignature counterSignature : this.getCounterSignatures()) {
            crlSource.addAll(counterSignature.getCompleteOCSPSource());
        }
        return crlSource;
    }

    public void resetCertificateSource() {
        this.offlineCertificateSource = null;
    }

    public void resetRevocationSources() {
        this.signatureCRLSource = null;
        this.signatureOCSPSource = null;
    }

    public void resetTimestampSource() {
        this.signatureTimestampSource = null;
    }

    @Override
    public CandidatesForSigningCertificate getCandidatesForSigningCertificate() {
        return this.getCertificateSource().getCandidatesForSigningCertificate(this.signingCertificateSource);
    }

    @Override
    public void prepareOfflineCertificateVerifier(CertificateVerifier certificateVerifier) {
        this.offlineCertificateVerifier = new CertificateVerifierBuilder(certificateVerifier).buildOfflineAndSilentCopy();
    }

    public ValidationContext getSignatureValidationContext(CertificateVerifier certificateVerifier) {
        SignatureValidationContext validationContext = new SignatureValidationContext();
        certificateVerifier.setSignatureCRLSource(this.getCompleteCRLSource());
        certificateVerifier.setSignatureOCSPSource(this.getCompleteOCSPSource());
        certificateVerifier.setSignatureCertificateSource(this.getCompleteCertificateSource());
        validationContext.initialize(certificateVerifier);
        List certificateValidities = this.getCandidatesForSigningCertificate().getCertificateValidityList();
        if (Utils.isCollectionNotEmpty((Collection)certificateValidities)) {
            for (CertificateValidity certificateValidity : certificateValidities) {
                if (!certificateValidity.isValid() || certificateValidity.getCertificateToken() == null) continue;
                validationContext.addCertificateTokenForVerification(certificateValidity.getCertificateToken());
            }
        }
        List<CertificateToken> certificates = this.getCertificates();
        for (CertificateToken certificate : certificates) {
            validationContext.addCertificateTokenForVerification(certificate);
        }
        this.prepareTimestamps(validationContext);
        this.prepareCounterSignatures(validationContext);
        validationContext.validate();
        validationContext.checkAllTimestampsValid();
        validationContext.checkAllRequiredRevocationDataPresent();
        validationContext.checkAllPOECoveredByRevocationData();
        validationContext.checkAllCertificatesValid();
        CertificateToken signingCertificateToken = this.getSigningCertificateToken();
        validationContext.checkAtLeastOneRevocationDataPresentAfterBestSignatureTime(signingCertificateToken);
        return validationContext;
    }

    @Override
    public List<CertificateToken> getCertificates() {
        return this.getCertificateSource().getCertificates();
    }

    @Override
    public void setMasterSignature(AdvancedSignature masterSignature) {
        this.masterSignature = masterSignature;
    }

    @Override
    public AdvancedSignature getMasterSignature() {
        return this.masterSignature;
    }

    @Override
    public boolean isCounterSignature() {
        return this.masterSignature != null;
    }

    @Override
    public SignatureCryptographicVerification getSignatureCryptographicVerification() {
        if (this.signatureCryptographicVerification == null) {
            this.checkSignatureIntegrity();
        }
        return this.signatureCryptographicVerification;
    }

    @Override
    public List<SignerRole> getSignerRoles() {
        List<SignerRole> signedAssertionSignerRoles;
        List<SignerRole> certifiedSignerRoles;
        ArrayList<SignerRole> signerRoles = new ArrayList<SignerRole>();
        List<SignerRole> claimedSignerRoles = this.getClaimedSignerRoles();
        if (Utils.isCollectionNotEmpty(claimedSignerRoles)) {
            signerRoles.addAll(claimedSignerRoles);
        }
        if (Utils.isCollectionNotEmpty(certifiedSignerRoles = this.getCertifiedSignerRoles())) {
            signerRoles.addAll(certifiedSignerRoles);
        }
        if (Utils.isCollectionNotEmpty(signedAssertionSignerRoles = this.getSignedAssertions())) {
            signerRoles.addAll(signedAssertionSignerRoles);
        }
        return signerRoles;
    }

    @Override
    public CertificateToken getSigningCertificateToken() {
        CandidatesForSigningCertificate candidatesForSigningCertificate = this.getCertificateSource().getCandidatesForSigningCertificate(this.signingCertificateSource);
        this.signatureCryptographicVerification = this.getSignatureCryptographicVerification();
        CertificateValidity theCertificateValidity = candidatesForSigningCertificate.getTheCertificateValidity();
        if (theCertificateValidity != null && theCertificateValidity.isValid()) {
            CertificateToken signingCertificateToken = theCertificateValidity.getCertificateToken();
            return signingCertificateToken;
        }
        CertificateValidity theBestCandidate = candidatesForSigningCertificate.getTheBestCandidate();
        return theBestCandidate == null ? null : theBestCandidate.getCertificateToken();
    }

    @Override
    public void prepareTimestamps(ValidationContext validationContext) {
        for (TimestampToken timestampToken : this.getContentTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getSignatureTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getTimestampsX1()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getTimestampsX2()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getArchiveTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getDocumentTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
    }

    @Override
    public void prepareCounterSignatures(ValidationContext validationContext) {
        for (AdvancedSignature counterSignature : this.getCounterSignatures()) {
            for (CertificateToken certificateToken : counterSignature.getCertificates()) {
                validationContext.addCertificateTokenForVerification(certificateToken);
            }
            counterSignature.prepareTimestamps(validationContext);
            counterSignature.prepareCounterSignatures(validationContext);
        }
    }

    @Override
    public List<String> getStructureValidationResult() {
        if (Utils.isCollectionEmpty(this.structureValidationMessages)) {
            this.structureValidationMessages = this.validateStructure();
        }
        return this.structureValidationMessages;
    }

    protected List<String> validateStructure() {
        return Collections.emptyList();
    }

    @Override
    public void findSignatureScope(SignatureScopeFinder signatureScopeFinder) {
        this.signatureScopes = signatureScopeFinder.findSignatureScope(this);
    }

    @Override
    public List<SignatureScope> getSignatureScopes() {
        return this.signatureScopes;
    }

    @Override
    public List<TimestampToken> getContentTimestamps() {
        return this.getTimestampSource().getContentTimestamps();
    }

    @Override
    public List<TimestampToken> getSignatureTimestamps() {
        return this.getTimestampSource().getSignatureTimestamps();
    }

    @Override
    public List<TimestampToken> getTimestampsX1() {
        return this.getTimestampSource().getTimestampsX1();
    }

    @Override
    public List<TimestampToken> getTimestampsX2() {
        return this.getTimestampSource().getTimestampsX2();
    }

    @Override
    public List<TimestampToken> getArchiveTimestamps() {
        return this.getTimestampSource().getArchiveTimestamps();
    }

    @Override
    public List<TimestampToken> getDocumentTimestamps() {
        return this.getTimestampSource().getDocumentTimestamps();
    }

    @Override
    public List<TimestampToken> getAllTimestamps() {
        return this.getTimestampSource().getAllTimestamps();
    }

    @Override
    public void addExternalTimestamp(TimestampToken timestamp) {
        if (!timestamp.isProcessed()) {
            throw new DSSException("Timestamp token must be validated first !");
        }
        if (!timestamp.getTimeStampType().isArchivalTimestamp()) {
            throw new DSSException("Only archival timestamp is allowed !");
        }
        this.getTimestampSource().addExternalTimestamp(timestamp);
    }

    public boolean hasTProfile() {
        return Utils.isCollectionNotEmpty(this.getSignatureTimestamps());
    }

    public boolean hasLTProfile() {
        boolean minimalLTRequirement;
        ListCertificateSource certificateSources = this.getCertificateSourcesExceptLastArchiveTimestamp();
        boolean certificateFound = certificateSources.getNumberOfCertificates() > 0;
        boolean allSelfSigned = certificateFound && certificateSources.isAllSelfSigned();
        boolean emptyCRLs = this.getCompleteCRLSource().getAllRevocationBinaries().isEmpty();
        boolean emptyOCSPs = this.getCompleteOCSPSource().getAllRevocationBinaries().isEmpty();
        boolean emptyRevocation = emptyCRLs && emptyOCSPs;
        boolean bl = minimalLTRequirement = !allSelfSigned && !emptyRevocation;
        if (minimalLTRequirement) {
            return this.isAllRevocationDataPresent(certificateSources);
        }
        return minimalLTRequirement;
    }

    private boolean isAllRevocationDataPresent(ListCertificateSource certificateSources) {
        SignatureValidationContext validationContext = new SignatureValidationContext();
        this.offlineCertificateVerifier.setSignatureCRLSource(this.getCompleteCRLSource());
        this.offlineCertificateVerifier.setSignatureOCSPSource(this.getCompleteOCSPSource());
        this.offlineCertificateVerifier.setSignatureCertificateSource(this.getCompleteCertificateSource());
        validationContext.initialize(this.offlineCertificateVerifier);
        List certificateValidityList = this.getCandidatesForSigningCertificate().getCertificateValidityList();
        for (CertificateValidity certificateValidity : certificateValidityList) {
            if (!certificateValidity.isValid() || certificateValidity.getCertificateToken() == null) continue;
            validationContext.addCertificateTokenForVerification(certificateValidity.getCertificateToken());
        }
        for (CertificateToken certificate : certificateSources.getAllCertificateTokens()) {
            validationContext.addCertificateTokenForVerification(certificate);
        }
        validationContext.validate();
        return validationContext.checkAllRequiredRevocationDataPresent();
    }

    @Override
    public boolean areAllSelfSignedCertificates() {
        ListCertificateSource certificateSources = this.getCompleteCertificateSource();
        boolean certificateFound = certificateSources.getNumberOfCertificates() > 0;
        return certificateFound && certificateSources.isAllSelfSigned();
    }

    public boolean hasLTAProfile() {
        return Utils.isCollectionNotEmpty(this.getArchiveTimestamps());
    }

    @Override
    public boolean isDocHashOnlyValidation() {
        if (Utils.isCollectionNotEmpty(this.detachedContents)) {
            for (DSSDocument dssDocument : this.detachedContents) {
                if (dssDocument instanceof DigestDocument) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isHashOnlyValidation() {
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DefaultAdvancedSignature)) {
            return false;
        }
        DefaultAdvancedSignature das = (DefaultAdvancedSignature)obj;
        return this.getDSSId().equals((Object)das.getDSSId());
    }

    public int hashCode() {
        return this.getDSSId().hashCode();
    }

    public String toString() {
        return String.format("%s Signature with Id : %s", this.getSignatureForm(), this.getId());
    }
}

