/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPAndCRLRevocationSource
implements RevocationSource<Revocation> {
    private static final long serialVersionUID = 3205352844337899410L;
    private static final Logger LOG = LoggerFactory.getLogger(OCSPAndCRLRevocationSource.class);
    private final RevocationSource<OCSP> ocspSource;
    private final RevocationSource<CRL> crlSource;
    private ListCertificateSource trustedListCertificateSource;

    public OCSPAndCRLRevocationSource(RevocationSource<CRL> crlSource, RevocationSource<OCSP> ocspSource) {
        this.crlSource = crlSource;
        this.ocspSource = ocspSource;
    }

    public void setTrustedCertificateSource(ListCertificateSource trustedListCertificateSource) {
        this.trustedListCertificateSource = trustedListCertificateSource;
    }

    public RevocationToken<Revocation> getRevocationToken(CertificateToken certificateToken, CertificateToken issuerToken) {
        RevocationToken<OCSP> result;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Check revocation for certificate : {}", (Object)certificateToken.getDSSIdAsString());
        }
        if ((result = this.checkOCSP(certificateToken, issuerToken)) != null) {
            return result;
        }
        result = this.checkCRL(certificateToken, issuerToken);
        if (result != null) {
            return result;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("There is no response for {} neither from OCSP nor from CRL!", (Object)certificateToken.getDSSIdAsString());
        }
        return null;
    }

    public RevocationToken<OCSP> checkOCSP(CertificateToken certificateToken, CertificateToken issuerToken) {
        if (this.ocspSource == null) {
            LOG.debug("OCSPSource null");
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("OCSP request for: {} using: {}", (Object)certificateToken.getDSSIdAsString(), (Object)this.ocspSource.getClass().getSimpleName());
        }
        try {
            RevocationToken revocationToken = this.ocspSource.getRevocationToken(certificateToken, issuerToken);
            if (revocationToken != null && this.containsCertificateStatus(revocationToken) && this.isAcceptable((RevocationToken<OCSP>)revocationToken) && this.isIssuerValidAtRevocationProductionTime(revocationToken)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("OCSP response for {} retrieved: {}", (Object)certificateToken.getDSSIdAsString(), (Object)revocationToken.getAbbreviation());
                    LOG.debug("OCSP Response {} status is : {}", (Object)revocationToken.getDSSIdAsString(), (Object)revocationToken.getStatus());
                }
                return revocationToken;
            }
        }
        catch (DSSException e) {
            LOG.error("OCSP DSS Exception: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("An OCSP response for token {} is not obtained! Return null value.", (Object)certificateToken.getDSSIdAsString());
        }
        return null;
    }

    public RevocationToken<CRL> checkCRL(CertificateToken certificateToken, CertificateToken issuerToken) {
        if (this.crlSource == null) {
            LOG.debug("CRLSource is null");
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CRL request for: {} using: {}", (Object)certificateToken.getDSSIdAsString(), (Object)this.crlSource.getClass().getSimpleName());
        }
        try {
            RevocationToken revocationToken = this.crlSource.getRevocationToken(certificateToken, issuerToken);
            if (revocationToken != null && this.containsCertificateStatus(revocationToken)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CRL for {} retrieved: {}", (Object)certificateToken.getDSSIdAsString(), (Object)revocationToken.getAbbreviation());
                }
                return revocationToken;
            }
        }
        catch (DSSException e) {
            LOG.error("CRL DSS Exception: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("A CRL for token {} is not obtained! Return null value.", (Object)certificateToken.getDSSIdAsString());
        }
        return null;
    }

    private boolean containsCertificateStatus(RevocationToken<?> revocationToken) {
        if (revocationToken.getStatus() == null) {
            LOG.warn("The obtained revocation token does not contain the certificate status. The token is skipped.");
            return false;
        }
        return true;
    }

    private boolean isAcceptable(RevocationToken<OCSP> ocspToken) {
        CertificateToken issuerCertificateToken = ocspToken.getIssuerCertificateToken();
        if (issuerCertificateToken == null) {
            LOG.warn("The issuer certificate is not found for the obtained OCSPToken. The token is skipped.");
            return false;
        }
        if (this.doesRequireRevocation(issuerCertificateToken) && !this.hasRevocationAccessPoints(issuerCertificateToken)) {
            LOG.warn("The issuer certificate of the obtained OCSPToken requires a revocation data, which is not acceptable due its configuration (no revocation access location points). The token is skipped.");
            return false;
        }
        return true;
    }

    private boolean doesRequireRevocation(CertificateToken certificateToken) {
        if (certificateToken.isSelfSigned()) {
            return false;
        }
        if (this.isTrusted(certificateToken)) {
            return false;
        }
        return !DSSASN1Utils.hasIdPkixOcspNoCheckExtension((CertificateToken)certificateToken);
    }

    private boolean isTrusted(CertificateToken certificateToken) {
        return this.trustedListCertificateSource != null && this.trustedListCertificateSource.isTrusted(certificateToken);
    }

    private boolean hasRevocationAccessPoints(CertificateToken certificateToken) {
        if (Utils.isCollectionNotEmpty((Collection)DSSASN1Utils.getOCSPAccessLocations((CertificateToken)certificateToken))) {
            return true;
        }
        return Utils.isCollectionNotEmpty((Collection)DSSASN1Utils.getCrlUrls((CertificateToken)certificateToken));
    }

    private boolean isIssuerValidAtRevocationProductionTime(RevocationToken<?> revocationToken) {
        if (!DSSRevocationUtils.checkIssuerValidAtRevocationProductionTime(revocationToken)) {
            LOG.warn("The revocation token has been produced outside the issuer certificate's validity range. The token is skipped.");
            return false;
        }
        return true;
    }
}

