/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.policy;

import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.policy.BasicASNSignaturePolicyValidator;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidator;
import java.util.Iterator;
import java.util.ServiceLoader;

public class SignaturePolicyValidatorLoader {
    private final SignaturePolicy signaturePolicy;

    public SignaturePolicyValidatorLoader(SignaturePolicy signaturePolicy) {
        this.signaturePolicy = signaturePolicy;
    }

    public SignaturePolicyValidator loadValidator() {
        ServiceLoader<SignaturePolicyValidator> loader = ServiceLoader.load(SignaturePolicyValidator.class);
        Iterator<SignaturePolicyValidator> validatorOptions = loader.iterator();
        SignaturePolicyValidator validator = null;
        if (validatorOptions.hasNext()) {
            for (SignaturePolicyValidator signaturePolicyValidator : loader) {
                signaturePolicyValidator.setSignaturePolicy(this.signaturePolicy);
                if (!signaturePolicyValidator.canValidate()) continue;
                validator = signaturePolicyValidator;
                break;
            }
        }
        if (validator == null) {
            validator = new BasicASNSignaturePolicyValidator();
            validator.setSignaturePolicy(this.signaturePolicy);
        }
        return validator;
    }
}

