/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.timestamp;

import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.validation.timestamp.TimestampCRLSource;
import eu.europa.esig.dss.validation.timestamp.TimestampOCSPSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class AbstractTimestampSource {
    protected void addReference(List<TimestampedReference> referenceList, TimestampedReference referenceToAdd) {
        this.addReferences(referenceList, Arrays.asList(referenceToAdd));
    }

    protected void addReference(List<TimestampedReference> referenceList, Identifier identifier, TimestampedObjectType category) {
        this.addReferences(referenceList, Arrays.asList(new TimestampedReference(identifier.asXmlId(), category)));
    }

    protected void addReferences(List<TimestampedReference> referenceList, List<TimestampedReference> referencesToAdd) {
        DSSUtils.enrichCollection(referenceList, referencesToAdd);
    }

    protected List<TimestampedReference> getReferencesFromTimestamp(TimestampToken timestampToken) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        this.addReference(references, new TimestampedReference(timestampToken.getDSSIdAsString(), TimestampedObjectType.TIMESTAMP));
        this.addReferences(references, timestampToken.getTimestampedReferences());
        this.addReferences(references, this.getEncapsulatedValuesFromTimestamp(timestampToken));
        return references;
    }

    protected List<TimestampedReference> getEncapsulatedValuesFromTimestamp(TimestampToken timestampedTimestamp) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        for (CertificateToken certificateToken : timestampedTimestamp.getCertificates()) {
            this.addReference(references, (Identifier)certificateToken.getDSSId(), TimestampedObjectType.CERTIFICATE);
        }
        for (CertificateRef certificateRef : timestampedTimestamp.getCertificateRefs()) {
            this.addReference(references, new TimestampedReference(certificateRef.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
        TimestampCRLSource timestampCRLSource = timestampedTimestamp.getCRLSource();
        for (EncapsulatedRevocationTokenIdentifier revocationBinary : timestampCRLSource.getAllRevocationBinaries()) {
            this.addReference(references, (Identifier)revocationBinary, TimestampedObjectType.REVOCATION);
        }
        for (EncapsulatedRevocationTokenIdentifier revocationBinary : timestampCRLSource.getAllReferencedRevocationBinaries()) {
            this.addReference(references, (Identifier)revocationBinary, TimestampedObjectType.REVOCATION);
        }
        TimestampOCSPSource timestampOCSPSource = timestampedTimestamp.getOCSPSource();
        for (EncapsulatedRevocationTokenIdentifier revocationBinary : timestampOCSPSource.getAllRevocationBinaries()) {
            this.addReference(references, (Identifier)revocationBinary, TimestampedObjectType.REVOCATION);
        }
        for (EncapsulatedRevocationTokenIdentifier revocationBinary : timestampOCSPSource.getAllReferencedRevocationBinaries()) {
            this.addReference(references, (Identifier)revocationBinary, TimestampedObjectType.REVOCATION);
        }
        return references;
    }

    protected List<TimestampedReference> getEncapsulatedReferencesFromTimestamps(List<TimestampToken> timestampTokens) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        for (TimestampToken timestampToken : timestampTokens) {
            this.addReferences(references, this.getReferencesFromTimestamp(timestampToken));
        }
        return references;
    }

    protected List<TimestampedReference> createReferencesForCertificates(Collection<CertificateToken> certificates) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        for (CertificateToken certificateToken : certificates) {
            this.addReference(references, new TimestampedReference(certificateToken.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
        return references;
    }

    protected List<TimestampedReference> createReferencesForIdentifiers(Collection<? extends Identifier> identifiers, TimestampedObjectType timestampedObjectType) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (Identifier identifier : identifiers) {
            timestampedReferences.add(new TimestampedReference(identifier.asXmlId(), timestampedObjectType));
        }
        return timestampedReferences;
    }
}

