/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.timestamp;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.scope.DigestSignatureScope;
import eu.europa.esig.dss.validation.scope.FullSignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.tsp.TSPException;

public class DetachedTimestampValidator
extends SignedDocumentValidator {
    protected TimestampType timestampType;
    protected TimestampToken timestampToken;

    DetachedTimestampValidator() {
    }

    public DetachedTimestampValidator(DSSDocument timestampFile) {
        this(timestampFile, TimestampType.CONTENT_TIMESTAMP);
    }

    public DetachedTimestampValidator(DSSDocument timestampFile, TimestampType timestampType) {
        this.document = timestampFile;
        this.timestampType = timestampType;
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        byte firstByte = DSSUtils.readFirstByte((DSSDocument)dssDocument);
        if (DSSASN1Utils.isASN1SequenceTag((byte)firstByte)) {
            return DSSUtils.isTimestampToken((DSSDocument)dssDocument);
        }
        return false;
    }

    @Override
    protected void assertConfigurationValid() {
        Objects.requireNonNull(this.certificateVerifier, "CertificateVerifier is not defined");
    }

    @Override
    public List<TimestampToken> getDetachedTimestamps() {
        return Collections.singletonList(this.getTimestamp());
    }

    public TimestampToken getTimestamp() {
        if (this.timestampToken == null) {
            this.timestampToken = this.createTimestampToken();
        }
        return this.timestampToken;
    }

    private TimestampToken createTimestampToken() {
        Objects.requireNonNull(this.certificateVerifier, "CertificateVerifier is not defined");
        Objects.requireNonNull(this.document, "The timestampFile must be defined!");
        Objects.requireNonNull(this.timestampType, "The TimestampType must be defined!");
        try {
            this.timestampToken = new TimestampToken(DSSUtils.toByteArray((DSSDocument)this.document), this.timestampType);
            this.timestampToken.setFileName(this.document.getName());
            this.timestampToken.matchData(this.getTimestampedData());
            List<SignatureScope> signatureScopes = this.getTimestampSignatureScopes();
            this.timestampToken.setTimestampScopes(signatureScopes);
            for (SignatureScope signatureScope : signatureScopes) {
                this.timestampToken.getTimestampedReferences().add(new TimestampedReference(signatureScope.getDSSIdAsString(), TimestampedObjectType.SIGNED_DATA));
            }
            return this.timestampToken;
        }
        catch (IOException | CMSException | TSPException e) {
            throw new DSSException(String.format("Unable to create a TimestampToken. Reason : %s", e.getMessage()), e);
        }
    }

    @Override
    public void setValidationLevel(ValidationLevel validationLevel) {
        if (ValidationLevel.BASIC_SIGNATURES == validationLevel) {
            throw new IllegalArgumentException("Minimal level is " + ValidationLevel.TIMESTAMPS);
        }
        super.setValidationLevel(validationLevel);
    }

    public void setTimestampedData(DSSDocument document) {
        Objects.requireNonNull(document, "The document is null");
        this.setDetachedContents(Arrays.asList(document));
    }

    public DSSDocument getTimestampedData() {
        int size = Utils.collectionSize((Collection)this.detachedContents);
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new DSSException("Too many files");
        }
        return (DSSDocument)this.detachedContents.iterator().next();
    }

    protected List<SignatureScope> getTimestampSignatureScopes() {
        DSSDocument timestampedData = this.getTimestampedData();
        if (timestampedData != null) {
            if (timestampedData instanceof DigestDocument) {
                return Arrays.asList(new DigestSignatureScope("Digest document", ((DigestDocument)timestampedData).getExistingDigest()));
            }
            return Arrays.asList(new FullSignatureScope("Full document", DSSUtils.getDigest((DigestAlgorithm)this.getDefaultDigestAlgorithm(), (DSSDocument)timestampedData)));
        }
        return Collections.emptyList();
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(String signatureId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        throw new UnsupportedOperationException();
    }
}

