/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.timestamp;

import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.SignatureAttribute;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureProperties;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.timestamp.AbstractTimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampDataBuilder;
import eu.europa.esig.dss.validation.timestamp.TimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampTokenComparator;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignatureTimestampSource<AS extends AdvancedSignature, SA extends SignatureAttribute>
extends AbstractTimestampSource
implements TimestampSource {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureTimestampSource.class);
    protected final AS signature;
    protected ListRevocationSource<CRL> crlSource;
    protected ListRevocationSource<OCSP> ocspSource;
    protected ListCertificateSource certificateSource;
    protected List<TimestampToken> contentTimestamps;
    protected List<TimestampToken> signatureTimestamps;
    protected List<TimestampToken> sigAndRefsTimestamps;
    protected List<TimestampToken> refsOnlyTimestamps;
    protected List<TimestampToken> archiveTimestamps;
    protected List<TimestampedReference> unsignedPropertiesReferences;
    private SignatureProperties<SA> signedSignatureProperties;
    private SignatureProperties<SA> unsignedSignatureProperties;

    protected SignatureTimestampSource(AS signature) {
        Objects.requireNonNull(signature, "The signature cannot be null!");
        this.signature = signature;
    }

    @Override
    public List<TimestampToken> getContentTimestamps() {
        if (this.contentTimestamps == null) {
            this.createAndValidate();
        }
        return this.contentTimestamps;
    }

    @Override
    public List<TimestampToken> getSignatureTimestamps() {
        if (this.signatureTimestamps == null) {
            this.createAndValidate();
        }
        return this.signatureTimestamps;
    }

    @Override
    public List<TimestampToken> getTimestampsX1() {
        if (this.sigAndRefsTimestamps == null) {
            this.createAndValidate();
        }
        return this.sigAndRefsTimestamps;
    }

    @Override
    public List<TimestampToken> getTimestampsX2() {
        if (this.refsOnlyTimestamps == null) {
            this.createAndValidate();
        }
        return this.refsOnlyTimestamps;
    }

    @Override
    public List<TimestampToken> getArchiveTimestamps() {
        if (this.archiveTimestamps == null) {
            this.createAndValidate();
        }
        return this.archiveTimestamps;
    }

    @Override
    public List<TimestampToken> getDocumentTimestamps() {
        return Collections.emptyList();
    }

    @Override
    public List<TimestampToken> getAllTimestamps() {
        ArrayList<TimestampToken> timestampTokens = new ArrayList<TimestampToken>();
        timestampTokens.addAll(this.getContentTimestamps());
        timestampTokens.addAll(this.getSignatureTimestamps());
        timestampTokens.addAll(this.getTimestampsX1());
        timestampTokens.addAll(this.getTimestampsX2());
        timestampTokens.addAll(this.getArchiveTimestamps());
        timestampTokens.addAll(this.getDocumentTimestamps());
        return timestampTokens;
    }

    @Override
    public ListCertificateSource getTimestampCertificateSources() {
        ListCertificateSource result = new ListCertificateSource();
        for (TimestampToken timestampToken : this.getAllTimestamps()) {
            result.add((CertificateSource)timestampToken.getCertificateSource());
        }
        return result;
    }

    @Override
    public ListCertificateSource getTimestampCertificateSourcesExceptLastArchiveTimestamp() {
        ListCertificateSource result = new ListCertificateSource();
        for (TimestampToken timestampToken : this.getContentTimestamps()) {
            result.add((CertificateSource)timestampToken.getCertificateSource());
        }
        for (TimestampToken timestampToken : this.getTimestampsX1()) {
            result.add((CertificateSource)timestampToken.getCertificateSource());
        }
        for (TimestampToken timestampToken : this.getTimestampsX2()) {
            result.add((CertificateSource)timestampToken.getCertificateSource());
        }
        for (TimestampToken timestampToken : this.getSignatureTimestamps()) {
            result.add((CertificateSource)timestampToken.getCertificateSource());
        }
        ArrayList<TimestampToken> archiveTimestamps = new ArrayList<TimestampToken>(this.getArchiveTimestamps());
        archiveTimestamps.addAll(this.getDocumentTimestamps());
        Collections.sort(archiveTimestamps, new TimestampTokenComparator());
        if (archiveTimestamps.size() > 0) {
            for (int ii = 0; ii < archiveTimestamps.size() - 1; ++ii) {
                TimestampToken timestampToken = (TimestampToken)((Object)archiveTimestamps.get(ii));
                result.add((CertificateSource)timestampToken.getCertificateSource());
            }
        }
        return result;
    }

    @Override
    public ListRevocationSource<CRL> getTimestampCRLSources() {
        ListRevocationSource<CRL> result = new ListRevocationSource<CRL>();
        for (TimestampToken timestampToken : this.getAllTimestamps()) {
            result.add((OfflineRevocationSource<CRL>)timestampToken.getCRLSource());
        }
        return result;
    }

    @Override
    public ListRevocationSource<OCSP> getTimestampOCSPSources() {
        ListRevocationSource<OCSP> result = new ListRevocationSource<OCSP>();
        for (TimestampToken timestampToken : this.getAllTimestamps()) {
            result.add((OfflineRevocationSource<OCSP>)timestampToken.getOCSPSource());
        }
        return result;
    }

    @Override
    public List<TimestampedReference> getUnsignedPropertiesReferences() {
        if (this.unsignedPropertiesReferences == null) {
            this.createAndValidate();
        }
        return this.unsignedPropertiesReferences;
    }

    protected void createAndValidate() {
        this.makeTimestampTokens();
        this.validateTimestamps();
    }

    @Override
    public void addExternalTimestamp(TimestampToken timestamp) {
        if (this.archiveTimestamps == null) {
            this.createAndValidate();
        }
        this.processExternalTimestamp(timestamp);
        if (TimestampType.ARCHIVE_TIMESTAMP != timestamp.getTimeStampType()) {
            throw new DSSException(String.format("The signature timestamp source does not support timestamp tokens with type [%s]. The TimestampToken was not added.", timestamp.getTimeStampType().name()));
        }
        this.archiveTimestamps.add(timestamp);
    }

    protected void makeTimestampTokens() {
        this.contentTimestamps = new ArrayList<TimestampToken>();
        this.signatureTimestamps = new ArrayList<TimestampToken>();
        this.sigAndRefsTimestamps = new ArrayList<TimestampToken>();
        this.refsOnlyTimestamps = new ArrayList<TimestampToken>();
        this.archiveTimestamps = new ArrayList<TimestampToken>();
        this.crlSource = new ListRevocationSource<CRL>(this.signature.getCRLSource());
        this.ocspSource = new ListRevocationSource<OCSP>(this.signature.getOCSPSource());
        this.certificateSource = new ListCertificateSource((CertificateSource)this.signature.getCertificateSource());
        this.unsignedPropertiesReferences = new ArrayList<TimestampedReference>();
        this.makeTimestampTokensFromSignedAttributes();
        this.makeTimestampTokensFromUnsignedAttributes();
    }

    protected void makeTimestampTokensFromSignedAttributes() {
        SignatureProperties<SA> signedSignatureProperties = this.getSignedSignatureProperties();
        if (signedSignatureProperties == null || !signedSignatureProperties.isExist()) {
            return;
        }
        for (SignatureAttribute signedAttribute : signedSignatureProperties.getAttributes()) {
            List<TimestampedReference> references;
            List<TimestampToken> timestampTokens;
            if (this.isContentTimestamp(signedAttribute) ? Utils.isCollectionEmpty(timestampTokens = this.makeTimestampTokens(signedAttribute, TimestampType.CONTENT_TIMESTAMP, this.getSignerDataReferences())) : (this.isAllDataObjectsTimestamp(signedAttribute) ? Utils.isCollectionEmpty(timestampTokens = this.makeTimestampTokens(signedAttribute, TimestampType.ALL_DATA_OBJECTS_TIMESTAMP, this.getSignerDataReferences())) : !this.isIndividualDataObjectsTimestamp(signedAttribute) || Utils.isCollectionEmpty(timestampTokens = this.makeTimestampTokens(signedAttribute, TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP, references = this.getIndividualContentTimestampedReferences(signedAttribute))))) continue;
            this.populateSources(timestampTokens);
            this.contentTimestamps.addAll(timestampTokens);
        }
    }

    protected void makeTimestampTokensFromUnsignedAttributes() {
        SignatureProperties<SA> unsignedSignatureProperties = this.getUnsignedSignatureProperties();
        if (unsignedSignatureProperties == null || !unsignedSignatureProperties.isExist()) {
            return;
        }
        ArrayList<TimestampToken> timestamps = new ArrayList<TimestampToken>();
        for (SignatureAttribute unsignedAttribute : unsignedSignatureProperties.getAttributes()) {
            List<TimestampToken> timestampTokens;
            if (this.isSignatureTimestamp(unsignedAttribute)) {
                timestampTokens = this.makeTimestampTokens(unsignedAttribute, TimestampType.SIGNATURE_TIMESTAMP, this.getSignatureTimestampReferences());
                if (Utils.isCollectionEmpty(timestampTokens)) continue;
                this.signatureTimestamps.addAll(timestampTokens);
            } else {
                ArrayList<TimestampedReference> references;
                if (this.isCompleteCertificateRef(unsignedAttribute)) {
                    this.addReferences(this.unsignedPropertiesReferences, this.getTimestampedCertificateRefs(unsignedAttribute));
                    continue;
                }
                if (this.isAttributeCertificateRef(unsignedAttribute)) {
                    this.addReferences(this.unsignedPropertiesReferences, this.getTimestampedCertificateRefs(unsignedAttribute));
                    continue;
                }
                if (this.isCompleteRevocationRef(unsignedAttribute)) {
                    this.addReferences(this.unsignedPropertiesReferences, this.getTimestampedRevocationRefs(unsignedAttribute));
                    continue;
                }
                if (this.isAttributeRevocationRef(unsignedAttribute)) {
                    this.addReferences(this.unsignedPropertiesReferences, this.getTimestampedRevocationRefs(unsignedAttribute));
                    continue;
                }
                if (this.isRefsOnlyTimestamp(unsignedAttribute)) {
                    references = new ArrayList<TimestampedReference>();
                    this.addReferences(references, this.unsignedPropertiesReferences);
                    timestampTokens = this.makeTimestampTokens(unsignedAttribute, TimestampType.VALIDATION_DATA_REFSONLY_TIMESTAMP, references);
                    if (Utils.isCollectionEmpty(timestampTokens)) continue;
                    this.refsOnlyTimestamps.addAll(timestampTokens);
                } else if (this.isSigAndRefsTimestamp(unsignedAttribute)) {
                    references = new ArrayList();
                    List<TimestampToken> signatureTimestamps = this.filterSignatureTimestamps(timestamps);
                    this.addReferences(references, this.getEncapsulatedReferencesFromTimestamps(signatureTimestamps));
                    this.addReferences(references, this.unsignedPropertiesReferences);
                    timestampTokens = this.makeTimestampTokens(unsignedAttribute, TimestampType.VALIDATION_DATA_TIMESTAMP, references);
                    if (Utils.isCollectionEmpty(timestampTokens)) continue;
                    this.sigAndRefsTimestamps.addAll(timestampTokens);
                } else {
                    if (this.isCertificateValues(unsignedAttribute)) {
                        this.addReferences(this.unsignedPropertiesReferences, this.getTimestampedCertificateValues(unsignedAttribute));
                        continue;
                    }
                    if (this.isRevocationValues(unsignedAttribute)) {
                        this.addReferences(this.unsignedPropertiesReferences, this.getTimestampedRevocationValues(unsignedAttribute));
                        continue;
                    }
                    if (this.isAttrAuthoritiesCertValues(unsignedAttribute)) {
                        this.addReferences(this.unsignedPropertiesReferences, this.getTimestampedCertificateValues(unsignedAttribute));
                        continue;
                    }
                    if (this.isAttributeRevocationValues(unsignedAttribute)) {
                        this.addReferences(this.unsignedPropertiesReferences, this.getTimestampedRevocationValues(unsignedAttribute));
                        continue;
                    }
                    if (this.isArchiveTimestamp(unsignedAttribute)) {
                        timestampTokens = this.makeTimestampTokens(unsignedAttribute, TimestampType.ARCHIVE_TIMESTAMP, new ArrayList<TimestampedReference>());
                        if (Utils.isCollectionEmpty(timestampTokens)) continue;
                        this.setArchiveTimestampType(timestampTokens, unsignedAttribute);
                        this.incorporateArchiveTimestampReferences(timestampTokens, timestamps);
                        this.archiveTimestamps.addAll(timestampTokens);
                    } else {
                        if (this.isTimeStampValidationData(unsignedAttribute)) {
                            List<TimestampedReference> timestampValidationData = this.getTimestampValidationData(unsignedAttribute);
                            this.addReferences(this.unsignedPropertiesReferences, timestampValidationData);
                            continue;
                        }
                        if (this.isCounterSignature(unsignedAttribute)) {
                            List<AdvancedSignature> counterSignatures = this.getCounterSignatures(unsignedAttribute);
                            List<TimestampedReference> counterSignatureReferences = this.getCounterSignaturesReferences(counterSignatures);
                            this.addReferences(this.unsignedPropertiesReferences, counterSignatureReferences);
                            continue;
                        }
                        if (this.isSignaturePolicyStore(unsignedAttribute)) continue;
                        LOG.warn("The unsigned attribute with a name [{}] is not supported in TimestampSource processing", (Object)unsignedAttribute);
                        continue;
                    }
                }
            }
            this.populateSources(timestampTokens);
            timestamps.addAll(timestampTokens);
        }
    }

    protected SignatureProperties<SA> getSignedSignatureProperties() {
        if (this.signedSignatureProperties == null) {
            this.signedSignatureProperties = this.buildSignedSignatureProperties();
        }
        return this.signedSignatureProperties;
    }

    protected abstract SignatureProperties<SA> buildSignedSignatureProperties();

    protected SignatureProperties<SA> getUnsignedSignatureProperties() {
        if (this.unsignedSignatureProperties == null) {
            this.unsignedSignatureProperties = this.buildUnsignedSignatureProperties();
        }
        return this.unsignedSignatureProperties;
    }

    protected abstract SignatureProperties<SA> buildUnsignedSignatureProperties();

    protected abstract boolean isContentTimestamp(SA var1);

    protected abstract boolean isAllDataObjectsTimestamp(SA var1);

    protected abstract boolean isIndividualDataObjectsTimestamp(SA var1);

    protected abstract boolean isSignatureTimestamp(SA var1);

    protected abstract boolean isCompleteCertificateRef(SA var1);

    protected abstract boolean isAttributeCertificateRef(SA var1);

    protected abstract boolean isCompleteRevocationRef(SA var1);

    protected abstract boolean isAttributeRevocationRef(SA var1);

    protected abstract boolean isRefsOnlyTimestamp(SA var1);

    protected abstract boolean isSigAndRefsTimestamp(SA var1);

    protected abstract boolean isCertificateValues(SA var1);

    protected abstract boolean isRevocationValues(SA var1);

    protected abstract boolean isAttrAuthoritiesCertValues(SA var1);

    protected abstract boolean isAttributeRevocationValues(SA var1);

    protected abstract boolean isArchiveTimestamp(SA var1);

    protected abstract boolean isTimeStampValidationData(SA var1);

    protected abstract boolean isCounterSignature(SA var1);

    protected abstract boolean isSignaturePolicyStore(SA var1);

    protected abstract TimestampToken makeTimestampToken(SA var1, TimestampType var2, List<TimestampedReference> var3);

    protected List<TimestampToken> makeTimestampTokens(SA signatureAttribute, TimestampType timestampType, List<TimestampedReference> references) {
        TimestampToken timestampToken = this.makeTimestampToken(signatureAttribute, timestampType, references);
        if (timestampToken != null) {
            return Collections.singletonList(timestampToken);
        }
        return Collections.emptyList();
    }

    @Override
    public List<TimestampedReference> getSignerDataReferences() {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        List<SignatureScope> signatureScopes = this.signature.getSignatureScopes();
        if (Utils.isCollectionNotEmpty(signatureScopes)) {
            for (SignatureScope signatureScope : signatureScopes) {
                this.addReference(references, new TimestampedReference(signatureScope.getDSSIdAsString(), TimestampedObjectType.SIGNED_DATA));
            }
        }
        return references;
    }

    protected abstract List<TimestampedReference> getIndividualContentTimestampedReferences(SA var1);

    public List<TimestampedReference> getSignatureTimestampReferences() {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        this.addReferences(references, this.getEncapsulatedReferencesFromTimestamps(this.getContentTimestamps()));
        this.addReferences(references, this.getSignerDataReferences());
        this.addReference(references, new TimestampedReference(this.signature.getId(), TimestampedObjectType.SIGNATURE));
        this.addReferences(references, this.getSigningCertificateTimestampReferences());
        return references;
    }

    protected List<TimestampedReference> getSigningCertificateTimestampReferences() {
        SignatureCertificateSource signatureCertificateSource = this.signature.getCertificateSource();
        return this.getTimestampedCertificateRefs(signatureCertificateSource.getSigningCertificateRefs(), this.certificateSource);
    }

    protected List<TimestampedReference> getTimestampedCertificateRefs(SA unsignedAttribute) {
        return this.getTimestampedCertificateRefs(this.getCertificateRefs(unsignedAttribute), this.certificateSource);
    }

    protected List<TimestampedReference> getTimestampedCertificateRefs(Collection<CertificateRef> certificateRefs, ListCertificateSource listCertificateSource) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (CertificateRef certRef : certificateRefs) {
            Set certificateTokens = listCertificateSource.findTokensFromRefs(certRef);
            if (Utils.isCollectionNotEmpty((Collection)certificateTokens)) {
                for (CertificateToken token : certificateTokens) {
                    timestampedReferences.add(new TimestampedReference(token.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
                }
                continue;
            }
            timestampedReferences.add(new TimestampedReference(certRef.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
        return timestampedReferences;
    }

    protected abstract List<CertificateRef> getCertificateRefs(SA var1);

    protected List<TimestampedReference> getTimestampedRevocationRefs(SA unsignedAttribute) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        timestampedReferences.addAll(this.getTimestampedCRLRefs(this.getCRLRefs(unsignedAttribute), this.crlSource));
        timestampedReferences.addAll(this.getTimestampedOCSPRefs(this.getOCSPRefs(unsignedAttribute), this.ocspSource));
        return timestampedReferences;
    }

    protected List<TimestampedReference> getTimestampedCRLRefs(Collection<? extends RevocationRef<CRL>> crlRefs, ListRevocationSource<CRL> crlRevocationSource) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (RevocationRef<CRL> revocationRef : crlRefs) {
            EncapsulatedRevocationTokenIdentifier<CRL> token = crlRevocationSource.findBinaryForReference(revocationRef);
            if (token != null) {
                timestampedReferences.add(new TimestampedReference(token.asXmlId(), TimestampedObjectType.REVOCATION));
                continue;
            }
            timestampedReferences.add(new TimestampedReference(revocationRef.getDSSIdAsString(), TimestampedObjectType.REVOCATION));
        }
        return timestampedReferences;
    }

    protected List<TimestampedReference> getTimestampedOCSPRefs(Collection<? extends RevocationRef<OCSP>> ocspRefs, ListRevocationSource<OCSP> ocspRevocationSource) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (RevocationRef<OCSP> revocationRef : ocspRefs) {
            EncapsulatedRevocationTokenIdentifier<OCSP> token = ocspRevocationSource.findBinaryForReference(revocationRef);
            if (token != null) {
                timestampedReferences.add(new TimestampedReference(token.asXmlId(), TimestampedObjectType.REVOCATION));
                continue;
            }
            timestampedReferences.add(new TimestampedReference(revocationRef.getDSSIdAsString(), TimestampedObjectType.REVOCATION));
        }
        return timestampedReferences;
    }

    protected abstract List<CRLRef> getCRLRefs(SA var1);

    protected abstract List<OCSPRef> getOCSPRefs(SA var1);

    protected List<TimestampedReference> getTimestampedCertificateValues(SA unsignedAttribute) {
        return this.createReferencesForIdentifiers(this.getEncapsulatedCertificateIdentifiers(unsignedAttribute), TimestampedObjectType.CERTIFICATE);
    }

    protected abstract List<Identifier> getEncapsulatedCertificateIdentifiers(SA var1);

    protected List<TimestampedReference> getTimestampedRevocationValues(SA unsignedAttribute) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        timestampedReferences.addAll(this.createReferencesForIdentifiers(this.getEncapsulatedCRLIdentifiers(unsignedAttribute), TimestampedObjectType.REVOCATION));
        timestampedReferences.addAll(this.createReferencesForIdentifiers(this.getEncapsulatedOCSPIdentifiers(unsignedAttribute), TimestampedObjectType.REVOCATION));
        return timestampedReferences;
    }

    protected abstract List<Identifier> getEncapsulatedCRLIdentifiers(SA var1);

    protected abstract List<Identifier> getEncapsulatedOCSPIdentifiers(SA var1);

    protected List<TimestampedReference> getArchiveTimestampInitialReferences(SA unsignedAttribute, List<TimestampToken> previousTimestamps) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        this.addReferences(references, this.getSignatureTimestampReferences());
        this.addReferences(references, this.getEncapsulatedReferencesFromTimestamps(previousTimestamps));
        this.addReferences(references, this.getSignerDataReferences());
        this.addReferences(references, this.unsignedPropertiesReferences);
        return references;
    }

    private void incorporateArchiveTimestampReferences(List<TimestampToken> createdTimestampTokens, List<TimestampToken> previousTimestamps) {
        for (TimestampToken timestampToken : createdTimestampTokens) {
            this.incorporateArchiveTimestampReferences(timestampToken, previousTimestamps);
        }
    }

    protected void incorporateArchiveTimestampReferences(TimestampToken timestampToken, List<TimestampToken> previousTimestamps) {
        this.addReferences(timestampToken.getTimestampedReferences(), this.getSignatureTimestampReferences());
        this.addReferences(timestampToken.getTimestampedReferences(), this.getEncapsulatedReferencesFromTimestamps(previousTimestamps));
        this.addReferences(timestampToken.getTimestampedReferences(), this.unsignedPropertiesReferences);
        this.addReferences(timestampToken.getTimestampedReferences(), this.getArchiveTimestampOtherReferences(timestampToken));
    }

    protected abstract List<TimestampedReference> getArchiveTimestampOtherReferences(TimestampToken var1);

    protected List<TimestampedReference> getSignatureSignedDataReferences() {
        return new ArrayList<TimestampedReference>();
    }

    protected List<TimestampedReference> getTimestampValidationData(SA unsignedAttribute) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        List<TimestampedReference> certTimestampedReferences = this.createReferencesForIdentifiers(this.getEncapsulatedCertificateIdentifiers(unsignedAttribute), TimestampedObjectType.CERTIFICATE);
        timestampedReferences.addAll(certTimestampedReferences);
        List<TimestampedReference> crlTimestampedReferences = this.createReferencesForIdentifiers(this.getEncapsulatedCRLIdentifiers(unsignedAttribute), TimestampedObjectType.REVOCATION);
        timestampedReferences.addAll(crlTimestampedReferences);
        List<TimestampedReference> ocspTimestampedReferences = this.createReferencesForIdentifiers(this.getEncapsulatedOCSPIdentifiers(unsignedAttribute), TimestampedObjectType.REVOCATION);
        timestampedReferences.addAll(ocspTimestampedReferences);
        return timestampedReferences;
    }

    protected List<TimestampedReference> getCounterSignaturesReferences(List<AdvancedSignature> counterSignatures) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        if (Utils.isCollectionNotEmpty(counterSignatures)) {
            for (AdvancedSignature counterSignature : counterSignatures) {
                references.addAll(this.getCounterSignatureReferences(counterSignature));
            }
        }
        return references;
    }

    protected List<TimestampedReference> getCounterSignatureReferences(AdvancedSignature counterSignature) {
        ArrayList<TimestampedReference> counterSigReferences = new ArrayList<TimestampedReference>();
        counterSigReferences.add(new TimestampedReference(counterSignature.getId(), TimestampedObjectType.SIGNATURE));
        SignatureCertificateSource signatureCertificateSource = counterSignature.getCertificateSource();
        this.addReferences(counterSigReferences, this.createReferencesForCertificates(signatureCertificateSource.getCertificates()));
        TimestampSource counterSignatureTimestampSource = counterSignature.getTimestampSource();
        this.addReferences(counterSigReferences, counterSignatureTimestampSource.getSignerDataReferences());
        this.addReferences(counterSigReferences, counterSignatureTimestampSource.getUnsignedPropertiesReferences());
        this.addReferences(counterSigReferences, this.getEncapsulatedReferencesFromTimestamps(counterSignatureTimestampSource.getAllTimestamps()));
        return counterSigReferences;
    }

    protected abstract List<AdvancedSignature> getCounterSignatures(SA var1);

    private List<TimestampToken> filterSignatureTimestamps(List<TimestampToken> previousTimestampedTimestamp) {
        ArrayList<TimestampToken> result = new ArrayList<TimestampToken>();
        for (TimestampToken timestampToken : previousTimestampedTimestamp) {
            if (!TimestampType.SIGNATURE_TIMESTAMP.equals((Object)timestampToken.getTimeStampType())) continue;
            result.add(timestampToken);
        }
        return result;
    }

    private void setArchiveTimestampType(List<TimestampToken> timestampTokens, SA unsignedAttribute) {
        ArchiveTimestampType archiveTimestampType = this.getArchiveTimestampType(unsignedAttribute);
        for (TimestampToken timestampToken : timestampTokens) {
            timestampToken.setArchiveTimestampType(archiveTimestampType);
        }
    }

    protected abstract ArchiveTimestampType getArchiveTimestampType(SA var1);

    protected void validateTimestamps() {
        DSSDocument timestampedData;
        TimestampDataBuilder timestampDataBuilder = this.getTimestampDataBuilder();
        for (TimestampToken timestampToken : this.getContentTimestamps()) {
            timestampedData = timestampDataBuilder.getContentTimestampData(timestampToken);
            timestampToken.matchData(timestampedData);
        }
        for (TimestampToken timestampToken : this.getSignatureTimestamps()) {
            timestampedData = timestampDataBuilder.getSignatureTimestampData(timestampToken);
            timestampToken.matchData(timestampedData);
        }
        for (TimestampToken timestampToken : this.getTimestampsX1()) {
            timestampedData = timestampDataBuilder.getTimestampX1Data(timestampToken);
            timestampToken.matchData(timestampedData);
        }
        for (TimestampToken timestampToken : this.getTimestampsX2()) {
            timestampedData = timestampDataBuilder.getTimestampX2Data(timestampToken);
            timestampToken.matchData(timestampedData);
        }
        for (TimestampToken timestampToken : this.getArchiveTimestamps()) {
            if (timestampToken.isProcessed()) continue;
            timestampedData = timestampDataBuilder.getArchiveTimestampData(timestampToken);
            timestampToken.matchData(timestampedData);
        }
    }

    protected abstract TimestampDataBuilder getTimestampDataBuilder();

    private void processExternalTimestamp(TimestampToken externalTimestamp) {
        this.addReferences(externalTimestamp.getTimestampedReferences(), this.getSignatureSignedDataReferences());
        this.addReferences(externalTimestamp.getTimestampedReferences(), this.getEncapsulatedReferencesFromTimestamps(this.getAllTimestamps()));
        this.addReferences(externalTimestamp.getTimestampedReferences(), this.getCounterSignatureReferences((AdvancedSignature)this.signature));
        this.populateSources(externalTimestamp);
    }

    protected void populateSources(List<TimestampToken> timestampTokens) {
        for (TimestampToken timestampToken : timestampTokens) {
            this.populateSources(timestampToken);
        }
    }

    protected void populateSources(TimestampToken timestampToken) {
        if (timestampToken != null) {
            this.certificateSource.add((CertificateSource)timestampToken.getCertificateSource());
            this.crlSource.add((OfflineRevocationSource<CRL>)timestampToken.getCRLSource());
            this.ocspSource.add((OfflineRevocationSource<OCSP>)timestampToken.getOCSPSource());
        }
    }

    @Override
    public boolean isTimestamped(String tokenId, TimestampedObjectType objectType) {
        return this.isTimestamped((AdvancedSignature)this.signature, tokenId, objectType);
    }

    private boolean isTimestamped(AdvancedSignature signature, String tokenId, TimestampedObjectType objectType) {
        for (TimestampToken timestampToken : this.getAllTimestamps()) {
            if (!timestampToken.getTimestampedReferences().contains(new TimestampedReference(tokenId, objectType))) continue;
            return true;
        }
        AdvancedSignature masterSignature = signature.getMasterSignature();
        if (masterSignature != null) {
            return this.isTimestamped(masterSignature, tokenId, objectType);
        }
        return false;
    }
}

