/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TokenExtractionStrategy;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.policy.EtsiValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicyFacade;
import eu.europa.esig.dss.policy.jaxb.ConstraintsParameters;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.client.http.NativeHTTPDataLoader;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.DiagnosticDataBuilder;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.DocumentValidatorFactory;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.OriginalIdentifierProvider;
import eu.europa.esig.dss.validation.SignaturePolicyProvider;
import eu.europa.esig.dss.validation.SignatureValidationContext;
import eu.europa.esig.dss.validation.SignedDocumentDiagnosticDataBuilder;
import eu.europa.esig.dss.validation.TokenIdentifierProvider;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.ValidationData;
import eu.europa.esig.dss.validation.ValidationDataContainer;
import eu.europa.esig.dss.validation.executor.DocumentProcessExecutor;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.executor.signature.DefaultSignatureProcessExecutor;
import eu.europa.esig.dss.validation.policy.DefaultSignaturePolicyValidatorLoader;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidatorLoader;
import eu.europa.esig.dss.validation.reports.Reports;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignedDocumentValidator
implements DocumentValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SignedDocumentValidator.class);
    protected DocumentProcessExecutor processExecutor = null;
    protected DSSDocument document;
    protected List<DSSDocument> detachedContents = new ArrayList<DSSDocument>();
    protected List<DSSDocument> containerContents;
    protected ManifestFile manifestFile;
    protected CertificateSource signingCertificateSource;
    private Date validationTime;
    protected CertificateVerifier certificateVerifier;
    private TokenExtractionStrategy tokenExtractionStrategy = TokenExtractionStrategy.NONE;
    private TokenIdentifierProvider identifierProvider = new OriginalIdentifierProvider();
    private boolean includeSemantics = false;
    protected final SignatureScopeFinder signatureScopeFinder;
    private SignaturePolicyProvider signaturePolicyProvider;
    private ValidationLevel validationLevel = ValidationLevel.ARCHIVAL_DATA;
    private Locale locale = Locale.getDefault();
    private boolean enableEtsiValidationReport = true;
    protected boolean skipValidationContextExecution = false;

    protected SignedDocumentValidator() {
        this.signatureScopeFinder = null;
    }

    protected SignedDocumentValidator(SignatureScopeFinder signatureScopeFinder) {
        this.signatureScopeFinder = signatureScopeFinder;
    }

    protected void setSignedScopeFinderDefaultDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        if (this.signatureScopeFinder != null) {
            this.signatureScopeFinder.setDefaultDigestAlgorithm(digestAlgorithm);
        }
    }

    public static SignedDocumentValidator fromDocument(DSSDocument dssDocument) {
        Objects.requireNonNull(dssDocument, "DSSDocument is null");
        ServiceLoader<DocumentValidatorFactory> serviceLoaders = ServiceLoader.load(DocumentValidatorFactory.class);
        for (DocumentValidatorFactory factory : serviceLoaders) {
            if (!factory.isSupported(dssDocument)) continue;
            return factory.create(dssDocument);
        }
        throw new UnsupportedOperationException("Document format not recognized/handled");
    }

    public abstract boolean isSupported(DSSDocument var1);

    @Override
    @Deprecated
    public void defineSigningCertificate(CertificateToken token) {
        Objects.requireNonNull(token, "Token is not defined");
        CommonCertificateSource signingCertificateResolver = new CommonCertificateSource();
        signingCertificateResolver.addCertificate(token);
        this.setSigningCertificateSource((CertificateSource)signingCertificateResolver);
    }

    @Override
    public void setSigningCertificateSource(CertificateSource signingCertificateSource) {
        this.signingCertificateSource = signingCertificateSource;
    }

    @Override
    public void setCertificateVerifier(CertificateVerifier certificateVerifier) {
        Objects.requireNonNull(certificateVerifier);
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    public void setTokenExtractionStrategy(TokenExtractionStrategy tokenExtractionStrategy) {
        Objects.requireNonNull(tokenExtractionStrategy);
        this.tokenExtractionStrategy = tokenExtractionStrategy;
    }

    @Override
    public void setTokenIdentifierProvider(TokenIdentifierProvider identifierProvider) {
        Objects.requireNonNull(identifierProvider);
        this.identifierProvider = identifierProvider;
    }

    @Override
    public void setIncludeSemantics(boolean include) {
        this.includeSemantics = include;
    }

    @Override
    public void setDetachedContents(List<DSSDocument> detachedContents) {
        this.detachedContents = detachedContents;
    }

    @Override
    public void setContainerContents(List<DSSDocument> containerContents) {
        this.containerContents = containerContents;
    }

    @Override
    public void setManifestFile(ManifestFile manifestFile) {
        this.manifestFile = manifestFile;
    }

    protected DigestAlgorithm getDefaultDigestAlgorithm() {
        return this.certificateVerifier.getDefaultDigestAlgorithm();
    }

    @Override
    public void setValidationTime(Date validationTime) {
        this.validationTime = validationTime;
    }

    protected Date getValidationTime() {
        if (this.validationTime == null) {
            this.validationTime = new Date();
        }
        return this.validationTime;
    }

    @Override
    public void setValidationLevel(ValidationLevel validationLevel) {
        this.validationLevel = validationLevel;
    }

    @Override
    public void setEnableEtsiValidationReport(boolean enableEtsiValidationReport) {
        this.enableEtsiValidationReport = enableEtsiValidationReport;
    }

    @Override
    public Reports validateDocument() {
        return this.validateDocument((InputStream)null);
    }

    @Override
    public Reports validateDocument(URL validationPolicyURL) {
        Reports reports;
        block9: {
            if (validationPolicyURL == null) {
                return this.validateDocument((InputStream)null);
            }
            InputStream is = validationPolicyURL.openStream();
            try {
                reports = this.validateDocument(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalInputException(String.format("Unable to load policy with URL '%s'. Reason : %s", validationPolicyURL, e.getMessage()), e);
                }
            }
            is.close();
        }
        return reports;
    }

    @Override
    public Reports validateDocument(String policyResourcePath) {
        Reports reports;
        block9: {
            if (policyResourcePath == null) {
                return this.validateDocument((InputStream)null);
            }
            InputStream is = this.getClass().getResourceAsStream(policyResourcePath);
            try {
                reports = this.validateDocument(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalInputException(String.format("Unable to load policy from path '%s'. Reason : %s", policyResourcePath, e.getMessage()), e);
                }
            }
            is.close();
        }
        return reports;
    }

    @Override
    public Reports validateDocument(File policyFile) {
        Reports reports;
        block9: {
            if (policyFile == null || !policyFile.exists()) {
                return this.validateDocument((InputStream)null);
            }
            InputStream is = DSSUtils.toByteArrayInputStream((File)policyFile);
            try {
                reports = this.validateDocument(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalInputException(String.format("Unable to load policy from file '%s'. Reason : %s", policyFile, e.getMessage()), e);
                }
            }
            is.close();
        }
        return reports;
    }

    @Override
    public Reports validateDocument(InputStream policyDataStream) {
        ValidationPolicy validationPolicy;
        try {
            if (policyDataStream == null) {
                LOG.debug("No provided validation policy : use the default policy");
                validationPolicy = ValidationPolicyFacade.newFacade().getDefaultValidationPolicy();
            } else {
                validationPolicy = ValidationPolicyFacade.newFacade().getValidationPolicy(policyDataStream);
            }
        }
        catch (Exception e) {
            throw new IllegalInputException("Unable to load the policy", e);
        }
        return this.validateDocument(validationPolicy);
    }

    @Override
    public Reports validateDocument(ConstraintsParameters validationPolicyJaxb) {
        EtsiValidationPolicy validationPolicy = new EtsiValidationPolicy(validationPolicyJaxb);
        return this.validateDocument((ValidationPolicy)validationPolicy);
    }

    @Override
    public Reports validateDocument(ValidationPolicy validationPolicy) {
        LOG.info("Document validation...");
        this.assertConfigurationValid();
        XmlDiagnosticData diagnosticData = this.prepareDiagnosticDataBuilder().build();
        return this.processValidationPolicy(diagnosticData, validationPolicy);
    }

    protected void assertConfigurationValid() {
        Objects.requireNonNull(this.certificateVerifier, "CertificateVerifier is not defined");
        Objects.requireNonNull(this.document, "Document is not provided to the validator");
    }

    protected DiagnosticDataBuilder prepareDiagnosticDataBuilder() {
        List<AdvancedSignature> allSignatures = this.getAllSignatures();
        List<TimestampToken> detachedTimestamps = this.getDetachedTimestamps();
        ValidationContext validationContext = this.prepareValidationContext(allSignatures, detachedTimestamps);
        if (!this.skipValidationContextExecution) {
            this.validateContext(validationContext);
        }
        return this.createDiagnosticDataBuilder(validationContext, allSignatures);
    }

    protected <T extends AdvancedSignature> ValidationContext prepareValidationContext(Collection<T> signatures, Collection<TimestampToken> detachedTimestamps) {
        SignatureValidationContext validationContext = new SignatureValidationContext();
        validationContext.initialize(this.certificateVerifier);
        this.prepareSignatureValidationContext(validationContext, signatures);
        this.prepareDetachedTimestampValidationContext(validationContext, detachedTimestamps);
        return validationContext;
    }

    protected SignedDocumentDiagnosticDataBuilder initializeDiagnosticDataBuilder() {
        return new SignedDocumentDiagnosticDataBuilder();
    }

    @Override
    public <T extends AdvancedSignature> ValidationDataContainer getValidationData(Collection<T> signatures) {
        return this.getValidationData(signatures, Collections.emptyList());
    }

    @Override
    public <T extends AdvancedSignature> ValidationDataContainer getValidationData(Collection<T> signatures, Collection<TimestampToken> detachedTimestamps) {
        if (Utils.isCollectionEmpty(signatures) && Utils.isCollectionEmpty(detachedTimestamps)) {
            throw new DSSException("At least one signature or a timestamp shall be provided to extract the validation data!");
        }
        ValidationContext validationContext = this.prepareValidationContext(signatures, detachedTimestamps);
        this.validateContext(validationContext);
        this.assertSignaturesValid(signatures, validationContext);
        ValidationDataContainer validationDataContainer = new ValidationDataContainer();
        for (AdvancedSignature signature : signatures) {
            ValidationData signatureValidationData = validationContext.getValidationData(signature);
            validationDataContainer.addValidationData(signature, signatureValidationData);
            for (TimestampToken timestampToken : signature.getAllTimestamps()) {
                ValidationData timestampValidationData = validationContext.getValidationData(timestampToken);
                validationDataContainer.addValidationData(timestampToken, timestampValidationData);
            }
            for (AdvancedSignature counterSignature : signature.getCounterSignatures()) {
                ValidationData counterSignatureValidationData = validationContext.getValidationData(counterSignature);
                validationDataContainer.addValidationData(counterSignature, counterSignatureValidationData);
            }
        }
        for (TimestampToken detachedTimestamp : detachedTimestamps) {
            ValidationData timestampValidationData = validationContext.getValidationData(detachedTimestamp);
            validationDataContainer.addValidationData(detachedTimestamp, timestampValidationData);
        }
        return validationDataContainer;
    }

    private <T extends AdvancedSignature> void assertSignaturesValid(Collection<T> signatures, ValidationContext validationContext) {
        validationContext.checkAllTimestampsValid();
        validationContext.checkAllRequiredRevocationDataPresent();
        validationContext.checkAllPOECoveredByRevocationData();
        validationContext.checkAllCertificatesValid();
        for (AdvancedSignature signature : signatures) {
            validationContext.checkAtLeastOneRevocationDataPresentAfterBestSignatureTime(signature);
            validationContext.checkSignatureNotExpired(signature);
        }
    }

    protected DiagnosticDataBuilder createDiagnosticDataBuilder(ValidationContext validationContext, List<AdvancedSignature> signatures) {
        return ((SignedDocumentDiagnosticDataBuilder)((SignedDocumentDiagnosticDataBuilder)this.initializeDiagnosticDataBuilder().document(this.document).foundSignatures(signatures).usedTimestamps(validationContext.getProcessedTimestamps()).allCertificateSources(validationContext.getAllCertificateSources()).documentCertificateSource(validationContext.getDocumentCertificateSource()).documentCRLSource(validationContext.getDocumentCRLSource()).documentOCSPSource(validationContext.getDocumentOCSPSource()).signaturePolicyProvider(this.getSignaturePolicyProvider()).signaturePolicyValidatorLoader(this.getSignaturePolicyValidatorLoader()).usedCertificates((Set)validationContext.getProcessedCertificates())).usedRevocations((Set)validationContext.getProcessedRevocations())).defaultDigestAlgorithm(this.certificateVerifier.getDefaultDigestAlgorithm()).tokenExtractionStrategy(this.tokenExtractionStrategy).tokenIdentifierProvider(this.identifierProvider).validationDate(this.getValidationTime());
    }

    protected <T extends AdvancedSignature> void prepareSignatureValidationContext(ValidationContext validationContext, Collection<T> allSignatures) {
        this.prepareSignatureForVerification(validationContext, allSignatures);
        this.processSignaturesValidation(allSignatures);
    }

    protected <T extends AdvancedSignature> void prepareSignatureForVerification(ValidationContext validationContext, Collection<T> allSignatureList) {
        for (AdvancedSignature signature : allSignatureList) {
            validationContext.addSignatureForVerification(signature);
        }
    }

    protected void prepareDetachedTimestampValidationContext(ValidationContext validationContext, Collection<TimestampToken> timestamps) {
        for (TimestampToken timestampToken : timestamps) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
    }

    protected void validateContext(ValidationContext validationContext) {
        validationContext.validate();
    }

    @Override
    public void setSignaturePolicyProvider(SignaturePolicyProvider signaturePolicyProvider) {
        this.signaturePolicyProvider = signaturePolicyProvider;
    }

    protected SignaturePolicyProvider getSignaturePolicyProvider() {
        if (this.signaturePolicyProvider == null) {
            LOG.info("Default SignaturePolicyProvider instantiated with NativeHTTPDataLoader.");
            this.signaturePolicyProvider = new SignaturePolicyProvider();
            this.signaturePolicyProvider.setDataLoader((DataLoader)new NativeHTTPDataLoader());
        }
        return this.signaturePolicyProvider;
    }

    public SignaturePolicyValidatorLoader getSignaturePolicyValidatorLoader() {
        return new DefaultSignaturePolicyValidatorLoader();
    }

    @Override
    public void setProcessExecutor(DocumentProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    protected DocumentProcessExecutor provideProcessExecutorInstance() {
        if (this.processExecutor == null) {
            this.processExecutor = this.getDefaultProcessExecutor();
        }
        return this.processExecutor;
    }

    @Override
    public DocumentProcessExecutor getDefaultProcessExecutor() {
        return new DefaultSignatureProcessExecutor();
    }

    protected final Reports processValidationPolicy(XmlDiagnosticData diagnosticData, ValidationPolicy validationPolicy) {
        DocumentProcessExecutor executor = this.provideProcessExecutorInstance();
        executor.setValidationPolicy(validationPolicy);
        executor.setValidationLevel(this.validationLevel);
        executor.setDiagnosticData(diagnosticData);
        executor.setIncludeSemantics(this.includeSemantics);
        executor.setEnableEtsiValidationReport(this.enableEtsiValidationReport);
        executor.setLocale(this.locale);
        executor.setCurrentTime(this.getValidationTime());
        return (Reports)executor.execute();
    }

    protected List<AdvancedSignature> getAllSignatures() {
        this.setSignedScopeFinderDefaultDigestAlgorithm(this.certificateVerifier.getDefaultDigestAlgorithm());
        ArrayList<AdvancedSignature> allSignatureList = new ArrayList<AdvancedSignature>();
        for (AdvancedSignature signature : this.getSignatures()) {
            allSignatureList.add(signature);
            this.appendCounterSignatures(allSignatureList, signature);
        }
        this.findSignatureScopes(allSignatureList);
        return allSignatureList;
    }

    protected void appendCounterSignatures(List<AdvancedSignature> allSignatureList, AdvancedSignature signature) {
        for (AdvancedSignature counterSignature : signature.getCounterSignatures()) {
            counterSignature.prepareOfflineCertificateVerifier(this.certificateVerifier);
            allSignatureList.add(counterSignature);
            this.appendCounterSignatures(allSignatureList, counterSignature);
        }
    }

    @Override
    public List<AdvancedSignature> getSignatures() {
        return Collections.emptyList();
    }

    @Override
    public List<TimestampToken> getDetachedTimestamps() {
        return Collections.emptyList();
    }

    @Override
    public <T extends AdvancedSignature> void processSignaturesValidation(Collection<T> allSignatureList) {
        for (AdvancedSignature signature : allSignatureList) {
            signature.checkSignatureIntegrity();
        }
    }

    @Override
    public <T extends AdvancedSignature> void findSignatureScopes(Collection<T> allSignatures) {
        for (AdvancedSignature signature : allSignatures) {
            signature.findSignatureScope(this.signatureScopeFinder);
        }
    }

    public void setSkipValidationContextExecution(boolean skipValidationContextExecution) {
        this.skipValidationContextExecution = skipValidationContextExecution;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(String signatureId) {
        AdvancedSignature advancedSignature = this.getSignatureById(signatureId);
        if (advancedSignature != null) {
            return this.getOriginalDocuments(advancedSignature);
        }
        return Collections.emptyList();
    }

    public AdvancedSignature getSignatureById(String signatureId) {
        Objects.requireNonNull(signatureId, "Signature Id cannot be null!");
        for (AdvancedSignature advancedSignature : this.getSignatures()) {
            AdvancedSignature signature = this.findSignatureRecursively(advancedSignature, signatureId);
            if (signature == null) continue;
            return signature;
        }
        return null;
    }

    private AdvancedSignature findSignatureRecursively(AdvancedSignature signature, String signatureId) {
        if (this.doesIdMatch(signature, signatureId)) {
            return signature;
        }
        for (AdvancedSignature counterSignature : signature.getCounterSignatures()) {
            AdvancedSignature advancedSignature = this.findSignatureRecursively(counterSignature, signatureId);
            if (advancedSignature == null) continue;
            return advancedSignature;
        }
        return null;
    }

    private boolean doesIdMatch(AdvancedSignature signature, String signatureId) {
        return signatureId.equals(signature.getId()) || signatureId.equals(signature.getDAIdentifier()) || signatureId.equals(this.identifierProvider.getIdAsString(signature));
    }

    protected Digest getDigest(DSSDocument document) {
        return new Digest(this.getDefaultDigestAlgorithm(), Utils.fromBase64((String)document.getDigest(this.getDefaultDigestAlgorithm())));
    }

    static {
        Security.addProvider(DSSSecurityProvider.getSecurityProvider());
    }
}

