/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.timestamp;

import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.timestamp.TimestampCRLSource;
import eu.europa.esig.dss.validation.timestamp.TimestampCertificateSource;
import eu.europa.esig.dss.validation.timestamp.TimestampOCSPSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class AbstractTimestampSource {
    protected void addReference(List<TimestampedReference> referenceList, TimestampedReference referenceToAdd) {
        this.addReferences(referenceList, Arrays.asList(referenceToAdd));
    }

    protected void addReference(List<TimestampedReference> referenceList, Identifier identifier, TimestampedObjectType category) {
        this.addReferences(referenceList, Arrays.asList(new TimestampedReference(identifier.asXmlId(), category)));
    }

    protected void addReferences(List<TimestampedReference> referenceList, List<TimestampedReference> referencesToAdd) {
        DSSUtils.enrichCollection(referenceList, referencesToAdd);
    }

    protected List<TimestampedReference> getReferencesFromTimestamp(TimestampToken timestampToken, ListCertificateSource certificateSource, ListRevocationSource<CRL> crlSource, ListRevocationSource<OCSP> ocspSource) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        this.addReference(references, new TimestampedReference(timestampToken.getDSSIdAsString(), TimestampedObjectType.TIMESTAMP));
        this.addReferences(references, timestampToken.getTimestampedReferences());
        this.addReferences(references, this.getEncapsulatedValuesFromTimestamp(timestampToken, certificateSource, crlSource, ocspSource));
        return references;
    }

    protected List<TimestampedReference> getEncapsulatedValuesFromTimestamp(TimestampToken timestampedTimestamp, ListCertificateSource certificateSource, ListRevocationSource<CRL> crlSource, ListRevocationSource<OCSP> ocspSource) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        TimestampCertificateSource timestampCertificateSource = timestampedTimestamp.getCertificateSource();
        this.addReferences(references, this.createReferencesForCertificates(timestampCertificateSource.getCertificates()));
        this.addReferences(references, this.createReferencesForCertificateRefs(timestampCertificateSource.getAllCertificateRefs(), (CertificateSource)timestampCertificateSource, certificateSource));
        TimestampCRLSource timestampCRLSource = timestampedTimestamp.getCRLSource();
        this.addReferences(references, this.createReferencesForCRLBinaries(timestampCRLSource.getAllRevocationBinaries()));
        this.addReferences(references, this.createReferencesForCRLRefs(timestampCRLSource.getAllRevocationReferences(), (OfflineRevocationSource<CRL>)timestampCRLSource, crlSource));
        TimestampOCSPSource timestampOCSPSource = timestampedTimestamp.getOCSPSource();
        this.addReferences(references, this.createReferencesForOCSPBinaries(timestampOCSPSource.getAllRevocationBinaries(), certificateSource));
        this.addReferences(references, this.createReferencesForOCSPRefs(timestampOCSPSource.getAllRevocationReferences(), (OfflineRevocationSource<OCSP>)timestampOCSPSource, certificateSource, ocspSource));
        return references;
    }

    protected List<TimestampedReference> createReferencesForCertificates(Collection<CertificateToken> certificates) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        for (CertificateToken certificateToken : certificates) {
            this.addReference(references, this.createReferenceForCertificate(certificateToken));
        }
        return references;
    }

    protected TimestampedReference createReferenceForCertificate(CertificateToken certificateToken) {
        return this.createReferenceForIdentifier((Identifier)certificateToken.getDSSId(), TimestampedObjectType.CERTIFICATE);
    }

    protected List<TimestampedReference> createReferencesForIdentifiers(Collection<? extends Identifier> identifiers, TimestampedObjectType timestampedObjectType) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (Identifier identifier : identifiers) {
            timestampedReferences.add(this.createReferenceForIdentifier(identifier, timestampedObjectType));
        }
        return timestampedReferences;
    }

    protected TimestampedReference createReferenceForIdentifier(Identifier identifier, TimestampedObjectType timestampedObjectType) {
        return new TimestampedReference(identifier.asXmlId(), timestampedObjectType);
    }

    protected List<TimestampedReference> createReferencesForCRLBinaries(Collection<? extends EncapsulatedRevocationTokenIdentifier<CRL>> crlBinaryIdentifiers) {
        return this.createReferencesForIdentifiers(crlBinaryIdentifiers, TimestampedObjectType.REVOCATION);
    }

    protected List<TimestampedReference> createReferencesForOCSPBinaries(Collection<? extends EncapsulatedRevocationTokenIdentifier<OCSP>> ocspBinaryIdentifiers, ListCertificateSource certificateSource) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        for (EncapsulatedRevocationTokenIdentifier<OCSP> encapsulatedRevocationTokenIdentifier : ocspBinaryIdentifiers) {
            if (!(encapsulatedRevocationTokenIdentifier instanceof OCSPResponseBinary)) continue;
            OCSPResponseBinary ocspResponseBinary = (OCSPResponseBinary)encapsulatedRevocationTokenIdentifier;
            this.addReferences(references, this.createReferencesForOCSPBinary(ocspResponseBinary, certificateSource));
        }
        return references;
    }

    protected List<TimestampedReference> createReferencesForOCSPBinary(OCSPResponseBinary ocspResponseBinary, ListCertificateSource certificateSource) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        this.addReference(references, this.createReferenceForIdentifier((Identifier)ocspResponseBinary, TimestampedObjectType.REVOCATION));
        OCSPCertificateSource ocspCertificateSource = new OCSPCertificateSource(ocspResponseBinary.getBasicOCSPResp());
        this.addReferences(references, this.createReferencesForCertificates(ocspCertificateSource.getCertificates()));
        this.addReferences(references, this.createReferencesForCertificateRefs(ocspCertificateSource.getAllCertificateRefs(), (CertificateSource)ocspCertificateSource, certificateSource));
        return references;
    }

    protected List<TimestampedReference> createReferencesForCertificateRefs(Collection<CertificateRef> certificateRefs, CertificateSource currentCertificateSource, ListCertificateSource listCertificateSource) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (CertificateRef certRef : certificateRefs) {
            Set certificateTokens = currentCertificateSource.findTokensFromCertRef(certRef);
            if (Utils.isCollectionEmpty((Collection)certificateTokens)) {
                certificateTokens = listCertificateSource.findTokensFromRefs(certRef);
            }
            if (Utils.isCollectionNotEmpty((Collection)certificateTokens)) {
                this.addReferences(timestampedReferences, this.createReferencesForCertificates(certificateTokens));
                continue;
            }
            this.addReference(timestampedReferences, new TimestampedReference(certRef.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
        return timestampedReferences;
    }

    protected List<TimestampedReference> createReferencesForCRLRefs(Collection<? extends RevocationRef<CRL>> crlRefs, OfflineRevocationSource<CRL> currentCRLSource, ListRevocationSource<CRL> listCRLSource) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (RevocationRef<CRL> revocationRef : crlRefs) {
            EncapsulatedRevocationTokenIdentifier<CRL> token = currentCRLSource.findBinaryForReference(revocationRef);
            if (token == null) {
                token = listCRLSource.findBinaryForReference(revocationRef);
            }
            if (token != null) {
                this.addReference(timestampedReferences, new TimestampedReference(token.asXmlId(), TimestampedObjectType.REVOCATION));
                continue;
            }
            this.addReference(timestampedReferences, new TimestampedReference(revocationRef.getDSSIdAsString(), TimestampedObjectType.REVOCATION));
        }
        return timestampedReferences;
    }

    protected List<TimestampedReference> createReferencesForOCSPRefs(Collection<? extends RevocationRef<OCSP>> ocspRefs, OfflineRevocationSource<OCSP> currentOCSPSource, ListCertificateSource listCertificateSource, ListRevocationSource<OCSP> listOCSPSource) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (RevocationRef<OCSP> revocationRef : ocspRefs) {
            EncapsulatedRevocationTokenIdentifier<OCSP> token = currentOCSPSource.findBinaryForReference(revocationRef);
            if (token == null) {
                token = listOCSPSource.findBinaryForReference(revocationRef);
            }
            if (token != null) {
                this.addReferences(timestampedReferences, this.createReferencesForOCSPBinary((OCSPResponseBinary)token, listCertificateSource));
                continue;
            }
            this.addReference(timestampedReferences, new TimestampedReference(revocationRef.getDSSIdAsString(), TimestampedObjectType.REVOCATION));
        }
        return timestampedReferences;
    }
}

