/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.timestamp;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.SignatureAttribute;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureProperties;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.timestamp.AbstractTimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampDataBuilder;
import eu.europa.esig.dss.validation.timestamp.TimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampTokenComparator;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignatureTimestampSource<AS extends AdvancedSignature, SA extends SignatureAttribute>
extends AbstractTimestampSource
implements TimestampSource {
    private static final long serialVersionUID = -6099954395130813702L;
    private static final Logger LOG = LoggerFactory.getLogger(SignatureTimestampSource.class);
    protected final AS signature;
    protected ListRevocationSource<CRL> crlSource;
    protected ListRevocationSource<OCSP> ocspSource;
    protected ListCertificateSource certificateSource;
    protected List<TimestampToken> contentTimestamps;
    protected List<TimestampToken> signatureTimestamps;
    protected List<TimestampToken> sigAndRefsTimestamps;
    protected List<TimestampToken> refsOnlyTimestamps;
    protected List<TimestampToken> archiveTimestamps;
    protected List<TimestampToken> detachedTimestamps;
    protected List<TimestampedReference> unsignedPropertiesReferences;
    private SignatureProperties<SA> signedSignatureProperties;
    private SignatureProperties<SA> unsignedSignatureProperties;

    protected SignatureTimestampSource(AS signature) {
        Objects.requireNonNull(signature, "The signature cannot be null!");
        this.signature = signature;
    }

    @Override
    public List<TimestampToken> getContentTimestamps() {
        if (this.contentTimestamps == null) {
            this.createAndValidate();
        }
        return this.contentTimestamps;
    }

    @Override
    public List<TimestampToken> getSignatureTimestamps() {
        if (this.signatureTimestamps == null) {
            this.createAndValidate();
        }
        return this.signatureTimestamps;
    }

    @Override
    public List<TimestampToken> getTimestampsX1() {
        if (this.sigAndRefsTimestamps == null) {
            this.createAndValidate();
        }
        return this.sigAndRefsTimestamps;
    }

    @Override
    public List<TimestampToken> getTimestampsX2() {
        if (this.refsOnlyTimestamps == null) {
            this.createAndValidate();
        }
        return this.refsOnlyTimestamps;
    }

    @Override
    public List<TimestampToken> getArchiveTimestamps() {
        if (this.archiveTimestamps == null) {
            this.createAndValidate();
        }
        return this.archiveTimestamps;
    }

    @Override
    public List<TimestampToken> getDocumentTimestamps() {
        return Collections.emptyList();
    }

    @Override
    public List<TimestampToken> getDetachedTimestamps() {
        if (this.detachedTimestamps == null) {
            this.createAndValidate();
        }
        return this.detachedTimestamps;
    }

    @Override
    public List<TimestampToken> getAllTimestamps() {
        ArrayList<TimestampToken> timestampTokens = new ArrayList<TimestampToken>();
        timestampTokens.addAll(this.getContentTimestamps());
        timestampTokens.addAll(this.getSignatureTimestamps());
        timestampTokens.addAll(this.getTimestampsX1());
        timestampTokens.addAll(this.getTimestampsX2());
        timestampTokens.addAll(this.getArchiveTimestamps());
        timestampTokens.addAll(this.getDocumentTimestamps());
        timestampTokens.addAll(this.getDetachedTimestamps());
        return timestampTokens;
    }

    @Override
    public ListCertificateSource getTimestampCertificateSources() {
        ListCertificateSource result = new ListCertificateSource();
        for (TimestampToken timestampToken : this.getAllTimestamps()) {
            result.add((CertificateSource)timestampToken.getCertificateSource());
        }
        return result;
    }

    @Override
    public ListCertificateSource getTimestampCertificateSourcesExceptLastArchiveTimestamp() {
        ListCertificateSource result = new ListCertificateSource();
        List<TimestampToken> timestampTokens = this.getAllTimestampsExceptLastArchiveTimestamp();
        for (TimestampToken timestampToken : timestampTokens) {
            result.add((CertificateSource)timestampToken.getCertificateSource());
        }
        return result;
    }

    @Override
    public List<TimestampToken> getAllTimestampsExceptLastArchiveTimestamp() {
        ArrayList<TimestampToken> timestampTokens = new ArrayList<TimestampToken>();
        timestampTokens.addAll(this.getContentTimestamps());
        timestampTokens.addAll(this.getSignatureTimestamps());
        timestampTokens.addAll(this.getTimestampsX1());
        timestampTokens.addAll(this.getTimestampsX2());
        ArrayList<TimestampToken> archiveTimestamps = new ArrayList<TimestampToken>(this.getArchiveTimestamps());
        archiveTimestamps.addAll(this.getDocumentTimestamps());
        archiveTimestamps.addAll(this.getDetachedTimestamps());
        archiveTimestamps.sort(new TimestampTokenComparator());
        if (archiveTimestamps.size() > 0) {
            for (int ii = 0; ii < archiveTimestamps.size() - 1; ++ii) {
                TimestampToken timestampToken = (TimestampToken)((Object)archiveTimestamps.get(ii));
                timestampTokens.add(timestampToken);
            }
        }
        return timestampTokens;
    }

    @Override
    public ListRevocationSource<CRL> getTimestampCRLSources() {
        ListRevocationSource<CRL> result = new ListRevocationSource<CRL>();
        for (TimestampToken timestampToken : this.getAllTimestamps()) {
            result.add((OfflineRevocationSource<CRL>)timestampToken.getCRLSource());
        }
        return result;
    }

    @Override
    public ListRevocationSource<OCSP> getTimestampOCSPSources() {
        ListRevocationSource<OCSP> result = new ListRevocationSource<OCSP>();
        for (TimestampToken timestampToken : this.getAllTimestamps()) {
            result.add((OfflineRevocationSource<OCSP>)timestampToken.getOCSPSource());
        }
        return result;
    }

    @Override
    public List<TimestampedReference> getUnsignedPropertiesReferences() {
        if (this.unsignedPropertiesReferences == null) {
            this.createAndValidate();
        }
        return this.unsignedPropertiesReferences;
    }

    protected void createAndValidate() {
        this.makeTimestampTokens();
        this.validateTimestamps();
    }

    @Override
    public void addExternalTimestamp(TimestampToken timestamp) {
        if (this.detachedTimestamps == null) {
            this.createAndValidate();
        }
        this.processExternalTimestamp(timestamp);
        this.detachedTimestamps.add(timestamp);
    }

    protected void makeTimestampTokens() {
        this.contentTimestamps = new ArrayList<TimestampToken>();
        this.signatureTimestamps = new ArrayList<TimestampToken>();
        this.sigAndRefsTimestamps = new ArrayList<TimestampToken>();
        this.refsOnlyTimestamps = new ArrayList<TimestampToken>();
        this.archiveTimestamps = new ArrayList<TimestampToken>();
        this.detachedTimestamps = new ArrayList<TimestampToken>();
        this.crlSource = new ListRevocationSource<CRL>(this.signature.getCRLSource());
        this.ocspSource = new ListRevocationSource<OCSP>(this.signature.getOCSPSource());
        this.certificateSource = new ListCertificateSource((CertificateSource)this.signature.getCertificateSource());
        this.unsignedPropertiesReferences = new ArrayList<TimestampedReference>();
        this.makeTimestampTokensFromSignedAttributes();
        this.makeTimestampTokensFromUnsignedAttributes();
    }

    protected void makeTimestampTokensFromSignedAttributes() {
        SignatureProperties<SA> signedSignatureProperties = this.getSignedSignatureProperties();
        if (signedSignatureProperties == null || !signedSignatureProperties.isExist()) {
            return;
        }
        for (SignatureAttribute signedAttribute : signedSignatureProperties.getAttributes()) {
            List<TimestampedReference> references;
            List<TimestampToken> timestampTokens;
            if (this.isContentTimestamp(signedAttribute) ? Utils.isCollectionEmpty(timestampTokens = this.makeTimestampTokens(signedAttribute, TimestampType.CONTENT_TIMESTAMP, this.getSignerDataReferences())) : (this.isAllDataObjectsTimestamp(signedAttribute) ? Utils.isCollectionEmpty(timestampTokens = this.makeTimestampTokens(signedAttribute, TimestampType.ALL_DATA_OBJECTS_TIMESTAMP, this.getSignerDataReferences())) : !this.isIndividualDataObjectsTimestamp(signedAttribute) || Utils.isCollectionEmpty(timestampTokens = this.makeTimestampTokens(signedAttribute, TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP, references = this.getIndividualContentTimestampedReferences(signedAttribute))))) continue;
            this.populateSources(timestampTokens);
            this.contentTimestamps.addAll(timestampTokens);
        }
    }

    protected void makeTimestampTokensFromUnsignedAttributes() {
        SignatureProperties<SA> unsignedSignatureProperties = this.getUnsignedSignatureProperties();
        if (unsignedSignatureProperties == null || !unsignedSignatureProperties.isExist()) {
            return;
        }
        ArrayList<TimestampToken> timestamps = new ArrayList<TimestampToken>();
        for (SignatureAttribute unsignedAttribute : unsignedSignatureProperties.getAttributes()) {
            List<TimestampToken> timestampTokens;
            if (this.isSignatureTimestamp(unsignedAttribute)) {
                timestampTokens = this.makeTimestampTokens(unsignedAttribute, TimestampType.SIGNATURE_TIMESTAMP, this.getSignatureTimestampReferences());
                if (Utils.isCollectionEmpty(timestampTokens)) continue;
                this.signatureTimestamps.addAll(timestampTokens);
            } else {
                ArrayList<TimestampedReference> references;
                if (this.isCompleteCertificateRef(unsignedAttribute)) {
                    this.addReferences(this.unsignedPropertiesReferences, this.getTimestampedCertificateRefs(unsignedAttribute));
                    continue;
                }
                if (this.isAttributeCertificateRef(unsignedAttribute)) {
                    this.addReferences(this.unsignedPropertiesReferences, this.getTimestampedCertificateRefs(unsignedAttribute));
                    continue;
                }
                if (this.isCompleteRevocationRef(unsignedAttribute)) {
                    this.addReferences(this.unsignedPropertiesReferences, this.getTimestampedRevocationRefs(unsignedAttribute));
                    continue;
                }
                if (this.isAttributeRevocationRef(unsignedAttribute)) {
                    this.addReferences(this.unsignedPropertiesReferences, this.getTimestampedRevocationRefs(unsignedAttribute));
                    continue;
                }
                if (this.isRefsOnlyTimestamp(unsignedAttribute)) {
                    references = new ArrayList<TimestampedReference>();
                    this.addReferences(references, this.unsignedPropertiesReferences);
                    timestampTokens = this.makeTimestampTokens(unsignedAttribute, TimestampType.VALIDATION_DATA_REFSONLY_TIMESTAMP, references);
                    if (Utils.isCollectionEmpty(timestampTokens)) continue;
                    this.refsOnlyTimestamps.addAll(timestampTokens);
                } else if (this.isSigAndRefsTimestamp(unsignedAttribute)) {
                    references = new ArrayList();
                    List<TimestampToken> signatureTimestamps = this.filterSignatureTimestamps(timestamps);
                    this.addReferences(references, this.getEncapsulatedReferencesFromTimestamps(signatureTimestamps));
                    this.addReferences(references, this.unsignedPropertiesReferences);
                    timestampTokens = this.makeTimestampTokens(unsignedAttribute, TimestampType.VALIDATION_DATA_TIMESTAMP, references);
                    if (Utils.isCollectionEmpty(timestampTokens)) continue;
                    this.sigAndRefsTimestamps.addAll(timestampTokens);
                } else {
                    if (this.isCertificateValues(unsignedAttribute)) {
                        this.addReferences(this.unsignedPropertiesReferences, this.getTimestampedCertificateValues(unsignedAttribute));
                        continue;
                    }
                    if (this.isRevocationValues(unsignedAttribute)) {
                        this.addReferences(this.unsignedPropertiesReferences, this.getTimestampedRevocationValues(unsignedAttribute));
                        continue;
                    }
                    if (this.isAttrAuthoritiesCertValues(unsignedAttribute)) {
                        this.addReferences(this.unsignedPropertiesReferences, this.getTimestampedCertificateValues(unsignedAttribute));
                        continue;
                    }
                    if (this.isAttributeRevocationValues(unsignedAttribute)) {
                        this.addReferences(this.unsignedPropertiesReferences, this.getTimestampedRevocationValues(unsignedAttribute));
                        continue;
                    }
                    if (this.isArchiveTimestamp(unsignedAttribute)) {
                        timestampTokens = this.makeTimestampTokens(unsignedAttribute, TimestampType.ARCHIVE_TIMESTAMP, new ArrayList<TimestampedReference>());
                        if (Utils.isCollectionEmpty(timestampTokens)) continue;
                        this.setArchiveTimestampType(timestampTokens, unsignedAttribute);
                        this.incorporateArchiveTimestampReferences(timestampTokens, timestamps);
                        this.archiveTimestamps.addAll(timestampTokens);
                    } else {
                        if (this.isTimeStampValidationData(unsignedAttribute)) {
                            List<TimestampedReference> timestampValidationData = this.getTimestampValidationData(unsignedAttribute);
                            this.addReferences(this.unsignedPropertiesReferences, timestampValidationData);
                            continue;
                        }
                        if (this.isCounterSignature(unsignedAttribute)) {
                            List<AdvancedSignature> counterSignatures = this.getCounterSignatures(unsignedAttribute);
                            List<TimestampedReference> counterSignatureReferences = this.getCounterSignaturesReferences(counterSignatures);
                            this.addReferences(this.unsignedPropertiesReferences, counterSignatureReferences);
                            continue;
                        }
                        if (this.isSignaturePolicyStore(unsignedAttribute)) continue;
                        LOG.warn("The unsigned attribute with a name [{}] is not supported in TimestampSource processing", (Object)unsignedAttribute);
                        continue;
                    }
                }
            }
            this.populateSources(timestampTokens);
            timestamps.addAll(timestampTokens);
        }
    }

    protected SignatureProperties<SA> getSignedSignatureProperties() {
        if (this.signedSignatureProperties == null) {
            this.signedSignatureProperties = this.buildSignedSignatureProperties();
        }
        return this.signedSignatureProperties;
    }

    protected abstract SignatureProperties<SA> buildSignedSignatureProperties();

    protected SignatureProperties<SA> getUnsignedSignatureProperties() {
        if (this.unsignedSignatureProperties == null) {
            this.unsignedSignatureProperties = this.buildUnsignedSignatureProperties();
        }
        return this.unsignedSignatureProperties;
    }

    protected abstract SignatureProperties<SA> buildUnsignedSignatureProperties();

    protected abstract boolean isContentTimestamp(SA var1);

    protected abstract boolean isAllDataObjectsTimestamp(SA var1);

    protected abstract boolean isIndividualDataObjectsTimestamp(SA var1);

    protected abstract boolean isSignatureTimestamp(SA var1);

    protected abstract boolean isCompleteCertificateRef(SA var1);

    protected abstract boolean isAttributeCertificateRef(SA var1);

    protected abstract boolean isCompleteRevocationRef(SA var1);

    protected abstract boolean isAttributeRevocationRef(SA var1);

    protected abstract boolean isRefsOnlyTimestamp(SA var1);

    protected abstract boolean isSigAndRefsTimestamp(SA var1);

    protected abstract boolean isCertificateValues(SA var1);

    protected abstract boolean isRevocationValues(SA var1);

    protected abstract boolean isAttrAuthoritiesCertValues(SA var1);

    protected abstract boolean isAttributeRevocationValues(SA var1);

    protected abstract boolean isArchiveTimestamp(SA var1);

    protected abstract boolean isTimeStampValidationData(SA var1);

    protected abstract boolean isCounterSignature(SA var1);

    protected abstract boolean isSignaturePolicyStore(SA var1);

    protected abstract TimestampToken makeTimestampToken(SA var1, TimestampType var2, List<TimestampedReference> var3);

    protected List<TimestampToken> makeTimestampTokens(SA signatureAttribute, TimestampType timestampType, List<TimestampedReference> references) {
        TimestampToken timestampToken = this.makeTimestampToken(signatureAttribute, timestampType, references);
        if (timestampToken != null) {
            return Collections.singletonList(timestampToken);
        }
        return Collections.emptyList();
    }

    @Override
    public List<TimestampedReference> getSignerDataReferences() {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        this.populateSignerDataReferencesList(references, this.signature.getSignatureScopes());
        return references;
    }

    protected void populateSignerDataReferencesList(List<TimestampedReference> result, List<SignatureScope> signatureScopes) {
        if (Utils.isCollectionNotEmpty(signatureScopes)) {
            for (SignatureScope signatureScope : signatureScopes) {
                this.addReference(result, new TimestampedReference(signatureScope.getDSSIdAsString(), TimestampedObjectType.SIGNED_DATA));
                if (!Utils.isCollectionNotEmpty(signatureScope.getChildren())) continue;
                this.populateSignerDataReferencesList(result, signatureScope.getChildren());
            }
        }
    }

    protected abstract List<TimestampedReference> getIndividualContentTimestampedReferences(SA var1);

    protected List<TimestampedReference> getSignatureTimestampReferences() {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        this.addReferences(references, this.getEncapsulatedReferencesFromTimestamps(this.getContentTimestamps()));
        this.addReferences(references, this.getSignerDataReferences());
        this.addReference(references, new TimestampedReference(this.signature.getId(), TimestampedObjectType.SIGNATURE));
        this.addReferences(references, this.getSigningCertificateTimestampReferences());
        return references;
    }

    protected List<TimestampedReference> getEncapsulatedReferencesFromTimestamps(List<TimestampToken> timestampTokens) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        for (TimestampToken timestampToken : timestampTokens) {
            this.addReferences(references, this.getReferencesFromTimestamp(timestampToken, this.certificateSource, this.crlSource, this.ocspSource));
        }
        return references;
    }

    protected List<TimestampedReference> getSigningCertificateTimestampReferences() {
        SignatureCertificateSource signatureCertificateSource = this.signature.getCertificateSource();
        return this.createReferencesForCertificateRefs(signatureCertificateSource.getSigningCertificateRefs(), (CertificateSource)signatureCertificateSource, this.certificateSource);
    }

    protected List<TimestampedReference> getKeyInfoReferences() {
        SignatureCertificateSource signatureCertificateSource = this.signature.getCertificateSource();
        return this.createReferencesForCertificates(signatureCertificateSource.getKeyInfoCertificates());
    }

    protected List<TimestampedReference> getTimestampedCertificateRefs(SA unsignedAttribute) {
        return this.createReferencesForCertificateRefs(this.getCertificateRefs(unsignedAttribute), (CertificateSource)this.signature.getCertificateSource(), this.certificateSource);
    }

    protected abstract List<CertificateRef> getCertificateRefs(SA var1);

    protected List<TimestampedReference> getTimestampedRevocationRefs(SA unsignedAttribute) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        timestampedReferences.addAll(this.createReferencesForCRLRefs(this.getCRLRefs(unsignedAttribute), this.signature.getCRLSource(), this.crlSource));
        timestampedReferences.addAll(this.createReferencesForOCSPRefs(this.getOCSPRefs(unsignedAttribute), this.signature.getOCSPSource(), this.certificateSource, this.ocspSource));
        return timestampedReferences;
    }

    protected abstract List<CRLRef> getCRLRefs(SA var1);

    protected abstract List<OCSPRef> getOCSPRefs(SA var1);

    protected List<TimestampedReference> getTimestampedCertificateValues(SA unsignedAttribute) {
        return this.createReferencesForIdentifiers(this.getEncapsulatedCertificateIdentifiers(unsignedAttribute), TimestampedObjectType.CERTIFICATE);
    }

    protected abstract List<Identifier> getEncapsulatedCertificateIdentifiers(SA var1);

    protected List<TimestampedReference> getTimestampedRevocationValues(SA unsignedAttribute) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        timestampedReferences.addAll(this.createReferencesForCRLBinaries(this.getEncapsulatedCRLIdentifiers(unsignedAttribute)));
        timestampedReferences.addAll(this.createReferencesForOCSPBinaries(this.getEncapsulatedOCSPIdentifiers(unsignedAttribute), this.certificateSource));
        return timestampedReferences;
    }

    protected abstract List<CRLBinary> getEncapsulatedCRLIdentifiers(SA var1);

    protected abstract List<OCSPResponseBinary> getEncapsulatedOCSPIdentifiers(SA var1);

    private void incorporateArchiveTimestampReferences(List<TimestampToken> createdTimestampTokens, List<TimestampToken> previousTimestamps) {
        for (TimestampToken timestampToken : createdTimestampTokens) {
            this.incorporateArchiveTimestampReferences(timestampToken, previousTimestamps);
        }
    }

    protected void incorporateArchiveTimestampReferences(TimestampToken timestampToken, List<TimestampToken> previousTimestamps) {
        this.addReferences(timestampToken.getTimestampedReferences(), this.getSignatureTimestampReferences());
        this.addReferences(timestampToken.getTimestampedReferences(), this.getEncapsulatedReferencesFromTimestamps(previousTimestamps));
        this.addReferences(timestampToken.getTimestampedReferences(), this.unsignedPropertiesReferences);
        this.addReferences(timestampToken.getTimestampedReferences(), this.getArchiveTimestampOtherReferences(timestampToken));
    }

    protected abstract List<TimestampedReference> getArchiveTimestampOtherReferences(TimestampToken var1);

    protected List<TimestampedReference> getSignatureSignedDataReferences() {
        return new ArrayList<TimestampedReference>();
    }

    protected List<TimestampedReference> getTimestampValidationData(SA unsignedAttribute) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        this.addReferences(timestampedReferences, this.createReferencesForIdentifiers(this.getEncapsulatedCertificateIdentifiers(unsignedAttribute), TimestampedObjectType.CERTIFICATE));
        this.addReferences(timestampedReferences, this.createReferencesForCRLBinaries(this.getEncapsulatedCRLIdentifiers(unsignedAttribute)));
        this.addReferences(timestampedReferences, this.createReferencesForOCSPBinaries(this.getEncapsulatedOCSPIdentifiers(unsignedAttribute), this.certificateSource));
        return timestampedReferences;
    }

    protected List<TimestampedReference> getCounterSignaturesReferences(List<AdvancedSignature> counterSignatures) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        if (Utils.isCollectionNotEmpty(counterSignatures)) {
            for (AdvancedSignature counterSignature : counterSignatures) {
                references.addAll(this.getCounterSignatureReferences(counterSignature));
            }
        }
        return references;
    }

    protected List<TimestampedReference> getCounterSignatureReferences(AdvancedSignature counterSignature) {
        ArrayList<TimestampedReference> counterSigReferences = new ArrayList<TimestampedReference>();
        counterSigReferences.add(new TimestampedReference(counterSignature.getId(), TimestampedObjectType.SIGNATURE));
        SignatureCertificateSource signatureCertificateSource = counterSignature.getCertificateSource();
        this.addReferences(counterSigReferences, this.createReferencesForCertificates(signatureCertificateSource.getCertificates()));
        TimestampSource counterSignatureTimestampSource = counterSignature.getTimestampSource();
        this.addReferences(counterSigReferences, counterSignatureTimestampSource.getSignerDataReferences());
        this.addReferences(counterSigReferences, counterSignatureTimestampSource.getUnsignedPropertiesReferences());
        this.addReferences(counterSigReferences, this.getEncapsulatedReferencesFromTimestamps(counterSignatureTimestampSource.getAllTimestamps()));
        return counterSigReferences;
    }

    protected abstract List<AdvancedSignature> getCounterSignatures(SA var1);

    private List<TimestampToken> filterSignatureTimestamps(List<TimestampToken> previousTimestampedTimestamp) {
        ArrayList<TimestampToken> result = new ArrayList<TimestampToken>();
        for (TimestampToken timestampToken : previousTimestampedTimestamp) {
            if (!TimestampType.SIGNATURE_TIMESTAMP.equals((Object)timestampToken.getTimeStampType())) continue;
            result.add(timestampToken);
        }
        return result;
    }

    private void setArchiveTimestampType(List<TimestampToken> timestampTokens, SA unsignedAttribute) {
        ArchiveTimestampType archiveTimestampType = this.getArchiveTimestampType(unsignedAttribute);
        for (TimestampToken timestampToken : timestampTokens) {
            timestampToken.setArchiveTimestampType(archiveTimestampType);
        }
    }

    protected abstract ArchiveTimestampType getArchiveTimestampType(SA var1);

    protected void validateTimestamps() {
        DSSDocument timestampedData;
        TimestampDataBuilder timestampDataBuilder = this.getTimestampDataBuilder();
        for (TimestampToken timestampToken : this.getContentTimestamps()) {
            timestampedData = timestampDataBuilder.getContentTimestampData(timestampToken);
            timestampToken.matchData(timestampedData);
        }
        for (TimestampToken timestampToken : this.getSignatureTimestamps()) {
            timestampedData = timestampDataBuilder.getSignatureTimestampData(timestampToken);
            timestampToken.matchData(timestampedData);
        }
        for (TimestampToken timestampToken : this.getTimestampsX1()) {
            timestampedData = timestampDataBuilder.getTimestampX1Data(timestampToken);
            timestampToken.matchData(timestampedData);
        }
        for (TimestampToken timestampToken : this.getTimestampsX2()) {
            timestampedData = timestampDataBuilder.getTimestampX2Data(timestampToken);
            timestampToken.matchData(timestampedData);
        }
        for (TimestampToken timestampToken : this.getArchiveTimestamps()) {
            if (timestampToken.isProcessed()) continue;
            timestampedData = timestampDataBuilder.getArchiveTimestampData(timestampToken);
            timestampToken.matchData(timestampedData);
        }
    }

    protected abstract TimestampDataBuilder getTimestampDataBuilder();

    private void processExternalTimestamp(TimestampToken externalTimestamp) {
        this.addReferences(externalTimestamp.getTimestampedReferences(), this.getSignatureSignedDataReferences());
        this.addReferences(externalTimestamp.getTimestampedReferences(), this.getEncapsulatedReferencesFromTimestamps(this.getTimestampsCoveredByExternalTimestamp(externalTimestamp)));
        this.addReferences(externalTimestamp.getTimestampedReferences(), this.getCounterSignatureReferences((AdvancedSignature)this.signature));
        this.populateSources(externalTimestamp);
    }

    private List<TimestampToken> getTimestampsCoveredByExternalTimestamp(TimestampToken externalTimestamp) {
        ArrayList<TimestampToken> result = new ArrayList<TimestampToken>();
        for (TimestampToken timestampToken : this.getAllTimestamps()) {
            ManifestFile manifestFile;
            if (this.detachedTimestamps.contains((Object)timestampToken) && ((manifestFile = externalTimestamp.getManifestFile()) == null || !manifestFile.isDocumentCovered(timestampToken.getFileName()))) continue;
            result.add(timestampToken);
        }
        return result;
    }

    protected void populateSources(List<TimestampToken> timestampTokens) {
        for (TimestampToken timestampToken : timestampTokens) {
            this.populateSources(timestampToken);
        }
    }

    protected void populateSources(TimestampToken timestampToken) {
        if (timestampToken != null) {
            this.certificateSource.add((CertificateSource)timestampToken.getCertificateSource());
            this.crlSource.add((OfflineRevocationSource<CRL>)timestampToken.getCRLSource());
            this.ocspSource.add((OfflineRevocationSource<OCSP>)timestampToken.getOCSPSource());
        }
    }

    @Override
    public boolean isTimestamped(String tokenId, TimestampedObjectType objectType) {
        return this.isTimestamped((AdvancedSignature)this.signature, tokenId, objectType);
    }

    private boolean isTimestamped(AdvancedSignature signature, String tokenId, TimestampedObjectType objectType) {
        for (TimestampToken timestampToken : this.getAllTimestamps()) {
            if (!timestampToken.getTimestampedReferences().contains(new TimestampedReference(tokenId, objectType))) continue;
            return true;
        }
        AdvancedSignature masterSignature = signature.getMasterSignature();
        if (masterSignature != null) {
            return this.isTimestamped(masterSignature, tokenId, objectType);
        }
        return false;
    }
}

