/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.evidencerecord;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.validation.DocumentValidatorFactory;
import eu.europa.esig.dss.validation.evidencerecord.EvidenceRecordValidator;
import java.util.Objects;
import java.util.ServiceLoader;

public interface EvidenceRecordValidatorFactory
extends DocumentValidatorFactory {
    @Override
    public boolean isSupported(DSSDocument var1);

    @Override
    public EvidenceRecordValidator create(DSSDocument var1);

    public static boolean isSupportedDocument(DSSDocument document) {
        Objects.requireNonNull(document, "DSSDocument is null");
        ServiceLoader<EvidenceRecordValidatorFactory> serviceLoaders = ServiceLoader.load(EvidenceRecordValidatorFactory.class);
        for (EvidenceRecordValidatorFactory factory : serviceLoaders) {
            if (!factory.isSupported(document)) continue;
            return true;
        }
        return false;
    }

    public static EvidenceRecordValidator fromDocument(DSSDocument document) throws UnsupportedOperationException {
        Objects.requireNonNull(document, "DSSDocument is null");
        ServiceLoader<EvidenceRecordValidatorFactory> serviceLoaders = ServiceLoader.load(EvidenceRecordValidatorFactory.class);
        for (EvidenceRecordValidatorFactory factory : serviceLoaders) {
            if (!factory.isSupported(document)) continue;
            return factory.create(document);
        }
        throw new UnsupportedOperationException("Document format not recognized/handled");
    }
}

