/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.timestamp;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.x509.tsp.TimestampIdentifierBuilder;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignatureAttribute;
import java.io.IOException;
import java.util.Objects;
import org.bouncycastle.tsp.TimeStampToken;

public class SignatureTimestampIdentifierBuilder
extends TimestampIdentifierBuilder {
    private static final long serialVersionUID = -1948364785002670303L;
    private static final String ORDER_OF_ATTRIBUTE_PREFIX = "-OOA-";
    private static final String ORDER_WITHIN_ATTRIBUTE_PREFIX = "-OWA-";
    private AdvancedSignature signature;
    private SignatureAttribute attribute;
    private Integer orderOfAttribute;
    private Integer orderWithinAttribute;

    public SignatureTimestampIdentifierBuilder(byte[] timestampTokenBinaries) {
        super(timestampTokenBinaries);
    }

    public SignatureTimestampIdentifierBuilder(TimeStampToken timeStampToken) {
        this(SignatureTimestampIdentifierBuilder.getEncoded(timeStampToken));
    }

    private static byte[] getEncoded(TimeStampToken timeStampToken) {
        Objects.requireNonNull(timeStampToken, "TimeStampToken cannot be null!");
        try {
            return timeStampToken.getEncoded();
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to get time-stamp token binaries! Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    public SignatureTimestampIdentifierBuilder setSignature(AdvancedSignature signature) {
        this.signature = signature;
        return this;
    }

    public SignatureTimestampIdentifierBuilder setAttribute(SignatureAttribute attribute) {
        this.attribute = attribute;
        return this;
    }

    public SignatureTimestampIdentifierBuilder setOrderOfAttribute(Integer orderOfAttribute) {
        this.orderOfAttribute = orderOfAttribute;
        return this;
    }

    public SignatureTimestampIdentifierBuilder setOrderWithinAttribute(Integer orderWithinAttribute) {
        this.orderWithinAttribute = orderWithinAttribute;
        return this;
    }

    protected String getTimestampPosition() {
        StringBuilder sb = new StringBuilder();
        if (this.signature != null) {
            sb.append(this.signature.getId());
        }
        if (this.attribute != null) {
            sb.append(this.attribute.getIdentifier().asXmlId());
        }
        if (this.orderOfAttribute != null) {
            sb.append(ORDER_OF_ATTRIBUTE_PREFIX);
            sb.append(this.orderOfAttribute);
        }
        if (this.orderWithinAttribute != null) {
            sb.append(ORDER_WITHIN_ATTRIBUTE_PREFIX);
            sb.append(this.orderWithinAttribute);
        }
        return sb.toString();
    }
}

