/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.scope;

import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.validation.scope.FullSignatureScope;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EvidenceRecordScopeFinder {
    protected final EvidenceRecord evidenceRecord;

    public EvidenceRecordScopeFinder(EvidenceRecord evidenceRecord) {
        Objects.requireNonNull(evidenceRecord, "EvidenceRecord shall be provided!");
        this.evidenceRecord = evidenceRecord;
    }

    public List<SignatureScope> findEvidenceRecordScope() {
        return this.findEvidenceRecordScope(this.evidenceRecord.getReferenceValidation());
    }

    protected List<SignatureScope> findEvidenceRecordScope(List<ReferenceValidation> referenceValidations) {
        ArrayList<SignatureScope> signatureScopes = new ArrayList<SignatureScope>();
        List<DSSDocument> detachedContents = this.evidenceRecord.getDetachedContents();
        ArrayList<DSSDocument> coveredDocuments = new ArrayList<DSSDocument>();
        for (ReferenceValidation referenceValidation : referenceValidations) {
            DSSDocument detachedDocument;
            if (!referenceValidation.isFound() || !DigestMatcherType.EVIDENCE_RECORD_ARCHIVE_OBJECT.equals((Object)referenceValidation.getType()) || (detachedDocument = Utils.collectionSize(detachedContents) == 1 ? detachedContents.iterator().next() : this.getDetachedDocument(referenceValidation, detachedContents)) == null || coveredDocuments.contains(detachedDocument)) continue;
            signatureScopes.add(new FullSignatureScope(detachedDocument.getName() != null ? detachedDocument.getName() : "Full document", detachedDocument));
            coveredDocuments.add(detachedDocument);
        }
        return signatureScopes;
    }

    private DSSDocument getDetachedDocument(ReferenceValidation referenceValidation, List<DSSDocument> detachedDocuments) {
        for (DSSDocument document : detachedDocuments) {
            Objects.requireNonNull(document.getName(), "Name shall be defined when multiple documents provided!");
            if (!referenceValidation.getName().equals(document.getName())) continue;
            return document;
        }
        return null;
    }
}

