/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import eu.europa.esig.dss.enumerations.OidAndUriBasedEnum;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;

public enum DigestAlgorithm implements OidAndUriBasedEnum
{
    SHA1("SHA1", "SHA-1", "1.3.14.3.2.26", "http://www.w3.org/2000/09/xmldsig#sha1", null, "SHA", 20),
    SHA224("SHA224", "SHA-224", "2.16.840.1.101.3.4.2.4", "http://www.w3.org/2001/04/xmldsig-more#sha224", "S224", 28),
    SHA256("SHA256", "SHA-256", "2.16.840.1.101.3.4.2.1", "http://www.w3.org/2001/04/xmlenc#sha256", "S256", "SHA-256", 32),
    SHA384("SHA384", "SHA-384", "2.16.840.1.101.3.4.2.2", "http://www.w3.org/2001/04/xmldsig-more#sha384", "S384", 48),
    SHA512("SHA512", "SHA-512", "2.16.840.1.101.3.4.2.3", "http://www.w3.org/2001/04/xmlenc#sha512", "S512", "SHA-512", 64),
    SHA3_224("SHA3-224", "SHA3-224", "2.16.840.1.101.3.4.2.7", "http://www.w3.org/2007/05/xmldsig-more#sha3-224", 28),
    SHA3_256("SHA3-256", "SHA3-256", "2.16.840.1.101.3.4.2.8", "http://www.w3.org/2007/05/xmldsig-more#sha3-256", "S3-256", 32),
    SHA3_384("SHA3-384", "SHA3-384", "2.16.840.1.101.3.4.2.9", "http://www.w3.org/2007/05/xmldsig-more#sha3-384", "S3-384", 48),
    SHA3_512("SHA3-512", "SHA3-512", "2.16.840.1.101.3.4.2.10", "http://www.w3.org/2007/05/xmldsig-more#sha3-512", "S3-512", 64),
    SHAKE128("SHAKE-128", "SHAKE-128", "2.16.840.1.101.3.4.2.11", null),
    SHAKE256("SHAKE-256", "SHAKE-256", "2.16.840.1.101.3.4.2.12", null),
    SHAKE256_512("SHAKE256-512", "SHAKE256-512", "2.16.840.1.101.3.4.2.18", null),
    RIPEMD160("RIPEMD160", "RIPEMD160", "1.3.36.3.2.1", "http://www.w3.org/2001/04/xmlenc#ripemd160"),
    MD2("MD2", "MD2", "1.2.840.113549.2.2", "http://www.w3.org/2001/04/xmldsig-more#md2"),
    MD5("MD5", "MD5", "1.2.840.113549.2.5", "http://www.w3.org/2001/04/xmldsig-more#md5", null, "MD5"),
    WHIRLPOOL("WHIRLPOOL", "WHIRLPOOL", "1.0.10118.3.0.55", "http://www.w3.org/2007/05/xmldsig-more#whirlpool");

    private final String name;
    private final String javaName;
    private final String oid;
    private final String xmlId;
    private final String jadesId;
    private final String httpHeaderId;
    private final int saltLength;

    public static DigestAlgorithm forName(String name) {
        DigestAlgorithm algorithm = (DigestAlgorithm)Registry.ALGORITHMS.get(name);
        if (algorithm == null) {
            throw new IllegalArgumentException("Unsupported algorithm: " + name);
        }
        return algorithm;
    }

    public static DigestAlgorithm forName(String name, DigestAlgorithm defaultValue) {
        DigestAlgorithm algorithm = (DigestAlgorithm)Registry.ALGORITHMS.get(name);
        if (algorithm == null) {
            return defaultValue;
        }
        return algorithm;
    }

    public static boolean isSupportedAlgorithm(String name) {
        return Registry.ALGORITHMS.get(name) != null;
    }

    public static DigestAlgorithm forJavaName(String javaName) {
        DigestAlgorithm algorithm = (DigestAlgorithm)Registry.JAVA_ALGORITHMS.get(javaName);
        if (algorithm == null) {
            throw new IllegalArgumentException("Unsupported algorithm: " + javaName);
        }
        return algorithm;
    }

    public static DigestAlgorithm forOID(String oid) {
        DigestAlgorithm algorithm = (DigestAlgorithm)Registry.OID_ALGORITHMS.get(oid);
        if (algorithm == null) {
            throw new IllegalArgumentException("Unsupported algorithm: " + oid);
        }
        return algorithm;
    }

    public static DigestAlgorithm forXML(String xmlName) {
        DigestAlgorithm algorithm = (DigestAlgorithm)Registry.XML_ALGORITHMS.get(xmlName);
        if (algorithm == null) {
            throw new IllegalArgumentException("Unsupported algorithm: " + xmlName);
        }
        return algorithm;
    }

    public static DigestAlgorithm forJAdES(String algoId) {
        DigestAlgorithm algorithm = (DigestAlgorithm)Registry.JADES_ALGORITHMS.get(algoId);
        if (algorithm == null) {
            throw new IllegalArgumentException("Unsupported algorithm: " + algoId);
        }
        return algorithm;
    }

    public static DigestAlgorithm forHttpHeader(String hashName) {
        DigestAlgorithm algorithm = (DigestAlgorithm)Registry.HTTP_HEADER_ALGORITHMS.get(hashName);
        if (algorithm == null) {
            throw new IllegalArgumentException("Unsupported algorithm: " + hashName);
        }
        return algorithm;
    }

    private DigestAlgorithm(String name, String javaName, String oid, String xmlId) {
        this(name, javaName, oid, xmlId, null, 0);
    }

    private DigestAlgorithm(String name, String javaName, String oid, String xmlId, String jadesId, String httpHeaderId) {
        this(name, javaName, oid, xmlId, jadesId, httpHeaderId, 0);
    }

    private DigestAlgorithm(String name, String javaName, String oid, String xmlId, int saltLength) {
        this(name, javaName, oid, xmlId, null, saltLength);
    }

    private DigestAlgorithm(String name, String javaName, String oid, String xmlId, String jadesId, int saltLength) {
        this(name, javaName, oid, xmlId, jadesId, null, saltLength);
    }

    private DigestAlgorithm(String name, String javaName, String oid, String xmlId, String jadesId, String jwsHttpHeader, int saltLength) {
        this.name = name;
        this.javaName = javaName;
        this.oid = oid;
        this.xmlId = xmlId;
        this.jadesId = jadesId;
        this.httpHeaderId = jwsHttpHeader;
        this.saltLength = saltLength;
    }

    public String getName() {
        return this.name;
    }

    public String getJavaName() {
        return this.javaName;
    }

    @Override
    public String getOid() {
        return this.oid;
    }

    @Override
    public String getUri() {
        return this.xmlId;
    }

    public String getJAdESId() {
        return this.jadesId;
    }

    public String getHttpHeaderAlgo() {
        return this.httpHeaderId;
    }

    public int getSaltLength() {
        return this.saltLength;
    }

    public MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(this.javaName);
    }

    public MessageDigest getMessageDigest(Provider provider) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(this.javaName, provider);
    }

    private static class Registry {
        private static final Map<String, DigestAlgorithm> OID_ALGORITHMS = Registry.registerOIDAlgorithms();
        private static final Map<String, DigestAlgorithm> XML_ALGORITHMS = Registry.registerXMLAlgorithms();
        private static final Map<String, DigestAlgorithm> ALGORITHMS = Registry.registerAlgorithms();
        private static final Map<String, DigestAlgorithm> JAVA_ALGORITHMS = Registry.registerJavaAlgorithms();
        private static final Map<String, DigestAlgorithm> JADES_ALGORITHMS = Registry.registerJAdESAlgorithms();
        private static final Map<String, DigestAlgorithm> HTTP_HEADER_ALGORITHMS = Registry.registerJwsHttpHeaderAlgorithms();

        private Registry() {
        }

        private static Map<String, DigestAlgorithm> registerOIDAlgorithms() {
            HashMap<String, DigestAlgorithm> map = new HashMap<String, DigestAlgorithm>();
            for (DigestAlgorithm digestAlgorithm : DigestAlgorithm.values()) {
                map.put(digestAlgorithm.oid, digestAlgorithm);
            }
            return map;
        }

        private static Map<String, DigestAlgorithm> registerXMLAlgorithms() {
            HashMap<String, DigestAlgorithm> map = new HashMap<String, DigestAlgorithm>();
            for (DigestAlgorithm digestAlgorithm : DigestAlgorithm.values()) {
                map.put(digestAlgorithm.xmlId, digestAlgorithm);
            }
            return map;
        }

        private static Map<String, DigestAlgorithm> registerAlgorithms() {
            HashMap<String, DigestAlgorithm> map = new HashMap<String, DigestAlgorithm>();
            for (DigestAlgorithm digestAlgorithm : DigestAlgorithm.values()) {
                map.put(digestAlgorithm.name, digestAlgorithm);
            }
            return map;
        }

        private static Map<String, DigestAlgorithm> registerJavaAlgorithms() {
            HashMap<String, DigestAlgorithm> map = new HashMap<String, DigestAlgorithm>();
            for (DigestAlgorithm digestAlgorithm : DigestAlgorithm.values()) {
                map.put(digestAlgorithm.javaName, digestAlgorithm);
            }
            return map;
        }

        private static Map<String, DigestAlgorithm> registerJAdESAlgorithms() {
            HashMap<String, DigestAlgorithm> map = new HashMap<String, DigestAlgorithm>();
            for (DigestAlgorithm digestAlgorithm : DigestAlgorithm.values()) {
                map.put(digestAlgorithm.jadesId, digestAlgorithm);
            }
            return map;
        }

        private static Map<String, DigestAlgorithm> registerJwsHttpHeaderAlgorithms() {
            HashMap<String, DigestAlgorithm> map = new HashMap<String, DigestAlgorithm>();
            for (DigestAlgorithm digestAlgorithm : DigestAlgorithm.values()) {
                map.put(digestAlgorithm.httpHeaderId, digestAlgorithm);
            }
            return map;
        }
    }
}

