/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import eu.europa.esig.dss.enumerations.CertificateQualifiedStatus;
import eu.europa.esig.dss.enumerations.CertificateType;
import eu.europa.esig.dss.enumerations.QSCDStatus;
import java.util.HashMap;
import java.util.Map;

public enum CertificateQualification {
    QCERT_FOR_ESIG_QSCD("QC for eSig with QSCD", "Qualified Certificate for Electronic Signatures with private key on QSCD", CertificateQualifiedStatus.QC, CertificateType.ESIGN, QSCDStatus.QSCD),
    QCERT_FOR_ESEAL_QSCD("QC for eSeal with QSCD", "Qualified Certificate for Electronic Seals with private key on QSCD", CertificateQualifiedStatus.QC, CertificateType.ESEAL, QSCDStatus.QSCD),
    QCERT_FOR_ESIG("QC for eSig", "Qualified Certificate for Electronic Signatures", CertificateQualifiedStatus.QC, CertificateType.ESIGN, QSCDStatus.NOT_QSCD),
    QCERT_FOR_ESEAL("QC for eSeal", "Qualified Certificate for Electronic Seals", CertificateQualifiedStatus.QC, CertificateType.ESEAL, QSCDStatus.NOT_QSCD),
    QCERT_FOR_WSA("QC for WSA", "Qualified Certificate for Web Site Authentications", CertificateQualifiedStatus.QC, CertificateType.WSA, QSCDStatus.NOT_QSCD),
    CERT_FOR_ESIG("Cert for eSig", "Certificate for Electronic Signatures", CertificateQualifiedStatus.NOT_QC, CertificateType.ESIGN, QSCDStatus.NOT_QSCD),
    CERT_FOR_ESEAL("Cert for eSeal", "Certificate for Electronic Seals", CertificateQualifiedStatus.NOT_QC, CertificateType.ESEAL, QSCDStatus.NOT_QSCD),
    CERT_FOR_WSA("Cert for WSA", "Certificate for Web Site Authentications", CertificateQualifiedStatus.NOT_QC, CertificateType.WSA, QSCDStatus.NOT_QSCD),
    NA("N/A", "Not applicable", CertificateQualifiedStatus.NOT_QC, CertificateType.UNKNOWN, QSCDStatus.NOT_QSCD);

    private final String readable;
    private final String label;
    private final CertificateQualifiedStatus qualifiedStatus;
    private final CertificateType type;
    private final QSCDStatus qscdStatus;

    private CertificateQualification(String readable, String label, CertificateQualifiedStatus qualifiedStatus, CertificateType type, QSCDStatus qscdStatus) {
        this.readable = readable;
        this.label = label;
        this.qualifiedStatus = qualifiedStatus;
        this.type = type;
        this.qscdStatus = qscdStatus;
    }

    public String getReadable() {
        return this.readable;
    }

    public String getLabel() {
        return this.label;
    }

    public static CertificateQualification forName(String value) {
        if (value != null && !value.isEmpty()) {
            return CertificateQualification.valueOf(value);
        }
        return null;
    }

    public static CertificateQualification fromReadable(String readable) {
        if (readable != null && !readable.isEmpty()) {
            return (CertificateQualification)((Object)Registry.QUALIFS_BY_READABLE.get(readable));
        }
        return null;
    }

    public boolean isQc() {
        return CertificateQualifiedStatus.isQC(this.qualifiedStatus);
    }

    public CertificateType getType() {
        return this.type;
    }

    public boolean isForEsig() {
        return CertificateType.ESIGN.equals((Object)this.type);
    }

    public boolean isForEseal() {
        return CertificateType.ESEAL.equals((Object)this.type);
    }

    public boolean isQscd() {
        return QSCDStatus.isQSCD(this.qscdStatus);
    }

    private static class Registry {
        private static final Map<String, CertificateQualification> QUALIFS_BY_READABLE = Registry.registerByReadable();

        private Registry() {
        }

        private static Map<String, CertificateQualification> registerByReadable() {
            HashMap<String, CertificateQualification> map = new HashMap<String, CertificateQualification>();
            for (CertificateQualification qualification : CertificateQualification.values()) {
                map.put(qualification.readable, qualification);
            }
            return map;
        }
    }
}

