/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import eu.europa.esig.dss.enumerations.MimeType;

public enum MimeTypeEnum implements MimeType
{
    BINARY("application/octet-stream", new String[0]),
    TEXT("text/plain", "txt"),
    XML("text/xml", "xml"),
    HTML("text/html", "html"),
    PDF("application/pdf", "pdf"),
    JSON("application/json", "json"),
    JOSE("application/jose", "jose"),
    JOSE_JSON("application/jose+json", "json"),
    PKCS7("application/pkcs7-signature", "pkcs7", "p7m", "p7s"),
    TST("application/vnd.etsi.timestamp-token", "tst"),
    CRL("application/pkix-crl", "crl"),
    CER("application/pkix-cert", "cer", "crt"),
    ZIP("application/zip", "zip"),
    ASICS("application/vnd.etsi.asic-s+zip", "scs", "asics"),
    ASICE("application/vnd.etsi.asic-e+zip", "sce", "asice", "bdoc"),
    ODT("application/vnd.oasis.opendocument.text", "odt"),
    ODS("application/vnd.oasis.opendocument.spreadsheet", "ods"),
    ODP("application/vnd.oasis.opendocument.presentation", "odp"),
    ODG("application/vnd.oasis.opendocument.graphics", "odg"),
    PNG("image/png", "png"),
    JPEG("image/jpeg", "jpg", "jpeg"),
    SVG("image/svg+xml", "svg");

    final String mimeTypeString;
    final String[] extensions;

    private MimeTypeEnum(String mimeTypeString, String ... extensions) {
        this.extensions = extensions;
        this.mimeTypeString = mimeTypeString;
    }

    @Override
    public String getMimeTypeString() {
        return this.mimeTypeString;
    }

    @Override
    public String getExtension() {
        if (this.extensions != null && this.extensions.length > 0) {
            return this.extensions[0];
        }
        return null;
    }
}

