/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import eu.europa.esig.dss.enumerations.OidDescription;
import eu.europa.esig.dss.enumerations.QCTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface QCType
extends OidDescription {
    public static final Logger LOG = LoggerFactory.getLogger(QCType.class);
    public static final String UNKNOWN_TYPE = "type-unknown";

    public static QCType fromOid(final String oid) {
        for (QCTypeEnum type : QCTypeEnum.values()) {
            if (!type.getOid().equals(oid)) continue;
            return type;
        }
        LOG.debug("Not supported QcType : '{}'", (Object)oid);
        return new QCType(){
            private static final long serialVersionUID = -8051274586981146105L;

            @Override
            public String getDescription() {
                return QCType.UNKNOWN_TYPE;
            }

            @Override
            public String getOid() {
                return oid;
            }
        };
    }
}

