/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jaxb.common;

import eu.europa.esig.dss.alert.Alert;
import eu.europa.esig.dss.jaxb.common.AbstractConfigurator;
import eu.europa.esig.dss.jaxb.common.DSSErrorHandler;
import eu.europa.esig.dss.jaxb.common.DSSErrorHandlerAlert;
import eu.europa.esig.dss.jaxb.common.exception.SecurityConfigurationException;
import java.util.Objects;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;

public class ValidatorConfigurator
extends AbstractConfigurator<Validator> {
    private Alert<DSSErrorHandler> errorHandlerAlert = new DSSErrorHandlerAlert();

    protected ValidatorConfigurator() {
        this.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        this.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
    }

    public static ValidatorConfigurator getSecureValidatorConfigurator() {
        return new ValidatorConfigurator();
    }

    public void configure(Validator validator) {
        Objects.requireNonNull(validator, "Validator must be provided");
        this.setSecurityFeatures(validator);
        this.setSecurityAttributes(validator);
        this.setErrorHandler(validator);
    }

    public ValidatorConfigurator enableFeature(String feature) {
        return (ValidatorConfigurator)super.enableFeature(feature);
    }

    public ValidatorConfigurator disableFeature(String feature) {
        return (ValidatorConfigurator)super.disableFeature(feature);
    }

    public void setErrorHandlerAlert(Alert<DSSErrorHandler> errorHandlerAlert) {
        Objects.requireNonNull(errorHandlerAlert, "errorHandlerAlert cannot be null!");
        this.errorHandlerAlert = errorHandlerAlert;
    }

    public ValidatorConfigurator setAttribute(String attribute, Object value) {
        return (ValidatorConfigurator)super.setAttribute(attribute, value);
    }

    public ValidatorConfigurator removeAttribute(String attribute) {
        return (ValidatorConfigurator)super.removeAttribute(attribute);
    }

    @Override
    protected void setSecurityFeature(Validator validator, String feature, Boolean value) throws SecurityConfigurationException {
        try {
            validator.setFeature(feature, value);
        }
        catch (Exception e) {
            throw new SecurityConfigurationException(e);
        }
    }

    @Override
    protected void setSecurityAttribute(Validator validator, String attribute, Object value) throws SecurityConfigurationException {
        try {
            validator.setProperty(attribute, value);
        }
        catch (Exception e) {
            throw new SecurityConfigurationException(e);
        }
    }

    protected void setErrorHandler(Validator validator) {
        validator.setErrorHandler(new DSSErrorHandler());
    }

    public void postProcess(Validator validator) {
        ErrorHandler errorHandler = validator.getErrorHandler();
        if (errorHandler instanceof DSSErrorHandler) {
            this.errorHandlerAlert.alert((Object)((DSSErrorHandler)errorHandler));
        }
    }
}

