/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jaxb.common;

import eu.europa.esig.dss.alert.ExceptionOnStatusAlert;
import eu.europa.esig.dss.alert.StatusAlert;
import eu.europa.esig.dss.alert.status.Status;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFactoryBuilder<F> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFactoryBuilder.class);
    private Map<String, Boolean> features = new HashMap<String, Boolean>();
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private StatusAlert securityExceptionAlert = new ExceptionOnStatusAlert();

    public void setSecurityExceptionAlert(StatusAlert securityExceptionAlert) {
        Objects.requireNonNull(securityExceptionAlert);
        this.securityExceptionAlert = securityExceptionAlert;
    }

    public AbstractFactoryBuilder<F> enableFeature(String feature) {
        this.setFeature(feature, true);
        return this;
    }

    public AbstractFactoryBuilder<F> disableFeature(String feature) {
        this.setFeature(feature, false);
        return this;
    }

    private void setFeature(String feature, boolean value) {
        Objects.requireNonNull(feature, "The feature constraint cannot be null!");
        if (this.features.containsKey(feature) && this.features.get(feature) != value) {
            LOG.warn("SECURITY : feature with the name [{}] changed from [{}] to [{}]", new Object[]{feature, this.features.get(feature), value});
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("The feature {} = {} has been added to the configuration", (Object)feature, (Object)value);
        }
        this.features.put(feature, value);
    }

    public AbstractFactoryBuilder<F> setAttribute(String attribute, Object value) {
        Objects.requireNonNull(attribute, "The attribute constraint cannot be null!");
        if (this.attributes.containsKey(attribute) && this.attributes.get(attribute).equals(value)) {
            LOG.warn("SECURITY : attribute with the name [{}] changed from [{}] to [{}]", new Object[]{attribute, this.attributes.get(attribute), value});
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("The attribute {} = {} has been added to the configuration", (Object)attribute, value);
        }
        this.attributes.put(attribute, value);
        return this;
    }

    public AbstractFactoryBuilder<F> removeAttribute(String attribute) {
        Objects.requireNonNull(attribute, "The attribute constraint cannot be null!");
        if (this.attributes.containsKey(attribute)) {
            this.attributes.remove(attribute);
            LOG.warn("SECURITY : the attribute with name [{}] has been disabled", (Object)attribute);
        }
        return this;
    }

    protected void setSecurityFeatures(F factory) {
        ArrayList<String> messages = new ArrayList<String>();
        for (Map.Entry<String, Boolean> entry : this.features.entrySet()) {
            try {
                this.setSecurityFeature(factory, entry.getKey(), entry.getValue());
            }
            catch (Exception e) {
                String message = String.format("Feature '%s' = '%s'. Cause : %s", entry.getKey(), entry.getValue(), e.getMessage());
                messages.add(message);
            }
        }
        if (!messages.isEmpty()) {
            Status status = new Status("SECURITY : unable to set feature(s)", messages);
            this.securityExceptionAlert.alert((Object)status);
        }
    }

    protected abstract void setSecurityFeature(F var1, String var2, Boolean var3) throws Exception;

    protected void setSecurityAttributes(F factory) {
        ArrayList<String> messages = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            try {
                this.setSecurityAttribute(factory, entry.getKey(), entry.getValue());
            }
            catch (Exception e) {
                String message = String.format("Attribute '%s' = '%s'. Cause : %s", entry.getKey(), entry.getValue(), e.getMessage());
                messages.add(message);
            }
        }
        if (!messages.isEmpty()) {
            Status status = new Status("SECURITY : unable to set attribute(s)", messages);
            this.securityExceptionAlert.alert((Object)status);
        }
    }

    protected abstract void setSecurityAttribute(F var1, String var2, Object var3) throws Exception;
}

