/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer;

import eu.europa.esig.dss.pades.DSSFont;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.JavaFontMetrics;
import eu.europa.esig.dss.pdf.visible.CommonDrawerUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageTextWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ImageTextWriter.class);

    private ImageTextWriter() {
    }

    public static BufferedImage createTextImage(SignatureImageParameters imageParameters) {
        SignatureImageTextParameters textParameters = imageParameters.getTextParameters();
        DSSFont dssFont = textParameters.getFont();
        float fontSize = CommonDrawerUtils.computeProperSize((float)dssFont.getSize(), (float)imageParameters.getDpi().intValue());
        Font javaFont = dssFont.getJavaFont();
        Font properFont = javaFont.deriveFont(fontSize);
        FontMetrics fontMetrics = ImageTextWriter.getFontMetrics(properFont);
        JavaFontMetrics javaFontMetrics = new JavaFontMetrics(fontMetrics);
        Dimension dimension = javaFontMetrics.computeDimension(textParameters.getText(), fontSize, textParameters.getPadding());
        return ImageTextWriter.createTextImage(textParameters, properFont, dimension);
    }

    private static FontMetrics getFontMetrics(Font font) {
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics g = img.getGraphics();
        g.setFont(font);
        FontMetrics fontMetrics = g.getFontMetrics(font);
        g.dispose();
        return fontMetrics;
    }

    private static BufferedImage createTextImage(SignatureImageTextParameters textParameters, Font font, Dimension dimension) {
        int imageType;
        String[] lines = textParameters.getText().split("\n");
        if (ImageTextWriter.isTransparent(textParameters.getTextColor(), textParameters.getBackgroundColor())) {
            LOG.warn("Transparency detected and enabled (Be aware: not valid with PDF/A !)");
            imageType = 2;
        } else {
            imageType = 1;
        }
        BufferedImage img = new BufferedImage(dimension.width, dimension.height, imageType);
        Graphics2D g = img.createGraphics();
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics(font);
        CommonDrawerUtils.initRendering((Graphics2D)g);
        if (textParameters.getBackgroundColor() == null) {
            g.setColor(Color.WHITE);
        } else {
            g.setColor(textParameters.getBackgroundColor());
        }
        g.fillRect(0, 0, dimension.width, dimension.height);
        if (textParameters.getTextColor() == null) {
            g.setPaint(Color.BLACK);
        } else {
            g.setPaint(textParameters.getTextColor());
        }
        int lineHeight = fm.getHeight();
        float y = (float)fm.getMaxAscent() + textParameters.getPadding();
        for (String line : lines) {
            float x = textParameters.getPadding();
            if (textParameters.getSignerTextHorizontalAlignment() != null) {
                switch (textParameters.getSignerTextHorizontalAlignment()) {
                    case RIGHT: {
                        x = (float)(img.getWidth() - fm.stringWidth(line)) - x;
                        break;
                    }
                    case CENTER: {
                        x = (float)(img.getWidth() - fm.stringWidth(line)) / 2.0f;
                        break;
                    }
                }
            }
            g.drawString(line, x, y);
            y += (float)lineHeight;
        }
        g.dispose();
        return img;
    }

    private static boolean isTransparent(Color ... colors) {
        if (colors != null) {
            for (Color color : colors) {
                int alpha = color.getAlpha();
                if (alpha >= 255) continue;
                return true;
            }
        }
        return false;
    }
}

