/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible.nativedrawer;

import eu.europa.esig.dss.enumerations.SignerTextHorizontalAlignment;
import eu.europa.esig.dss.enumerations.SignerTextVerticalAlignment;
import eu.europa.esig.dss.enumerations.VisualSignatureAlignmentHorizontal;
import eu.europa.esig.dss.enumerations.VisualSignatureAlignmentVertical;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.pdf.pdfbox.visible.ImageRotationUtils;
import eu.europa.esig.dss.pdf.pdfbox.visible.nativedrawer.PdfBoxFontMetrics;
import eu.europa.esig.dss.pdf.pdfbox.visible.nativedrawer.SignatureFieldDimensionAndPosition;
import eu.europa.esig.dss.pdf.visible.CommonDrawerUtils;
import eu.europa.esig.dss.pdf.visible.ImageAndResolution;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import eu.europa.esig.dss.utils.Utils;
import java.awt.Dimension;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureFieldDimensionAndPositionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureFieldDimensionAndPositionBuilder.class);
    private SignatureFieldDimensionAndPosition dimensionAndPosition;
    private final SignatureImageParameters imageParameters;
    private final PDPage page;
    private final PDRectangle pageMediaBox;
    private final PDFont pdFont;
    private static final String NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE = "not supported vertical alignment: ";
    private static final String NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE = "not supported horizontal alignment: ";

    public SignatureFieldDimensionAndPositionBuilder(SignatureImageParameters imageParameters, PDPage page, PDFont pdFont) {
        this.imageParameters = imageParameters;
        this.page = page;
        this.pageMediaBox = new PDRectangle(page.getMediaBox().getWidth(), page.getMediaBox().getHeight());
        this.pdFont = pdFont;
    }

    public SignatureFieldDimensionAndPosition build() throws IOException {
        this.dimensionAndPosition = new SignatureFieldDimensionAndPosition();
        this.initDpi();
        this.assignImageBoxDimension();
        this.alignHorizontally();
        this.alignVertically();
        this.rotateSignatureField();
        return this.dimensionAndPosition;
    }

    private void initDpi() throws IOException {
        if (this.imageParameters.getImage() != null) {
            ImageAndResolution imageAndResolution;
            try {
                imageAndResolution = ImageUtils.readDisplayMetadata((DSSDocument)this.imageParameters.getImage());
            }
            catch (Exception e) {
                LOG.warn("Cannot access the image metadata : {}. Returns default info.", (Object)e.getMessage());
                imageAndResolution = new ImageAndResolution(this.imageParameters.getImage(), this.imageParameters.getDpi().intValue(), this.imageParameters.getDpi().intValue());
            }
            this.dimensionAndPosition.setImageAndResolution(imageAndResolution);
            this.dimensionAndPosition.setImageDpi(this.imageParameters.getDpi());
        }
    }

    private void assignImageBoxDimension() throws IOException {
        int rotation;
        Dimension imageAndDimension = ImageUtils.getImageDimension((SignatureImageParameters)this.imageParameters);
        double imageWidth = imageAndDimension.getWidth();
        double imageHeight = imageAndDimension.getHeight();
        if (this.imageParameters.getWidth() == 0) {
            imageWidth *= (double)CommonDrawerUtils.getPageScaleFactor((Integer)this.dimensionAndPosition.getxDpi());
        }
        if (this.imageParameters.getHeight() == 0) {
            imageHeight *= (double)CommonDrawerUtils.getPageScaleFactor((Integer)this.dimensionAndPosition.getyDpi());
        }
        double width = imageWidth;
        double height = imageHeight;
        SignatureImageTextParameters textParameters = this.imageParameters.getTextParameters();
        if (textParameters != null && Utils.isStringNotEmpty((String)textParameters.getText())) {
            imageWidth = this.toDpiTextPoint(imageWidth, this.dimensionAndPosition.getxDpi());
            imageHeight = this.toDpiTextPoint(imageHeight, this.dimensionAndPosition.getyDpi());
            width = imageWidth;
            height = imageHeight;
            Dimension textBox = this.computeTextDimension(textParameters);
            float textWidth = (float)textBox.getWidth() * CommonDrawerUtils.getTextScaleFactor((Integer)this.imageParameters.getDpi());
            float textHeight = (float)textBox.getHeight() * CommonDrawerUtils.getTextScaleFactor((Integer)this.imageParameters.getDpi());
            if (this.imageParameters.getImage() != null) {
                textWidth /= CommonDrawerUtils.getTextScaleFactor((Integer)this.dimensionAndPosition.getxDpi());
                textHeight /= CommonDrawerUtils.getTextScaleFactor((Integer)this.dimensionAndPosition.getyDpi());
            }
            switch (this.imageParameters.getTextParameters().getSignerTextPosition()) {
                case LEFT: {
                    if (this.imageParameters.getWidth() == 0) {
                        width += this.imageParameters.getImage() != null || width == 0.0 ? (double)textWidth : 0.0;
                    } else {
                        imageWidth -= this.imageParameters.getImage() != null || width == 0.0 ? (double)textWidth : 0.0;
                    }
                    if (this.imageParameters.getHeight() == 0) {
                        height = Math.max(height, (double)textHeight);
                    }
                    this.dimensionAndPosition.setImageX((float)(width - imageWidth));
                    this.textImageVerticalAlignment(height, imageHeight, textHeight);
                    break;
                }
                case RIGHT: {
                    if (this.imageParameters.getWidth() == 0) {
                        width += this.imageParameters.getImage() != null || width == 0.0 ? (double)textWidth : 0.0;
                    } else {
                        imageWidth -= this.imageParameters.getImage() != null || width == 0.0 ? (double)textWidth : 0.0;
                    }
                    if (this.imageParameters.getHeight() == 0) {
                        height = Math.max(height, (double)textHeight);
                    }
                    this.dimensionAndPosition.setTextX(this.toDpiPagePoint(imageWidth, this.dimensionAndPosition.getxDpi()));
                    this.textImageVerticalAlignment(height, imageHeight, textHeight);
                    break;
                }
                case TOP: {
                    if (this.imageParameters.getWidth() == 0) {
                        width = Math.max(width, (double)textWidth);
                    }
                    if (this.imageParameters.getHeight() == 0) {
                        height += this.imageParameters.getImage() != null || height == 0.0 ? (double)textHeight : 0.0;
                    } else {
                        imageHeight -= this.imageParameters.getImage() != null || height == 0.0 ? (double)textHeight : 0.0;
                    }
                    this.dimensionAndPosition.setTextY(this.toDpiPagePoint(imageHeight, this.dimensionAndPosition.getyDpi()));
                    this.textImageHorizontalAlignment(width, imageWidth, textWidth);
                    break;
                }
                case BOTTOM: {
                    if (this.imageParameters.getWidth() == 0) {
                        width = Math.max(width, (double)textWidth);
                    }
                    if (this.imageParameters.getHeight() == 0) {
                        height += this.imageParameters.getImage() != null || height == 0.0 ? (double)textHeight : 0.0;
                    } else {
                        imageHeight -= this.imageParameters.getImage() != null || height == 0.0 ? (double)textHeight : 0.0;
                    }
                    this.dimensionAndPosition.setImageY((float)(height - imageHeight));
                    this.textImageHorizontalAlignment(width, imageWidth, textWidth);
                    break;
                }
            }
            this.dimensionAndPosition.setTextWidth(this.toDpiPagePoint(textWidth, this.dimensionAndPosition.getxDpi()));
            this.dimensionAndPosition.setTextHeight(this.toDpiPagePoint(textHeight, this.dimensionAndPosition.getyDpi()));
            this.dimensionAndPosition.paddingShift(textParameters.getPadding());
            width = this.toDpiPagePoint(width, this.dimensionAndPosition.getxDpi());
            height = this.toDpiPagePoint(height, this.dimensionAndPosition.getyDpi());
        }
        if (ImageRotationUtils.isSwapOfDimensionsRequired(rotation = ImageRotationUtils.getRotation(this.imageParameters.getRotation(), this.page))) {
            double temp = width;
            width = height;
            height = temp;
            this.pageMediaBox.setUpperRightX(this.page.getMediaBox().getHeight());
            this.pageMediaBox.setUpperRightY(this.page.getMediaBox().getWidth());
        }
        this.dimensionAndPosition.setGlobalRotation(rotation);
        this.dimensionAndPosition.setImageWidth((float)imageWidth);
        this.dimensionAndPosition.setImageHeight((float)imageHeight);
        this.dimensionAndPosition.setBoxWidth((float)width);
        this.dimensionAndPosition.setBoxHeight((float)height);
    }

    private Dimension computeTextDimension(SignatureImageTextParameters textParameters) throws IOException {
        float properSize = CommonDrawerUtils.computeProperSize((float)textParameters.getFont().getSize(), (float)this.imageParameters.getDpi().intValue());
        PdfBoxFontMetrics pdfBoxFontMetrics = new PdfBoxFontMetrics(this.pdFont);
        return pdfBoxFontMetrics.computeDimension(textParameters.getText(), properSize *= ImageUtils.getScaleFactor((int)this.imageParameters.getZoom()), textParameters.getPadding());
    }

    private void textImageVerticalAlignment(double height, double imageHeight, float textHeight) {
        SignerTextVerticalAlignment verticalAlignment = this.imageParameters.getTextParameters().getSignerTextVerticalAlignment();
        switch (verticalAlignment) {
            case TOP: {
                this.dimensionAndPosition.setTextY(this.toDpiPagePoint(height - (double)textHeight, this.dimensionAndPosition.getyDpi()));
                this.dimensionAndPosition.setImageY((float)(height - imageHeight));
                break;
            }
            case BOTTOM: {
                this.dimensionAndPosition.setTextY(0.0f);
                this.dimensionAndPosition.setImageY(0.0f);
                break;
            }
            case MIDDLE: {
                this.dimensionAndPosition.setTextY(this.toDpiPagePoint((height - (double)textHeight) / 2.0, this.dimensionAndPosition.getyDpi()));
                this.dimensionAndPosition.setImageY((float)(height - imageHeight) / 2.0f);
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE + verticalAlignment);
            }
        }
    }

    private void textImageHorizontalAlignment(double width, double imageWidth, float textWidth) {
        SignerTextHorizontalAlignment horizontalAlignment = this.imageParameters.getTextParameters().getSignerTextHorizontalAlignment();
        switch (horizontalAlignment) {
            case LEFT: {
                this.dimensionAndPosition.setTextX(0.0f);
                this.dimensionAndPosition.setImageX(0.0f);
                break;
            }
            case RIGHT: {
                this.dimensionAndPosition.setTextX(this.toDpiPagePoint(width - (double)textWidth, this.dimensionAndPosition.getxDpi()));
                this.dimensionAndPosition.setImageX((float)(width - imageWidth));
                break;
            }
            case CENTER: {
                this.dimensionAndPosition.setTextX(this.toDpiPagePoint((width - (double)textWidth) / 2.0, this.dimensionAndPosition.getxDpi()));
                this.dimensionAndPosition.setImageX((float)(width - imageWidth) / 2.0f);
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE + horizontalAlignment);
            }
        }
    }

    private void alignHorizontally() {
        float boxX;
        VisualSignatureAlignmentHorizontal alignmentHorizontal = this.imageParameters.getVisualSignatureAlignmentHorizontal();
        float boxWidth = this.dimensionAndPosition.getBoxWidth();
        if (ImageRotationUtils.isSwapOfDimensionsRequired(this.dimensionAndPosition.getGlobalRotation())) {
            boxWidth = this.dimensionAndPosition.getBoxHeight();
        }
        switch (alignmentHorizontal) {
            case LEFT: 
            case NONE: {
                boxX = this.imageParameters.getxAxis();
                break;
            }
            case CENTER: {
                boxX = (this.pageMediaBox.getWidth() - boxWidth) / 2.0f;
                break;
            }
            case RIGHT: {
                boxX = this.pageMediaBox.getWidth() - boxWidth - this.imageParameters.getxAxis();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE + alignmentHorizontal);
            }
        }
        this.dimensionAndPosition.setBoxX(boxX);
    }

    private void alignVertically() {
        float boxY;
        VisualSignatureAlignmentVertical alignmentVertical = this.imageParameters.getVisualSignatureAlignmentVertical();
        float boxHeight = this.dimensionAndPosition.getBoxHeight();
        if (ImageRotationUtils.isSwapOfDimensionsRequired(this.dimensionAndPosition.getGlobalRotation())) {
            boxHeight = this.dimensionAndPosition.getBoxWidth();
        }
        switch (alignmentVertical) {
            case TOP: 
            case NONE: {
                boxY = this.imageParameters.getyAxis();
                break;
            }
            case MIDDLE: {
                boxY = (this.pageMediaBox.getHeight() - boxHeight) / 2.0f;
                break;
            }
            case BOTTOM: {
                boxY = this.pageMediaBox.getHeight() - boxHeight - this.imageParameters.getyAxis();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE + alignmentVertical);
            }
        }
        this.dimensionAndPosition.setBoxY(boxY);
    }

    private void rotateSignatureField() {
        switch (this.dimensionAndPosition.getGlobalRotation()) {
            case 90: {
                float boxX = this.dimensionAndPosition.getBoxX();
                this.dimensionAndPosition.setBoxX(this.pageMediaBox.getHeight() - this.dimensionAndPosition.getBoxY() - this.dimensionAndPosition.getBoxWidth());
                this.dimensionAndPosition.setBoxY(boxX);
                break;
            }
            case 180: {
                this.dimensionAndPosition.setBoxX(this.pageMediaBox.getWidth() - this.dimensionAndPosition.getBoxX() - this.dimensionAndPosition.getBoxWidth());
                this.dimensionAndPosition.setBoxY(this.pageMediaBox.getHeight() - this.dimensionAndPosition.getBoxY() - this.dimensionAndPosition.getBoxHeight());
                break;
            }
            case 270: {
                float boxX = this.dimensionAndPosition.getBoxX();
                this.dimensionAndPosition.setBoxX(this.dimensionAndPosition.getBoxY());
                this.dimensionAndPosition.setBoxY(this.pageMediaBox.getWidth() - boxX - this.dimensionAndPosition.getBoxHeight());
                break;
            }
            case 360: {
                break;
            }
            default: {
                throw new IllegalStateException("rotation angle must be 90, 180, 270 or 360 (0)");
            }
        }
    }

    private float toDpiPagePoint(double x, Integer dpi) {
        return CommonDrawerUtils.toDpiAxisPoint((float)((float)x), (float)CommonDrawerUtils.getDpi((Integer)dpi));
    }

    private float toDpiTextPoint(double x, Integer dpi) {
        return CommonDrawerUtils.computeProperSize((float)((float)x), (float)CommonDrawerUtils.getDpi((Integer)dpi));
    }
}

