/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.pades.CertificationPermission;
import eu.europa.esig.dss.pades.PAdESCommonParameters;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.exception.ProtectedDocumentException;
import eu.europa.esig.dss.pdf.AbstractPDFSignatureService;
import eu.europa.esig.dss.pdf.DSSDictionaryCallback;
import eu.europa.esig.dss.pdf.PDFServiceMode;
import eu.europa.esig.dss.pdf.PdfDocumentReader;
import eu.europa.esig.dss.pdf.encryption.DSSSecureRandomProvider;
import eu.europa.esig.dss.pdf.encryption.SecureRandomProvider;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxDocumentReader;
import eu.europa.esig.dss.pdf.pdfbox.visible.PdfBoxSignatureDrawer;
import eu.europa.esig.dss.pdf.pdfbox.visible.PdfBoxSignatureDrawerFactory;
import eu.europa.esig.dss.pdf.visible.SignatureDrawerFactory;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfBoxSignatureService
extends AbstractPDFSignatureService {
    private static final Logger LOG = LoggerFactory.getLogger(PdfBoxSignatureService.class);
    private SecureRandomProvider secureRandomProvider;

    public void setSecureRandomProvider(SecureRandomProvider secureRandomProvider) {
        Objects.requireNonNull(secureRandomProvider, "SecureRandomProvider cannot be null");
        this.secureRandomProvider = secureRandomProvider;
    }

    public PdfBoxSignatureService(PDFServiceMode serviceMode, PdfBoxSignatureDrawerFactory signatureDrawerFactory) {
        super(serviceMode, (SignatureDrawerFactory)signatureDrawerFactory);
    }

    protected void checkDocumentPermissions(DSSDocument document, String pwd) {
        try (InputStream is = document.openStream();
             PDDocument pdDocument = PDDocument.load((InputStream)is, (String)pwd);){
            AccessPermission accessPermission = pdDocument.getCurrentAccessPermission();
            if (accessPermission.isReadOnly()) {
                throw new ProtectedDocumentException("The document cannot be modified (read-only)");
            }
            if (!accessPermission.canModify()) {
                throw new ProtectedDocumentException("Cannot modify the document");
            }
            if (!accessPermission.canModifyAnnotations()) {
                throw new ProtectedDocumentException("Cannot modify the annotation");
            }
            if (!accessPermission.canFillInForm()) {
                throw new ProtectedDocumentException("Cannot fill in form");
            }
        }
        catch (InvalidPasswordException e) {
            throw new eu.europa.esig.dss.pades.exception.InvalidPasswordException("The document is encrypted (password is invalid)");
        }
        catch (DSSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSSException("Unable to check document", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public byte[] digest(DSSDocument toSignDocument, PAdESCommonParameters parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public DSSDocument sign(DSSDocument toSignDocument, byte[] signatureValue, PAdESCommonParameters parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] signDocumentAndReturnDigest(PAdESCommonParameters parameters, final byte[] signatureBytes, OutputStream fileOutputStream, PDDocument pdDocument) {
        byte[] byArray;
        final MessageDigest digest = DSSUtils.getMessageDigest((DigestAlgorithm)parameters.getDigestAlgorithm());
        SignatureInterface signatureInterface = new SignatureInterface(){

            public byte[] sign(InputStream content) throws IOException {
                int count;
                byte[] b = new byte[4096];
                while ((count = content.read(b)) > 0) {
                    digest.update(b, 0, count);
                }
                return signatureBytes;
            }
        };
        SignatureFieldParameters fieldParameters = parameters.getImageParameters().getFieldParameters();
        PDSignature pdSignature = this.createSignatureDictionary(pdDocument, parameters);
        PDSignatureField pdSignatureField = this.findExistingSignatureField(pdDocument, fieldParameters);
        if (pdSignatureField != null) {
            this.setSignatureToField(pdSignatureField, pdSignature);
        }
        SignatureOptions options = new SignatureOptions();
        try {
            options.setPreferredSignatureSize(parameters.getContentSize());
            SignatureImageParameters imageParameters = parameters.getImageParameters();
            if (!imageParameters.isEmpty()) {
                PdfBoxSignatureDrawer signatureDrawer = (PdfBoxSignatureDrawer)this.loadSignatureDrawer(imageParameters);
                signatureDrawer.init(imageParameters, pdDocument, options);
                if (pdSignatureField == null) {
                    this.checkVisibleSignatureFieldBoxPosition(signatureDrawer, new PdfBoxDocumentReader(pdDocument), fieldParameters);
                }
                signatureDrawer.draw();
            }
            pdDocument.addSignature(pdSignature, signatureInterface, options);
            if (pdDocument.getDocumentId() == null) {
                pdDocument.setDocumentId(Long.valueOf(parameters.getSigningDate().getTime()));
            }
            this.checkEncryptedAndSaveIncrementally(pdDocument, fileOutputStream, parameters);
            byArray = digest.digest();
        }
        catch (Throwable throwable) {
            try {
                try {
                    options.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException((Throwable)e);
            }
        }
        options.close();
        return byArray;
    }

    private PDSignatureField findExistingSignatureField(PDDocument pdDocument, SignatureFieldParameters fieldParameters) {
        String targetFieldId = fieldParameters.getFieldId();
        if (!this.isDocumentTimestampLayer() && Utils.isStringNotEmpty((String)targetFieldId)) {
            PDSignatureField signatureField;
            PDAcroForm acroForm = pdDocument.getDocumentCatalog().getAcroForm();
            if (acroForm != null && (signatureField = (PDSignatureField)acroForm.getField(targetFieldId)) != null) {
                PDSignature signature = signatureField.getSignature();
                if (signature != null) {
                    throw new DSSException("The signature field '" + targetFieldId + "' can not be signed since its already signed.");
                }
                return signatureField;
            }
            throw new DSSException("The signature field '" + targetFieldId + "' does not exist.");
        }
        return null;
    }

    protected PDSignature createSignatureDictionary(PDDocument pdDocument, PAdESCommonParameters parameters) {
        PDSignature signature = new PDSignature();
        COSName currentType = COSName.getPDFName((String)this.getType());
        signature.setType(currentType);
        if (Utils.isStringNotEmpty((String)parameters.getFilter())) {
            signature.setFilter(COSName.getPDFName((String)parameters.getFilter()));
        }
        if (Utils.isStringNotEmpty((String)parameters.getSubFilter())) {
            signature.setSubFilter(COSName.getPDFName((String)parameters.getSubFilter()));
        }
        if (COSName.SIG.equals((Object)currentType)) {
            CertificationPermission permission;
            PAdESSignatureParameters signatureParameters = (PAdESSignatureParameters)parameters;
            if (Utils.isStringNotEmpty((String)signatureParameters.getSignerName())) {
                signature.setName(signatureParameters.getSignerName());
            }
            if (Utils.isStringNotEmpty((String)signatureParameters.getContactInfo())) {
                signature.setContactInfo(signatureParameters.getContactInfo());
            }
            if (Utils.isStringNotEmpty((String)signatureParameters.getLocation())) {
                signature.setLocation(signatureParameters.getLocation());
            }
            if (Utils.isStringNotEmpty((String)signatureParameters.getReason())) {
                signature.setReason(signatureParameters.getReason());
            }
            if ((permission = signatureParameters.getPermission()) != null && !this.containsFilledSignature(pdDocument)) {
                this.setMDPPermission(pdDocument, signature, permission.getCode());
            }
            Calendar cal = Calendar.getInstance();
            Date signingDate = parameters.getSigningDate();
            cal.setTime(signingDate);
            signature.setSignDate(cal);
        }
        return signature;
    }

    private void setSignatureToField(PDSignatureField pdSignatureField, PDSignature pdSignature) {
        pdSignatureField.getCOSObject().setItem(COSName.V, (COSObjectable)pdSignature);
    }

    private boolean containsFilledSignature(PDDocument pdDocument) {
        try {
            List signatures = pdDocument.getSignatureDictionaries();
            for (PDSignature pdSignature : signatures) {
                if (!pdSignature.getCOSObject().containsKey(COSName.BYTERANGE)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            LOG.warn("Cannot read the existing signature(s)", (Throwable)e);
            return false;
        }
    }

    public void setMDPPermission(PDDocument doc, PDSignature signature, int accessPermissions) {
        COSDictionary sigDict = signature.getCOSObject();
        COSDictionary transformParameters = new COSDictionary();
        transformParameters.setItem(COSName.TYPE, (COSBase)COSName.getPDFName((String)"TransformParams"));
        transformParameters.setInt(COSName.P, accessPermissions);
        transformParameters.setName(COSName.V, "1.2");
        transformParameters.setNeedToBeUpdated(true);
        COSDictionary referenceDict = new COSDictionary();
        referenceDict.setItem(COSName.TYPE, (COSBase)COSName.getPDFName((String)"SigRef"));
        referenceDict.setItem("TransformMethod", (COSBase)COSName.DOCMDP);
        referenceDict.setItem("TransformParams", (COSBase)transformParameters);
        referenceDict.setNeedToBeUpdated(true);
        COSArray referenceArray = new COSArray();
        referenceArray.add((COSBase)referenceDict);
        sigDict.setItem("Reference", (COSBase)referenceArray);
        referenceArray.setNeedToBeUpdated(true);
        COSDictionary catalogDict = doc.getDocumentCatalog().getCOSObject();
        COSDictionary permsDict = new COSDictionary();
        catalogDict.setItem(COSName.PERMS, (COSBase)permsDict);
        permsDict.setItem(COSName.DOCMDP, (COSObjectable)signature);
        catalogDict.setNeedToBeUpdated(true);
        permsDict.setNeedToBeUpdated(true);
    }

    public void checkEncryptedAndSaveIncrementally(PDDocument pdDocument, OutputStream outputStream, PAdESCommonParameters parameters) {
        try {
            if (pdDocument.isEncrypted()) {
                SecureRandom secureRandom = this.getSecureRandomProvider(parameters).getSecureRandom();
                pdDocument.getEncryption().getSecurityHandler().setCustomSecureRandom(secureRandom);
            }
            this.saveDocumentIncrementally(pdDocument, outputStream);
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    public void saveDocumentIncrementally(PDDocument pdDocument, OutputStream outputStream) {
        try {
            pdDocument.saveIncremental(outputStream);
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to save a document. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    private SecureRandomProvider getSecureRandomProvider(PAdESCommonParameters parameters) {
        if (this.secureRandomProvider == null) {
            this.secureRandomProvider = new DSSSecureRandomProvider(parameters);
        }
        return this.secureRandomProvider;
    }

    /*
     * Exception decompiling
     */
    public DSSDocument addDssDictionary(DSSDocument document, List<DSSDictionaryCallback> callbacks, String pwd) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private COSDictionary buildDSSDictionary(PDDocument pdDocument, List<DSSDictionaryCallback> callbacks) throws IOException {
        COSDictionary dss = new COSDictionary();
        Map knownObjects = this.buildKnownObjects(callbacks);
        HashMap<String, COSStream> streams = new HashMap<String, COSStream>();
        HashSet allCrls = new HashSet();
        HashSet allOcsps = new HashSet();
        HashSet allCertificates = new HashSet();
        COSDictionary vriDictionary = new COSDictionary();
        for (DSSDictionaryCallback callback : callbacks) {
            List currentCrls;
            List currentOcsps;
            COSDictionary sigVriDictionary = new COSDictionary();
            sigVriDictionary.setDirect(true);
            Set currentCerts = callback.getCertificates();
            if (Utils.isCollectionNotEmpty((Collection)currentCerts)) {
                allCertificates.addAll(currentCerts);
                sigVriDictionary.setItem("Cert", (COSBase)this.buildArray(pdDocument, streams, currentCerts, knownObjects));
            }
            if (Utils.isCollectionNotEmpty((Collection)(currentOcsps = callback.getOcsps()))) {
                allOcsps.addAll(currentOcsps);
                sigVriDictionary.setItem("OCSP", (COSBase)this.buildArray(pdDocument, streams, currentOcsps, knownObjects));
            }
            if (Utils.isCollectionNotEmpty((Collection)(currentCrls = callback.getCrls()))) {
                allCrls.addAll(currentCrls);
                sigVriDictionary.setItem("CRL", (COSBase)this.buildArray(pdDocument, streams, currentCrls, knownObjects));
            }
            String vriKey = callback.getSignature().getVRIKey();
            vriDictionary.setItem(vriKey, (COSBase)sigVriDictionary);
        }
        dss.setItem("VRI", (COSBase)vriDictionary);
        if (Utils.isCollectionNotEmpty(allCertificates)) {
            dss.setItem("Certs", (COSBase)this.buildArray(pdDocument, streams, allCertificates, knownObjects));
        }
        if (Utils.isCollectionNotEmpty(allOcsps)) {
            dss.setItem("OCSPs", (COSBase)this.buildArray(pdDocument, streams, allOcsps, knownObjects));
        }
        if (Utils.isCollectionNotEmpty(allCrls)) {
            dss.setItem("CRLs", (COSBase)this.buildArray(pdDocument, streams, allCrls, knownObjects));
        }
        return dss;
    }

    private COSArray buildArray(PDDocument pdDocument, Map<String, COSStream> streams, Collection<? extends Token> tokens, Map<String, Long> knownObjects) throws IOException {
        COSArray array = new COSArray();
        ArrayList<String> currentObjIds = new ArrayList<String>();
        for (Token token : tokens) {
            String digest = this.getTokenDigest(token);
            if (currentObjIds.contains(digest)) continue;
            Long objectNumber = knownObjects.get(digest);
            if (objectNumber == null) {
                COSStream stream = streams.get(digest);
                if (stream == null) {
                    stream = pdDocument.getDocument().createCOSStream();
                    try (OutputStream unfilteredStream = stream.createOutputStream();){
                        unfilteredStream.write(token.getEncoded());
                        unfilteredStream.flush();
                    }
                    streams.put(digest, stream);
                }
                array.add((COSBase)stream);
            } else {
                COSObject foundCosObject = this.getByObjectNumber(pdDocument, objectNumber);
                array.add((COSBase)foundCosObject);
            }
            currentObjIds.add(digest);
        }
        return array;
    }

    private COSObject getByObjectNumber(PDDocument pdDocument, Long objectNumber) {
        List objects = pdDocument.getDocument().getObjects();
        for (COSObject cosObject : objects) {
            if (cosObject.getObjectNumber() != objectNumber.longValue()) continue;
            return cosObject;
        }
        return null;
    }

    public List<String> getAvailableSignatureFields(DSSDocument document, String pwd) {
        ArrayList<String> result = new ArrayList<String>();
        try (InputStream is = document.openStream();
             PDDocument pdfDoc = PDDocument.load((InputStream)is, (String)pwd);){
            List signatureFields = pdfDoc.getSignatureFields();
            for (PDSignatureField pdSignatureField : signatureFields) {
                PDSignature signature = pdSignatureField.getSignature();
                if (signature != null) continue;
                result.add(pdSignatureField.getPartialName());
            }
        }
        catch (InvalidPasswordException e) {
            throw new eu.europa.esig.dss.pades.exception.InvalidPasswordException(e.getMessage());
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to determine signature fields. Reason : %s", e.getMessage()), (Throwable)e);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public DSSDocument addNewSignatureField(DSSDocument document, SignatureFieldParameters parameters, String pwd) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected PdfDocumentReader loadPdfDocumentReader(DSSDocument dssDocument, String passwordProtection) throws IOException, eu.europa.esig.dss.pades.exception.InvalidPasswordException {
        return new PdfBoxDocumentReader(dssDocument, passwordProtection);
    }

    protected PdfDocumentReader loadPdfDocumentReader(byte[] binaries, String passwordProtection) throws IOException, eu.europa.esig.dss.pades.exception.InvalidPasswordException {
        return new PdfBoxDocumentReader(binaries, passwordProtection);
    }
}

