/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer;

import eu.europa.esig.dss.enumerations.SignerTextPosition;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.ImageMerger;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.ImageTextWriter;
import eu.europa.esig.dss.pdf.visible.CommonDrawerUtils;
import eu.europa.esig.dss.pdf.visible.ImageAndResolution;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DefaultDrawerImageUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDrawerImageUtils.class);

    private DefaultDrawerImageUtils() {
    }

    public static ImageAndResolution create(SignatureImageParameters imageParameters) throws IOException {
        SignatureImageTextParameters textParameters = imageParameters.getTextParameters();
        DSSDocument image = imageParameters.getImage();
        if (!textParameters.isEmpty()) {
            BufferedImage scaledImage = null;
            ImageAndResolution imageAndResolution = null;
            if (image != null) {
                imageAndResolution = ImageUtils.secureReadMetadata((SignatureImageParameters)imageParameters);
                scaledImage = DefaultDrawerImageUtils.getDpiScaledImage(image, imageParameters, imageAndResolution);
            }
            BufferedImage buffImg = ImageTextWriter.createTextImage(imageParameters);
            SignatureFieldParameters fieldParameters = imageParameters.getFieldParameters();
            if (scaledImage != null && (fieldParameters.getWidth() != 0.0f || fieldParameters.getHeight() != 0.0f)) {
                int textWidth = fieldParameters.getWidth() == 0.0f ? buffImg.getWidth() : (int)(imageAndResolution.toXPoint((float)buffImg.getWidth()) * CommonDrawerUtils.getTextScaleFactor((Integer)imageParameters.getDpi()));
                int textHeight = fieldParameters.getHeight() == 0.0f ? buffImg.getHeight() : (int)(imageAndResolution.toYPoint((float)buffImg.getHeight()) * CommonDrawerUtils.getTextScaleFactor((Integer)imageParameters.getDpi()));
                buffImg = DefaultDrawerImageUtils.sizeImage(buffImg, textWidth, textHeight);
            }
            if (scaledImage == null && buffImg != null) {
                scaledImage = DefaultDrawerImageUtils.createEmptyImage(imageParameters, buffImg.getWidth(), buffImg.getHeight());
            }
            if (scaledImage != null) {
                SignerTextPosition signerNamePosition = textParameters.getSignerTextPosition();
                switch (signerNamePosition) {
                    case LEFT: {
                        scaledImage = DefaultDrawerImageUtils.writeImageToSignatureField(scaledImage, buffImg, fieldParameters, imageAndResolution, false);
                        buffImg = ImageMerger.mergeOnRight(buffImg, scaledImage, imageParameters.getBackgroundColor(), textParameters.getSignerTextVerticalAlignment());
                        break;
                    }
                    case RIGHT: {
                        scaledImage = DefaultDrawerImageUtils.writeImageToSignatureField(scaledImage, buffImg, fieldParameters, imageAndResolution, false);
                        buffImg = ImageMerger.mergeOnRight(scaledImage, buffImg, imageParameters.getBackgroundColor(), textParameters.getSignerTextVerticalAlignment());
                        break;
                    }
                    case TOP: {
                        scaledImage = DefaultDrawerImageUtils.writeImageToSignatureField(scaledImage, buffImg, fieldParameters, imageAndResolution, true);
                        buffImg = ImageMerger.mergeOnTop(scaledImage, buffImg, imageParameters.getBackgroundColor(), textParameters.getSignerTextHorizontalAlignment());
                        break;
                    }
                    case BOTTOM: {
                        scaledImage = DefaultDrawerImageUtils.writeImageToSignatureField(scaledImage, buffImg, fieldParameters, imageAndResolution, true);
                        buffImg = ImageMerger.mergeOnTop(buffImg, scaledImage, imageParameters.getBackgroundColor(), textParameters.getSignerTextHorizontalAlignment());
                        break;
                    }
                    default: {
                        throw new DSSException(String.format("The SignerNamePosition [%s] is not supported!", signerNamePosition.name()));
                    }
                }
            }
            return DefaultDrawerImageUtils.convertToInputStream(buffImg, CommonDrawerUtils.getDpi((Integer)imageParameters.getDpi()));
        }
        return ImageUtils.readDisplayMetadata((DSSDocument)image);
    }

    private static BufferedImage createEmptyImage(SignatureImageParameters imageParameters, int textWidth, int textHeight) {
        int width = 0;
        int height = 0;
        SignatureFieldParameters fieldParameters = imageParameters.getFieldParameters();
        int fieldWidth = (int)CommonDrawerUtils.computeProperSize((float)fieldParameters.getWidth(), (float)imageParameters.getDpi().intValue());
        int fieldHeight = (int)CommonDrawerUtils.computeProperSize((float)fieldParameters.getHeight(), (float)imageParameters.getDpi().intValue());
        SignerTextPosition signerNamePosition = imageParameters.getTextParameters().getSignerTextPosition();
        switch (signerNamePosition) {
            case LEFT: 
            case RIGHT: {
                width = fieldWidth - textWidth;
                height = Math.max(fieldHeight, textHeight);
                break;
            }
            case TOP: 
            case BOTTOM: {
                width = Math.max(fieldWidth, textWidth);
                height = fieldHeight - textHeight;
                break;
            }
            default: {
                throw new DSSException(String.format("The SignerNamePosition [%s] is not supported!", signerNamePosition.name()));
            }
        }
        if (width > 0 && height > 0) {
            BufferedImage image = new BufferedImage(width, height, 2);
            Graphics2D graphics2d = image.createGraphics();
            graphics2d.setComposite(AlphaComposite.Clear);
            graphics2d.fillRect(0, 0, width, height);
            graphics2d.dispose();
            return image;
        }
        return null;
    }

    private static BufferedImage getDpiScaledImage(DSSDocument image, SignatureImageParameters imageParameters, ImageAndResolution imageAndResolution) throws IOException {
        BufferedImage original = DefaultDrawerImageUtils.toBufferedImage(image);
        if (original == null) {
            return null;
        }
        try {
            float xScaleFactor = CommonDrawerUtils.getPageScaleFactor((Integer)imageAndResolution.getxDpi());
            xScaleFactor = CommonDrawerUtils.computeProperSize((float)xScaleFactor, (float)CommonDrawerUtils.getDpi((Integer)imageParameters.getDpi()));
            float yScaleFactor = CommonDrawerUtils.getPageScaleFactor((Integer)imageAndResolution.getyDpi());
            yScaleFactor = CommonDrawerUtils.computeProperSize((float)yScaleFactor, (float)CommonDrawerUtils.getDpi((Integer)imageParameters.getDpi()));
            return DefaultDrawerImageUtils.zoomImage(original, xScaleFactor, yScaleFactor);
        }
        catch (DSSException e) {
            LOG.warn("Cannot zoom image. Return the original : {}", (Object)e.getMessage());
            return original;
        }
    }

    private static BufferedImage toBufferedImage(DSSDocument image) throws IOException {
        try (InputStream is = image.openStream();){
            if (is != null) {
                BufferedImage bufferedImage = ImageIO.read(is);
                return bufferedImage;
            }
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
    }

    private static BufferedImage writeImageToSignatureField(BufferedImage image, BufferedImage textImage, SignatureFieldParameters fieldParameters, ImageAndResolution imageAndResolution, boolean verticalAlignment) {
        int imageHeight;
        if (image == null) {
            return null;
        }
        if (textImage == null) {
            return image;
        }
        int imageWidth = fieldParameters.getWidth() == 0.0f ? image.getWidth() : (int)fieldParameters.getWidth();
        int n = imageHeight = fieldParameters.getHeight() == 0.0f ? image.getHeight() : (int)fieldParameters.getHeight();
        if (fieldParameters.getWidth() != 0.0f) {
            int boxWidth = (int)CommonDrawerUtils.computeProperSize((float)imageWidth, (float)CommonDrawerUtils.getTextDpi());
            if (imageAndResolution != null) {
                boxWidth = (int)((float)boxWidth * CommonDrawerUtils.getPageScaleFactor((Integer)imageAndResolution.getxDpi()));
            }
            int n2 = imageWidth = verticalAlignment ? boxWidth : boxWidth - textImage.getWidth();
        }
        if (fieldParameters.getHeight() != 0.0f) {
            int boxHeight = (int)CommonDrawerUtils.computeProperSize((float)imageHeight, (float)CommonDrawerUtils.getTextDpi());
            if (imageAndResolution != null) {
                boxHeight = (int)((float)boxHeight * CommonDrawerUtils.getPageScaleFactor((Integer)imageAndResolution.getyDpi()));
            }
            int n3 = imageHeight = verticalAlignment ? boxHeight - textImage.getHeight() : boxHeight;
        }
        if (imageWidth < 1 || imageHeight < 1) {
            return null;
        }
        BufferedImage alignedImage = new BufferedImage(imageWidth, imageHeight, ImageUtils.getImageType((BufferedImage)image));
        Graphics2D g = alignedImage.createGraphics();
        CommonDrawerUtils.initRendering((Graphics2D)g);
        g.drawImage(image, 0, 0, imageWidth, imageHeight, null);
        return alignedImage;
    }

    private static BufferedImage zoomImage(BufferedImage original, float xScaleFactor, float yScaleFactor) {
        int newWidth = (int)((float)original.getWidth() * xScaleFactor);
        int newHeight = (int)((float)original.getHeight() * yScaleFactor);
        return DefaultDrawerImageUtils.sizeImage(original, newWidth, newHeight);
    }

    private static BufferedImage sizeImage(BufferedImage original, int newWidth, int newHeight) {
        BufferedImage resized = new BufferedImage(newWidth, newHeight, original.getType());
        Graphics2D gr = resized.createGraphics();
        gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        gr.drawImage(original, 0, 0, newWidth, newHeight, 0, 0, original.getWidth(), original.getHeight(), null);
        gr.dispose();
        return resized;
    }

    private static ImageAndResolution convertToInputStream(BufferedImage buffImage, int dpi) throws IOException {
        if (ImageUtils.isTransparent((BufferedImage)buffImage)) {
            return DefaultDrawerImageUtils.convertToInputStreamPNG(buffImage, dpi);
        }
        return DefaultDrawerImageUtils.convertToInputStreamJPG(buffImage, dpi);
    }

    private static ImageAndResolution convertToInputStreamJPG(BufferedImage buffImage, int dpi) throws IOException {
        ImageWriter writer = DefaultDrawerImageUtils.getImageWriter("jpeg");
        JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)writer.getDefaultWriteParam();
        jpegParams.setCompressionMode(2);
        jpegParams.setCompressionQuality(1.0f);
        ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, jpegParams);
        DefaultDrawerImageUtils.initDpiJPG(metadata, dpi);
        return DefaultDrawerImageUtils.getImageAndResolution(buffImage, dpi, writer, jpegParams, metadata);
    }

    private static void initDpiJPG(IIOMetadata metadata, int dpi) throws IIOInvalidTreeException {
        Element tree = (Element)metadata.getAsTree("javax_imageio_jpeg_image_1.0");
        Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
        jfif.setAttribute("Xdensity", Integer.toString(dpi));
        jfif.setAttribute("Ydensity", Integer.toString(dpi));
        jfif.setAttribute("resUnits", "1");
        metadata.setFromTree("javax_imageio_jpeg_image_1.0", tree);
    }

    private static ImageAndResolution convertToInputStreamPNG(BufferedImage buffImage, int dpi) throws IOException {
        ImageWriter writer = DefaultDrawerImageUtils.getImageWriter("png");
        ImageWriteParam imageWriterParams = writer.getDefaultWriteParam();
        ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(2);
        IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, imageWriterParams);
        DefaultDrawerImageUtils.initDpiPNG(metadata, dpi);
        return DefaultDrawerImageUtils.getImageAndResolution(buffImage, dpi, writer, imageWriterParams, metadata);
    }

    private static ImageAndResolution getImageAndResolution(BufferedImage buffImage, int dpi, ImageWriter writer, ImageWriteParam imageWriterParams, IIOMetadata metadata) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            ImageAndResolution imageAndResolution;
            block11: {
                ImageOutputStream imageOs = ImageIO.createImageOutputStream(os);
                try {
                    writer.setOutput(imageOs);
                    writer.write(metadata, new IIOImage(buffImage, null, metadata), imageWriterParams);
                    imageAndResolution = new ImageAndResolution((DSSDocument)new InMemoryDocument(os.toByteArray()), dpi, dpi);
                    if (imageOs == null) break block11;
                }
                catch (Throwable throwable) {
                    if (imageOs != null) {
                        try {
                            imageOs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                imageOs.close();
            }
            return imageAndResolution;
        }
    }

    private static void initDpiPNG(IIOMetadata metadata, int dpi) throws IIOInvalidTreeException {
        double dotsPerMilli = 1.0 * (double)dpi / 25.4;
        IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
        horiz.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
        vert.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode dim = new IIOMetadataNode("Dimension");
        dim.appendChild(horiz);
        dim.appendChild(vert);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dim);
        metadata.mergeTree("javax_imageio_1.0", root);
    }

    private static ImageWriter getImageWriter(String type) {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(type);
        if (!writers.hasNext()) {
            throw new DSSException("No writer for '" + type + "' found");
        }
        return writers.next();
    }
}

