/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pdf.pdfbox.visible.AbstractPdfBoxSignatureDrawer;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.DefaultDrawerImageUtils;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.SignatureImageAndPosition;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.SignatureImageAndPositionBuilder;
import eu.europa.esig.dss.pdf.visible.ImageAndResolution;
import java.io.IOException;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSigProperties;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSignDesigner;

public class DefaultPdfBoxVisibleSignatureDrawer
extends AbstractPdfBoxSignatureDrawer {
    private SignatureImageAndPosition signatureImageAndPosition;

    public SignatureImageAndPosition buildSignatureFieldBox() throws IOException {
        if (this.signatureImageAndPosition == null) {
            ImageAndResolution ires = DefaultDrawerImageUtils.create(this.parameters);
            this.signatureImageAndPosition = new SignatureImageAndPositionBuilder().build(this.parameters, this.document, ires);
        }
        return this.signatureImageAndPosition;
    }

    public void draw() throws IOException {
        SignatureImageAndPosition signatureImageAndPosition = this.buildSignatureFieldBox();
        int page = this.parameters.getFieldParameters().getPage();
        PDVisibleSignDesigner visibleSig = new PDVisibleSignDesigner(this.document, signatureImageAndPosition.getSignatureImage(), page);
        visibleSig.xAxis(signatureImageAndPosition.getX());
        visibleSig.yAxis(signatureImageAndPosition.getY());
        visibleSig.width(signatureImageAndPosition.getWidth());
        visibleSig.height(signatureImageAndPosition.getHeight());
        PDVisibleSigProperties signatureProperties = new PDVisibleSigProperties();
        signatureProperties.visualSignEnabled(true);
        signatureProperties.setPdVisibleSignature(visibleSig);
        signatureProperties.buildSignature();
        this.signatureOptions.setVisualSignature(signatureProperties);
        this.signatureOptions.setPage(page - 1);
    }

    @Override
    protected String getColorSpaceName(DSSDocument image) throws IOException {
        return COSName.DEVICERGB.getName();
    }
}

