/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer;

import eu.europa.esig.dss.enumerations.VisualSignatureAlignmentHorizontal;
import eu.europa.esig.dss.enumerations.VisualSignatureAlignmentVertical;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pdf.pdfbox.visible.ImageRotationUtils;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.SignatureImageAndPosition;
import eu.europa.esig.dss.pdf.visible.ImageAndResolution;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

public final class SignatureImageAndPositionBuilder {
    private static final String NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE = "not supported vertical alignment: ";
    private static final String NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE = "not supported horizontal alignment: ";

    public SignatureImageAndPosition build(SignatureImageParameters signatureImageParameters, PDDocument doc, ImageAndResolution ires) throws IOException {
        try (InputStream is = ires.getInputStream();){
            BufferedImage visualImageSignature = ImageUtils.read((InputStream)is);
            PDPage pdPage = doc.getPages().get(signatureImageParameters.getFieldParameters().getPage() - 1);
            int rotate = ImageRotationUtils.getRotation(signatureImageParameters.getRotation(), pdPage);
            if (rotate != 360) {
                visualImageSignature = ImageUtils.rotate((BufferedImage)visualImageSignature, (double)rotate);
            }
            boolean swapDimensions = ImageRotationUtils.isSwapOfDimensionsRequired(rotate);
            float width = this.processWidth(swapDimensions, ires, visualImageSignature, signatureImageParameters);
            float height = this.processHeight(swapDimensions, ires, visualImageSignature, signatureImageParameters);
            float x = this.processX(rotate, ires, width, pdPage, signatureImageParameters);
            float y = this.processY(rotate, ires, height, pdPage, signatureImageParameters);
            SignatureImageAndPosition signatureImageAndPosition = new SignatureImageAndPosition(x, y, width, height, visualImageSignature);
            return signatureImageAndPosition;
        }
    }

    private float processX(int rotation, ImageAndResolution ires, float boxWidth, PDPage pdPage, SignatureImageParameters signatureImageParameters) {
        float x;
        PDRectangle pageBox = pdPage.getMediaBox();
        switch (rotation) {
            case 90: {
                x = this.processXAngle90(pageBox, signatureImageParameters, boxWidth);
                break;
            }
            case 180: {
                x = this.processXAngle180(pageBox, signatureImageParameters, boxWidth);
                break;
            }
            case 270: {
                x = this.processXAngle270(pageBox, signatureImageParameters, boxWidth);
                break;
            }
            case 360: {
                x = this.processXAngle360(pageBox, signatureImageParameters, boxWidth);
                break;
            }
            default: {
                throw new IllegalStateException("rotation angle must be 90, 180, 270 or 360 (0)");
            }
        }
        return x;
    }

    private float processY(int rotation, ImageAndResolution ires, float boxHeight, PDPage pdPage, SignatureImageParameters signatureImageParameters) {
        float y;
        PDRectangle pageBox = pdPage.getMediaBox();
        switch (rotation) {
            case 90: {
                y = this.processYAngle90(pageBox, signatureImageParameters, boxHeight);
                break;
            }
            case 180: {
                y = this.processYAngle180(pageBox, signatureImageParameters, boxHeight);
                break;
            }
            case 270: {
                y = this.processYAngle270(pageBox, signatureImageParameters, boxHeight);
                break;
            }
            case 360: {
                y = this.processYAngle360(pageBox, signatureImageParameters, boxHeight);
                break;
            }
            default: {
                throw new IllegalStateException("rotation angle must be 90, 180, 270 or 360 (0)");
            }
        }
        return y;
    }

    private float processWidth(boolean swapDimensions, ImageAndResolution ires, BufferedImage visualImageSignature, SignatureImageParameters signatureImageParameters) {
        float width;
        SignatureFieldParameters fieldParameters = signatureImageParameters.getFieldParameters();
        float f = width = swapDimensions ? fieldParameters.getHeight() : fieldParameters.getWidth();
        if (width == 0.0f) {
            width = visualImageSignature.getWidth();
            width = swapDimensions ? ires.toYPoint(width) : ires.toXPoint(width);
        }
        return this.zoom(width, signatureImageParameters.getZoom());
    }

    private float processHeight(boolean swapDimensions, ImageAndResolution ires, BufferedImage visualImageSignature, SignatureImageParameters signatureImageParameters) {
        float height;
        SignatureFieldParameters fieldParameters = signatureImageParameters.getFieldParameters();
        float f = height = swapDimensions ? fieldParameters.getWidth() : fieldParameters.getHeight();
        if (height == 0.0f) {
            height = visualImageSignature.getHeight();
            height = swapDimensions ? ires.toXPoint(height) : ires.toYPoint(height);
        }
        return this.zoom(height, signatureImageParameters.getZoom());
    }

    private float zoom(float originalFloat, int zoom) {
        return originalFloat * (float)zoom / 100.0f;
    }

    private float processXAngle90(PDRectangle mediaBox, SignatureImageParameters signatureImageParameters, float width) {
        float x;
        SignatureFieldParameters fieldParameters = signatureImageParameters.getFieldParameters();
        VisualSignatureAlignmentVertical alignmentVertical = signatureImageParameters.getVisualSignatureAlignmentVertical();
        switch (alignmentVertical) {
            case TOP: 
            case NONE: {
                x = mediaBox.getWidth() - width - fieldParameters.getOriginY();
                break;
            }
            case MIDDLE: {
                x = (mediaBox.getWidth() - width) / 2.0f;
                break;
            }
            case BOTTOM: {
                x = fieldParameters.getOriginY();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE + alignmentVertical.name());
            }
        }
        return x;
    }

    private float processXAngle180(PDRectangle mediaBox, SignatureImageParameters signatureImageParameters, float width) {
        float x;
        SignatureFieldParameters fieldParameters = signatureImageParameters.getFieldParameters();
        VisualSignatureAlignmentHorizontal alignmentHorizontal = signatureImageParameters.getVisualSignatureAlignmentHorizontal();
        switch (alignmentHorizontal) {
            case LEFT: 
            case NONE: {
                x = mediaBox.getWidth() - width - fieldParameters.getOriginX();
                break;
            }
            case CENTER: {
                x = (mediaBox.getWidth() - width) / 2.0f;
                break;
            }
            case RIGHT: {
                x = fieldParameters.getOriginX();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE + alignmentHorizontal.name());
            }
        }
        return x;
    }

    private float processXAngle270(PDRectangle mediaBox, SignatureImageParameters signatureImageParameters, float width) {
        float x;
        SignatureFieldParameters fieldParameters = signatureImageParameters.getFieldParameters();
        VisualSignatureAlignmentVertical alignmentVertical = signatureImageParameters.getVisualSignatureAlignmentVertical();
        switch (alignmentVertical) {
            case TOP: 
            case NONE: {
                x = fieldParameters.getOriginY();
                break;
            }
            case MIDDLE: {
                x = (mediaBox.getWidth() - width) / 2.0f;
                break;
            }
            case BOTTOM: {
                x = mediaBox.getWidth() - width - fieldParameters.getOriginY();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE + alignmentVertical.name());
            }
        }
        return x;
    }

    private float processXAngle360(PDRectangle mediaBox, SignatureImageParameters signatureImageParameters, float width) {
        float x;
        SignatureFieldParameters fieldParameters = signatureImageParameters.getFieldParameters();
        VisualSignatureAlignmentHorizontal alignmentHorizontal = signatureImageParameters.getVisualSignatureAlignmentHorizontal();
        switch (alignmentHorizontal) {
            case LEFT: 
            case NONE: {
                x = fieldParameters.getOriginX();
                break;
            }
            case CENTER: {
                x = (mediaBox.getWidth() - width) / 2.0f;
                break;
            }
            case RIGHT: {
                x = mediaBox.getWidth() - width - fieldParameters.getOriginX();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE + alignmentHorizontal.name());
            }
        }
        return x;
    }

    private float processYAngle90(PDRectangle mediaBox, SignatureImageParameters signatureImageParameters, float height) {
        float y;
        SignatureFieldParameters fieldParameters = signatureImageParameters.getFieldParameters();
        VisualSignatureAlignmentHorizontal alignmentHorizontal = signatureImageParameters.getVisualSignatureAlignmentHorizontal();
        switch (alignmentHorizontal) {
            case LEFT: 
            case NONE: {
                y = fieldParameters.getOriginX();
                break;
            }
            case CENTER: {
                y = (mediaBox.getHeight() - height) / 2.0f;
                break;
            }
            case RIGHT: {
                y = mediaBox.getHeight() - height - fieldParameters.getOriginX();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE + alignmentHorizontal.name());
            }
        }
        return y;
    }

    private float processYAngle180(PDRectangle mediaBox, SignatureImageParameters signatureImageParameters, float height) {
        float y;
        SignatureFieldParameters fieldParameters = signatureImageParameters.getFieldParameters();
        VisualSignatureAlignmentVertical alignmentVertical = signatureImageParameters.getVisualSignatureAlignmentVertical();
        switch (alignmentVertical) {
            case TOP: 
            case NONE: {
                y = mediaBox.getHeight() - height - fieldParameters.getOriginY();
                break;
            }
            case MIDDLE: {
                y = (mediaBox.getHeight() - height) / 2.0f;
                break;
            }
            case BOTTOM: {
                y = fieldParameters.getOriginY();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE + alignmentVertical.name());
            }
        }
        return y;
    }

    private float processYAngle270(PDRectangle mediaBox, SignatureImageParameters signatureImageParameters, float height) {
        float y;
        SignatureFieldParameters fieldParameters = signatureImageParameters.getFieldParameters();
        VisualSignatureAlignmentHorizontal alignmentHorizontal = signatureImageParameters.getVisualSignatureAlignmentHorizontal();
        switch (alignmentHorizontal) {
            case LEFT: 
            case NONE: {
                y = mediaBox.getHeight() - height - fieldParameters.getOriginX();
                break;
            }
            case CENTER: {
                y = (mediaBox.getHeight() - height) / 2.0f;
                break;
            }
            case RIGHT: {
                y = fieldParameters.getOriginX();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE + alignmentHorizontal.name());
            }
        }
        return y;
    }

    private float processYAngle360(PDRectangle mediaBox, SignatureImageParameters signatureImageParameters, float height) {
        float y;
        SignatureFieldParameters fieldParameters = signatureImageParameters.getFieldParameters();
        VisualSignatureAlignmentVertical alignmentVertical = signatureImageParameters.getVisualSignatureAlignmentVertical();
        switch (alignmentVertical) {
            case TOP: 
            case NONE: {
                y = fieldParameters.getOriginY();
                break;
            }
            case MIDDLE: {
                y = (mediaBox.getHeight() - height) / 2.0f;
                break;
            }
            case BOTTOM: {
                y = mediaBox.getHeight() - height - fieldParameters.getOriginY();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE + alignmentVertical.name());
            }
        }
        return y;
    }
}

