/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.validation.ByteRange;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.PdfAnnotation;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfDocumentReader;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSigDictWrapper;
import eu.europa.esig.dss.pdf.SingleDssDict;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxDict;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxUtils;
import eu.europa.esig.dss.utils.Utils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfBoxDocumentReader
implements PdfDocumentReader {
    private static final Logger LOG = LoggerFactory.getLogger(PdfBoxDocumentReader.class);
    private DSSDocument dssDocument;
    private final PDDocument pdDocument;

    public PdfBoxDocumentReader(DSSDocument dssDocument) throws IOException, eu.europa.esig.dss.pades.exception.InvalidPasswordException {
        this(dssDocument, null);
    }

    public PdfBoxDocumentReader(DSSDocument dssDocument, String passwordProtection) throws IOException, eu.europa.esig.dss.pades.exception.InvalidPasswordException {
        Objects.requireNonNull(dssDocument, "The document must be defined!");
        this.dssDocument = dssDocument;
        try (InputStream is = dssDocument.openStream();){
            this.pdDocument = PDDocument.load((InputStream)is, (String)passwordProtection);
        }
        catch (InvalidPasswordException e) {
            throw new eu.europa.esig.dss.pades.exception.InvalidPasswordException(e.getMessage());
        }
    }

    public PdfBoxDocumentReader(byte[] binaries, String passwordProtection) throws IOException, eu.europa.esig.dss.pades.exception.InvalidPasswordException {
        Objects.requireNonNull(binaries, "The document binaries must be defined!");
        try {
            this.pdDocument = PDDocument.load((byte[])binaries, (String)passwordProtection);
        }
        catch (InvalidPasswordException e) {
            throw new eu.europa.esig.dss.pades.exception.InvalidPasswordException(e.getMessage());
        }
    }

    public PdfBoxDocumentReader(PDDocument pdDocument) {
        this.pdDocument = pdDocument;
    }

    public PdfDssDict getDSSDictionary() {
        PdfBoxDict catalog = new PdfBoxDict(this.pdDocument.getDocumentCatalog().getCOSObject(), this.pdDocument);
        return SingleDssDict.extract((PdfDict)catalog);
    }

    public Map<PdfSignatureDictionary, List<String>> extractSigDictionaries() throws IOException {
        LinkedHashMap<PdfSignatureDictionary, List<String>> pdfDictionaries = new LinkedHashMap<PdfSignatureDictionary, List<String>>();
        LinkedHashMap<Long, PdfSignatureDictionary> pdfObjectDictMap = new LinkedHashMap<Long, PdfSignatureDictionary>();
        List pdSignatureFields = this.pdDocument.getSignatureFields();
        if (Utils.isCollectionNotEmpty((Collection)pdSignatureFields)) {
            LOG.debug("{} signature(s) found", (Object)pdSignatureFields.size());
            for (PDSignatureField signatureField : pdSignatureFields) {
                String signatureFieldName = signatureField.getPartialName();
                COSObject sigDictObject = signatureField.getCOSObject().getCOSObject(COSName.V);
                if (sigDictObject == null || !(sigDictObject.getObject() instanceof COSDictionary)) {
                    LOG.warn("Signature field with name '{}' does not contain a signature", (Object)signatureFieldName);
                    continue;
                }
                long sigDictNumber = sigDictObject.getObjectNumber();
                PdfSignatureDictionary signature = (PdfSignatureDictionary)pdfObjectDictMap.get(sigDictNumber);
                if (signature == null) {
                    try {
                        PdfBoxDict dictionary = new PdfBoxDict((COSDictionary)sigDictObject.getObject(), this.pdDocument);
                        signature = new PdfSigDictWrapper((PdfDict)dictionary);
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to create a PdfSignatureDictionary for field with name '{}'", (Object)signatureFieldName, (Object)e);
                        continue;
                    }
                    ArrayList<String> fieldNames = new ArrayList<String>();
                    fieldNames.add(signatureFieldName);
                    pdfDictionaries.put(signature, fieldNames);
                    pdfObjectDictMap.put(sigDictNumber, signature);
                    continue;
                }
                List fieldNameList = (List)pdfDictionaries.get(signature);
                fieldNameList.add(signatureFieldName);
                LOG.warn("More than one field refers to the same signature dictionary: {}!", (Object)fieldNameList);
            }
        }
        return pdfDictionaries;
    }

    public boolean isSignatureCoversWholeDocument(PdfSignatureDictionary signatureDictionary) {
        boolean bl;
        block8: {
            ByteRange byteRange = signatureDictionary.getByteRange();
            InputStream is = this.dssDocument.openStream();
            try {
                long originalBytesLength = Utils.getInputStreamSize((InputStream)is);
                long beforeSignatureLength = (long)byteRange.getFirstPartEnd() - (long)byteRange.getFirstPartStart();
                long expectedCMSLength = (long)byteRange.getSecondPartStart() - (long)byteRange.getFirstPartEnd() - (long)byteRange.getFirstPartStart();
                long afterSignatureLength = byteRange.getSecondPartEnd();
                long totalCoveredByByteRange = beforeSignatureLength + expectedCMSLength + afterSignatureLength;
                boolean bl2 = bl = originalBytesLength == totalCoveredByByteRange;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("Cannot determine the original file size for the document. Reason : {}", (Object)e.getMessage());
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    public void close() throws IOException {
        this.pdDocument.close();
    }

    public int getNumberOfPages() {
        return this.pdDocument.getNumberOfPages();
    }

    public AnnotationBox getPageBox(int page) {
        PDPage pdPage = this.getPDPage(page);
        PDRectangle mediaBox = pdPage.getMediaBox();
        return new AnnotationBox(mediaBox.getLowerLeftX(), mediaBox.getLowerLeftY(), mediaBox.getUpperRightX(), mediaBox.getUpperRightY());
    }

    public List<PdfAnnotation> getPdfAnnotations(int page) throws IOException {
        ArrayList<PdfAnnotation> annotations = new ArrayList<PdfAnnotation>();
        List<PDAnnotation> pdAnnotations = this.getPageAnnotations(page);
        for (PDAnnotation pdAnnotation : pdAnnotations) {
            PdfAnnotation pdfAnnotation = this.toPdfAnnotation(pdAnnotation);
            if (pdfAnnotation == null) continue;
            annotations.add(pdfAnnotation);
        }
        return annotations;
    }

    private List<PDAnnotation> getPageAnnotations(int page) throws IOException {
        PDPage pdPage = this.getPDPage(page);
        return pdPage.getAnnotations();
    }

    public PDPage getPDPage(int page) {
        return this.pdDocument.getPage(page - 1);
    }

    private PdfAnnotation toPdfAnnotation(PDAnnotation pdAnnotation) {
        PDRectangle pdRect = pdAnnotation.getRectangle();
        if (pdRect != null) {
            AnnotationBox annotationBox = new AnnotationBox(pdRect.getLowerLeftX(), pdRect.getLowerLeftY(), pdRect.getUpperRightX(), pdRect.getUpperRightY());
            PdfAnnotation pdfAnnotation = new PdfAnnotation(annotationBox);
            pdfAnnotation.setName(this.getSignatureFieldName(pdAnnotation));
            pdfAnnotation.setSigned(this.isSigned(pdAnnotation));
            return pdfAnnotation;
        }
        return null;
    }

    private String getSignatureFieldName(PDAnnotation pdAnnotation) {
        return pdAnnotation.getCOSObject().getString(COSName.T);
    }

    private boolean isSigned(PDAnnotation pdAnnotation) {
        COSObject sigDicObject = pdAnnotation.getCOSObject().getCOSObject(COSName.V);
        return sigDicObject != null;
    }

    public BufferedImage generateImageScreenshot(int page) throws IOException {
        return PdfBoxUtils.generateBufferedImageScreenshot(this.pdDocument, page);
    }

    public BufferedImage generateImageScreenshotWithoutAnnotations(int page, List<PdfAnnotation> annotations) throws IOException {
        List<PDAnnotation> pdAnnotations = this.getPageAnnotations(page);
        for (PDAnnotation pdAnnotation : pdAnnotations) {
            PdfAnnotation pdfAnnotation = this.toPdfAnnotation(pdAnnotation);
            if (!annotations.contains(pdfAnnotation)) continue;
            pdAnnotation.setHidden(true);
        }
        return this.generateImageScreenshot(page);
    }
}

