/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.pdfbox.visible.PdfBoxSignatureDrawer;
import eu.europa.esig.dss.pdf.visible.DSSFontMetrics;
import eu.europa.esig.dss.pdf.visible.SignatureFieldBoxBuilder;
import eu.europa.esig.dss.pdf.visible.SignatureFieldDimensionAndPosition;
import eu.europa.esig.dss.pdf.visible.SignatureFieldDimensionAndPositionBuilder;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPdfBoxSignatureDrawer
implements PdfBoxSignatureDrawer,
SignatureFieldBoxBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPdfBoxSignatureDrawer.class);
    private static final String CMYK_PROFILE_NAME = "cmyk";
    private static final String RGB_PROFILE_NAME = "rgb";
    protected SignatureImageParameters parameters;
    protected PDDocument document;
    protected SignatureOptions signatureOptions;

    @Override
    public void init(SignatureImageParameters parameters, PDDocument document, SignatureOptions signatureOptions) throws IOException {
        this.assertSignatureParametersAreValid(parameters);
        this.parameters = parameters;
        this.document = document;
        this.signatureOptions = signatureOptions;
        this.checkColorSpace(document, parameters.getImage());
    }

    private void assertSignatureParametersAreValid(SignatureImageParameters parameters) {
        if (parameters == null || parameters.getImage() == null && parameters.getTextParameters().isEmpty()) {
            throw new IllegalArgumentException("Neither image nor text parameters are defined!");
        }
    }

    public SignatureFieldDimensionAndPosition buildSignatureFieldBox() {
        PDPage originalPage = this.document.getPage(this.parameters.getFieldParameters().getPage() - 1);
        PDRectangle mediaBox = originalPage.getMediaBox();
        AnnotationBox pageBox = new AnnotationBox(mediaBox.getLowerLeftX(), mediaBox.getLowerLeftY(), mediaBox.getUpperRightX(), mediaBox.getUpperRightY());
        return new SignatureFieldDimensionAndPositionBuilder(this.parameters, this.getDSSFontMetrics(), pageBox, originalPage.getRotation()).setSignatureFieldAnnotationBox(this.getSignatureFieldAnnotationBox()).build();
    }

    protected abstract DSSFontMetrics getDSSFontMetrics();

    protected void checkColorSpace(PDDocument pdDocument, DSSDocument image) throws IOException {
        if (image != null) {
            PDDocumentCatalog catalog = pdDocument.getDocumentCatalog();
            List profiles = catalog.getOutputIntents();
            if (Utils.isCollectionEmpty((Collection)profiles)) {
                LOG.warn("No color profile is present in the document. Not compatible with PDF/A");
                return;
            }
            String colorSpaceName = this.getColorSpaceName(image);
            if (COSName.DEVICECMYK.getName().equals(colorSpaceName) && this.isProfilePresent(profiles, RGB_PROFILE_NAME)) {
                LOG.warn("A CMYK image will be added to an RGB color space PDF. Be aware: not compatible with PDF/A.");
            } else if (COSName.DEVICERGB.getName().equals(colorSpaceName) && this.isProfilePresent(profiles, CMYK_PROFILE_NAME)) {
                LOG.warn("An RGB image will be added to a CMYK color space PDF. Be aware: not compatible with PDF/A.");
            }
        }
    }

    protected abstract String getColorSpaceName(DSSDocument var1) throws IOException;

    private boolean isProfilePresent(List<PDOutputIntent> profiles, String profileName) {
        for (PDOutputIntent profile : profiles) {
            if (!(Utils.isStringNotEmpty((String)profile.getInfo()) && profile.getInfo().toLowerCase().contains(profileName) || Utils.isStringNotEmpty((String)profile.getOutputCondition()) && profile.getOutputCondition().toLowerCase().contains(profileName)) && (!Utils.isStringNotEmpty((String)profile.getOutputConditionIdentifier()) || !profile.getOutputConditionIdentifier().toLowerCase().contains(profileName))) continue;
            return true;
        }
        return false;
    }

    private AnnotationBox getSignatureFieldAnnotationBox() {
        PDAnnotationWidget pdAnnotationWidget;
        List widgets;
        PDSignatureField signatureField = this.getExistingSignatureFieldToFill();
        if (signatureField != null && Utils.isCollectionNotEmpty((Collection)(widgets = signatureField.getWidgets())) && (pdAnnotationWidget = (PDAnnotationWidget)widgets.get(0)) != null) {
            PDRectangle rectangle = pdAnnotationWidget.getRectangle();
            return new AnnotationBox(rectangle.getLowerLeftX(), rectangle.getLowerLeftY(), rectangle.getUpperRightX(), rectangle.getUpperRightY());
        }
        return null;
    }

    private PDSignatureField getExistingSignatureFieldToFill() {
        PDSignatureField signatureField;
        PDAcroForm acroForm;
        String signatureFieldId = this.parameters.getFieldParameters().getFieldId();
        if (Utils.isStringNotEmpty((String)signatureFieldId) && (acroForm = this.document.getDocumentCatalog().getAcroForm()) != null && (signatureField = (PDSignatureField)acroForm.getField(signatureFieldId)) != null) {
            return signatureField;
        }
        return null;
    }
}

