/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer;

import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.DSSFont;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.JavaDSSFontMetrics;
import eu.europa.esig.dss.pdf.visible.DPIUtils;
import eu.europa.esig.dss.pdf.visible.ImageRotationUtils;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import eu.europa.esig.dss.pdf.visible.SignatureFieldDimensionAndPosition;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultImageDrawerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultImageDrawerUtils.class);

    private DefaultImageDrawerUtils() {
    }

    public static BufferedImage createTextImage(SignatureImageParameters imageParameters, SignatureFieldDimensionAndPosition dimensionAndPosition, JavaDSSFontMetrics fontMetrics) {
        int imageType;
        SignatureImageTextParameters textParameters = imageParameters.getTextParameters();
        String[] lines = dimensionAndPosition.getText().split("\n");
        if (DefaultImageDrawerUtils.isTransparent(textParameters.getTextColor(), textParameters.getBackgroundColor())) {
            LOG.warn("Transparency detected and enabled (Be aware: not valid with PDF/A !)");
            imageType = 2;
        } else {
            imageType = 1;
        }
        int textDPI = DPIUtils.getDpi((Integer)imageParameters.getDpi());
        BufferedImage img = new BufferedImage((int)DPIUtils.computeProperSize((float)dimensionAndPosition.getTextBoxWidth(), (float)textDPI), (int)DPIUtils.computeProperSize((float)dimensionAndPosition.getTextBoxHeight(), (float)textDPI), imageType);
        Graphics2D g = img.createGraphics();
        Font font = DefaultImageDrawerUtils.getJavaFont(imageParameters, dimensionAndPosition.getTextSize(), textDPI);
        g.setFont(font);
        DefaultImageDrawerUtils.initRendering(g);
        if (textParameters.getBackgroundColor() == null) {
            g.setColor(Color.WHITE);
        } else {
            g.setColor(textParameters.getBackgroundColor());
        }
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        if (textParameters.getTextColor() == null) {
            g.setPaint(Color.BLACK);
        } else {
            g.setPaint(textParameters.getTextColor());
        }
        float lineHeight = fontMetrics.getHeight(lines[0], font.getSize());
        float y = fontMetrics.getMaxAscent(font.getSize()) + DPIUtils.computeProperSize((float)(dimensionAndPosition.getTextY() - dimensionAndPosition.getTextBoxY()), (float)textDPI);
        for (String line : lines) {
            float x = DPIUtils.computeProperSize((float)(dimensionAndPosition.getTextX() - dimensionAndPosition.getTextBoxX()), (float)textDPI);
            if (textParameters.getSignerTextHorizontalAlignment() != null) {
                switch (textParameters.getSignerTextHorizontalAlignment()) {
                    case RIGHT: {
                        x = (float)img.getWidth() - fontMetrics.getWidth(line, font.getSize()) - x;
                        break;
                    }
                    case CENTER: {
                        x = ((float)img.getWidth() - fontMetrics.getWidth(line, font.getSize())) / 2.0f;
                        break;
                    }
                }
            }
            g.drawString(line, x, y);
            y += lineHeight;
        }
        g.dispose();
        return img;
    }

    private static Font getJavaFont(SignatureImageParameters imageParameters, float textSize, int dpi) {
        DSSFont dssFont = imageParameters.getTextParameters().getFont();
        float fontSize = DPIUtils.computeProperSize((float)textSize, (float)dpi);
        Font javaFont = dssFont.getJavaFont();
        return javaFont.deriveFont(fontSize);
    }

    private static boolean isTransparent(Color ... colors) {
        if (colors != null) {
            for (Color color : colors) {
                int alpha;
                if (color == null || (alpha = color.getAlpha()) >= 255) continue;
                return true;
            }
        }
        return false;
    }

    public static BufferedImage toBufferedImage(DSSDocument imageDocument) {
        try {
            return ImageUtils.readImage((DSSDocument)imageDocument);
        }
        catch (IOException e) {
            throw new IllegalInputException(String.format("An error occurred during image document reading : %s", e.getMessage()), (Throwable)e);
        }
    }

    public static void initRendering(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
    }

    public static BufferedImage mergeImages(BufferedImage image, BufferedImage textImage, SignatureFieldDimensionAndPosition dimensionAndPosition, SignatureImageParameters imageParameters) {
        int imageType = DefaultImageDrawerUtils.getImageType(image, textImage);
        int xDpi = dimensionAndPosition.getImageResolution().getXDpi();
        int yDpi = dimensionAndPosition.getImageResolution().getYDpi();
        if (textImage != null) {
            xDpi = DPIUtils.getDpi((Integer)imageParameters.getDpi());
            yDpi = DPIUtils.getDpi((Integer)imageParameters.getDpi());
        }
        float imageWidthRatio = 1.0f;
        float imageHeightRatio = 1.0f;
        if (image != null) {
            float widthRatio = (float)image.getWidth() / dimensionAndPosition.getImageWidth() * DPIUtils.getPageScaleFactor((Integer)xDpi);
            imageWidthRatio = widthRatio > 1.0f ? widthRatio : imageWidthRatio;
            float heightRatio = (float)image.getHeight() / dimensionAndPosition.getImageHeight() * DPIUtils.getPageScaleFactor((Integer)yDpi);
            imageHeightRatio = heightRatio > 1.0f ? heightRatio : imageHeightRatio;
        }
        float width = dimensionAndPosition.getBoxWidth();
        float height = dimensionAndPosition.getBoxHeight();
        if (ImageRotationUtils.isSwapOfDimensionsRequired((int)dimensionAndPosition.getGlobalRotation())) {
            width = dimensionAndPosition.getBoxHeight();
            height = dimensionAndPosition.getBoxWidth();
        }
        BufferedImage result = DefaultImageDrawerUtils.getEmptyImage(width * imageWidthRatio, height * imageHeightRatio, xDpi, yDpi, imageType);
        Graphics2D g = result.createGraphics();
        DefaultImageDrawerUtils.initRendering(g);
        if (2 != imageType || imageParameters.getTextParameters() != null && !imageParameters.getTextParameters().isEmpty() || imageParameters.getBackgroundColor() != null) {
            DefaultImageDrawerUtils.fillBackground(g, result.getWidth(), result.getHeight(), imageParameters.getBackgroundColor());
        }
        if (textImage != null) {
            DefaultImageDrawerUtils.drawImage(g, textImage, DPIUtils.computeProperSize((float)(dimensionAndPosition.getTextBoxX() * imageWidthRatio), (float)xDpi), DPIUtils.computeProperSize((float)((height - dimensionAndPosition.getTextBoxY() - dimensionAndPosition.getTextBoxHeight()) * imageHeightRatio), (float)yDpi), DPIUtils.computeProperSize((float)(dimensionAndPosition.getTextBoxWidth() * imageWidthRatio), (float)xDpi), DPIUtils.computeProperSize((float)(dimensionAndPosition.getTextBoxHeight() * imageHeightRatio), (float)yDpi));
        }
        if (image != null) {
            DefaultImageDrawerUtils.drawImage(g, image, DPIUtils.computeProperSize((float)(dimensionAndPosition.getImageX() * imageWidthRatio), (float)xDpi), DPIUtils.computeProperSize((float)((height - dimensionAndPosition.getImageY() - dimensionAndPosition.getImageHeight()) * imageHeightRatio), (float)yDpi), DPIUtils.computeProperSize((float)(dimensionAndPosition.getImageWidth() * imageWidthRatio), (float)xDpi), DPIUtils.computeProperSize((float)(dimensionAndPosition.getImageHeight() * imageHeightRatio), (float)yDpi));
        }
        return result;
    }

    private static int getImageType(BufferedImage image1, BufferedImage image2) {
        int imageType = 1;
        if (image1 != null && ImageUtils.isTransparent((BufferedImage)image1) || image2 != null && ImageUtils.isTransparent((BufferedImage)image2)) {
            LOG.warn("Transparency detected and enabled (Be aware: not valid with PDF/A !)");
            imageType = 2;
        }
        return imageType;
    }

    private static BufferedImage getEmptyImage(float width, float height, int xDpi, int yDpi, int imageType) {
        return new BufferedImage((int)DPIUtils.computeProperSize((float)width, (float)xDpi), (int)DPIUtils.computeProperSize((float)height, (float)yDpi), imageType);
    }

    private static void fillBackground(Graphics g, float width, float height, Color bgColor) {
        g.setColor(bgColor);
        g.fillRect(0, 0, (int)width, (int)height);
    }

    private static void drawImage(Graphics g, BufferedImage image, float x, float y, float width, float height) {
        g.drawImage(image, (int)x, (int)y, (int)width, (int)height, null);
    }

    public static BufferedImage rotate(BufferedImage image, double angle) {
        if (0.0 == angle || 360.0 == angle) {
            return image;
        }
        double sin = Math.abs(Math.sin(Math.toRadians(angle)));
        double cos = Math.abs(Math.cos(Math.toRadians(angle)));
        int w = image.getWidth();
        int h = image.getHeight();
        double neww = Math.floor((double)w * cos + (double)h * sin);
        double newh = Math.floor((double)h * cos + (double)w * sin);
        BufferedImage result = new BufferedImage((int)neww, (int)newh, image.getType());
        Graphics2D g = result.createGraphics();
        g.translate((neww - (double)w) / 2.0, (newh - (double)h) / 2.0);
        g.rotate(Math.toRadians(angle), (double)w / 2.0, (double)h / 2.0);
        g.drawRenderedImage(image, null);
        g.dispose();
        return result;
    }
}

