/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible.nativedrawer;

import java.awt.Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class PdfBoxFontMapper {
    public static PDType1Font getPDFont(Font javaFont) {
        switch (javaFont.getFamily()) {
            case "Serif": {
                if (javaFont.isPlain()) {
                    return PDType1Font.TIMES_ROMAN;
                }
                if (javaFont.isBold()) {
                    if (javaFont.isItalic()) {
                        return PDType1Font.TIMES_BOLD_ITALIC;
                    }
                    return PDType1Font.TIMES_BOLD;
                }
                return PDType1Font.TIMES_ITALIC;
            }
            case "SansSerif": {
                if (javaFont.isPlain()) {
                    return PDType1Font.HELVETICA;
                }
                if (javaFont.isBold()) {
                    if (javaFont.isItalic()) {
                        return PDType1Font.HELVETICA_BOLD_OBLIQUE;
                    }
                    return PDType1Font.HELVETICA_BOLD;
                }
                return PDType1Font.HELVETICA_OBLIQUE;
            }
            case "Monospaced": {
                if (javaFont.isPlain()) {
                    return PDType1Font.COURIER;
                }
                if (javaFont.isBold()) {
                    if (javaFont.isItalic()) {
                        return PDType1Font.COURIER_BOLD_OBLIQUE;
                    }
                    return PDType1Font.COURIER_BOLD;
                }
                return PDType1Font.COURIER_OBLIQUE;
            }
            case "Dialog": 
            case "DialogInput": {
                return PDType1Font.SYMBOL;
            }
        }
        throw new UnsupportedOperationException("The font is not supported! Please use DSSFileFont implementation for custom fonts.");
    }
}

