/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible.nativedrawer;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pdf.visible.AbstractDSSFontMetrics;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.font.PDFont;

public class PdfBoxDSSFontMetrics
extends AbstractDSSFontMetrics {
    private final PDFont pdFont;

    public PdfBoxDSSFontMetrics(PDFont pdFont) {
        this.pdFont = pdFont;
    }

    public float getWidth(String str, float size) {
        try {
            return this.pdFont.getStringWidth(str) / 1000.0f * size;
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to compute string width! Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    public float getHeight(String str, float size) {
        try {
            return this.pdFont.getBoundingBox().getHeight() / 1000.0f * size;
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to compute string height! Reason : %s", e.getMessage()), (Throwable)e);
        }
    }
}

