/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer;

import eu.europa.esig.dss.pades.DSSFont;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.pdf.pdfbox.visible.AbstractPdfBoxSignatureDrawer;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.DefaultImageDrawerUtils;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.JavaDSSFontMetrics;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import eu.europa.esig.dss.pdf.visible.SignatureFieldDimensionAndPosition;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSigProperties;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSignDesigner;

public class DefaultPdfBoxVisibleSignatureDrawer
extends AbstractPdfBoxSignatureDrawer {
    protected JavaDSSFontMetrics getDSSFontMetrics() {
        SignatureImageTextParameters textParameters = this.parameters.getTextParameters();
        DSSFont dssFont = textParameters.getFont();
        Font javaFont = dssFont.getJavaFont();
        float properSize = dssFont.getSize() * ImageUtils.getScaleFactor((int)this.parameters.getZoom());
        Font properFont = javaFont.deriveFont(properSize);
        return new JavaDSSFontMetrics(properFont);
    }

    public void draw() throws IOException {
        SignatureFieldDimensionAndPosition dimensionAndPosition = this.buildSignatureFieldBox();
        BufferedImage image = null;
        BufferedImage textImage = null;
        if (this.parameters.getImage() != null) {
            image = DefaultImageDrawerUtils.toBufferedImage(this.parameters.getImage());
        }
        if (this.parameters.getTextParameters() != null && !this.parameters.getTextParameters().isEmpty()) {
            textImage = DefaultImageDrawerUtils.createTextImage(this.parameters, dimensionAndPosition, this.getDSSFontMetrics());
        }
        if (image == null && textImage == null) {
            throw new IllegalArgumentException("Image or text shall be defined in order to build a visual signature!");
        }
        BufferedImage bufferedImage = DefaultImageDrawerUtils.mergeImages(image, textImage, dimensionAndPosition, this.parameters);
        bufferedImage = DefaultImageDrawerUtils.rotate(bufferedImage, dimensionAndPosition.getGlobalRotation());
        int page = this.parameters.getFieldParameters().getPage();
        PDVisibleSignDesigner visibleSig = new PDVisibleSignDesigner(this.document, bufferedImage, page);
        visibleSig.xAxis(dimensionAndPosition.getBoxX());
        visibleSig.yAxis(dimensionAndPosition.getBoxY());
        visibleSig.width(dimensionAndPosition.getBoxWidth());
        visibleSig.height(dimensionAndPosition.getBoxHeight());
        PDVisibleSigProperties signatureProperties = new PDVisibleSigProperties();
        signatureProperties.visualSignEnabled(true);
        signatureProperties.setPdVisibleSignature(visibleSig);
        signatureProperties.buildSignature();
        this.signatureOptions.setVisualSignature(signatureProperties);
        this.signatureOptions.setPage(page - 1);
    }

    @Override
    protected String getExpectedColorSpaceName() {
        if (this.parameters.getImage() != null) {
            return COSName.DEVICERGB.getName();
        }
        return ImageUtils.containRGBColor((SignatureImageParameters)this.parameters) ? COSName.DEVICERGB.getName() : COSName.DEVICEGRAY.getName();
    }
}

