/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades;

import eu.europa.esig.dss.enumerations.CertificationPermission;
import eu.europa.esig.dss.enumerations.PdfLockAction;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pades.validation.ByteRange;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.RevocationInfoArchival;
import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfCMSRevision;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVRIDict;
import eu.europa.esig.dss.pdf.SigFieldPermissions;
import eu.europa.esig.dss.signature.resources.DSSResourcesHandler;
import eu.europa.esig.dss.signature.resources.DSSResourcesHandlerBuilder;
import eu.europa.esig.dss.signature.resources.InMemoryResourcesHandlerBuilder;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PAdESUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PAdESUtils.class);
    public static final int DEFAULT_FIRST_PAGE = 1;
    public static final InMemoryResourcesHandlerBuilder DEFAULT_RESOURCES_HANDLER_BUILDER = new InMemoryResourcesHandlerBuilder();
    private static final byte[] PDF_PREAMBLE = new byte[]{37, 80, 68, 70, 45};
    private static final byte[] PDF_EOF_STRING = new byte[]{37, 37, 69, 79, 70};

    private PAdESUtils() {
    }

    public static InMemoryDocument getOriginalPDF(PAdESSignature padesSignature) {
        List coveredOriginalFile = padesSignature.getDetachedContents();
        if (Utils.collectionSize((Collection)coveredOriginalFile) == 1) {
            DSSDocument dataToBeSigned = (DSSDocument)coveredOriginalFile.get(0);
            ByteRange signatureByteRange = padesSignature.getPdfRevision().getByteRange();
            DSSDocument firstByteRangePart = DSSUtils.splitDocument((DSSDocument)dataToBeSigned, (int)signatureByteRange.getFirstPartStart(), (int)signatureByteRange.getFirstPartEnd());
            return PAdESUtils.retrieveCompletePDFRevision(firstByteRangePart);
        }
        return null;
    }

    public static InMemoryDocument getOriginalPDF(PdfCMSRevision pdfRevision) {
        DSSDocument signedDocument = pdfRevision.getSignedData();
        ByteRange signatureByteRange = pdfRevision.getByteRange();
        return PAdESUtils.retrievePreviousPDFRevision(signedDocument, signatureByteRange);
    }

    public static InMemoryDocument retrievePreviousPDFRevision(DSSDocument document, ByteRange byteRange) {
        DSSDocument firstByteRangePart = DSSUtils.splitDocument((DSSDocument)document, (int)byteRange.getFirstPartStart(), (int)byteRange.getFirstPartEnd());
        return PAdESUtils.retrieveCompletePDFRevision(firstByteRangePart);
    }

    /*
     * Exception decompiling
     */
    private static InMemoryDocument retrieveCompletePDFRevision(DSSDocument firstByteRangePart) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 21[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] getRevisionContent(DSSDocument dssDocument, ByteRange byteRange) throws IOException {
        int beginning = byteRange.getFirstPartStart();
        int endSigValueContent = byteRange.getSecondPartStart();
        int endValue = byteRange.getSecondPartEnd();
        byte[] revisionByteArray = new byte[endSigValueContent + endValue - beginning];
        try (InputStream is = dssDocument.openStream();){
            DSSUtils.skipAvailableBytes((InputStream)is, (int)beginning);
            DSSUtils.readAvailableBytes((InputStream)is, (byte[])revisionByteArray, (int)0, (int)(endSigValueContent + endValue - beginning));
        }
        catch (IllegalStateException e) {
            LOG.error("Cannot extract revision binaries. Reason : {}", (Object)e.getMessage());
        }
        return revisionByteArray;
    }

    public static byte[] getSignedContentFromRevision(byte[] revisionBinaries, ByteRange byteRange) throws IOException {
        int beginning = byteRange.getFirstPartStart();
        int startSigValueContent = byteRange.getFirstPartEnd();
        int endSigValueContent = byteRange.getSecondPartStart();
        int endValue = byteRange.getSecondPartEnd();
        byte[] signedDataByteArray = new byte[startSigValueContent + endValue];
        try (ByteArrayInputStream is = new ByteArrayInputStream(revisionBinaries);){
            DSSUtils.readAvailableBytes((InputStream)is, (byte[])signedDataByteArray, (int)0, (int)(startSigValueContent - beginning));
            DSSUtils.skipAvailableBytes((InputStream)is, (int)(endSigValueContent - startSigValueContent - beginning));
            DSSUtils.readAvailableBytes((InputStream)is, (byte[])signedDataByteArray, (int)(startSigValueContent - beginning), (int)endValue);
        }
        catch (IllegalStateException e) {
            LOG.error("Cannot extract revision binaries. Reason : {}", (Object)e.getMessage());
        }
        return signedDataByteArray;
    }

    /*
     * Exception decompiling
     */
    public static DSSDocument replaceSignature(DSSDocument toBeSignedDocument, byte[] cmsSignedData, DSSResourcesHandlerBuilder resourcesHandlerBuilder) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 27[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static RevocationInfoArchival getRevocationInfoArchival(ASN1Encodable encodable) {
        if (encodable != null) {
            try {
                return RevocationInfoArchival.getInstance(encodable);
            }
            catch (Exception e) {
                LOG.warn("Unable to parse RevocationInfoArchival", (Throwable)e);
            }
        }
        return null;
    }

    public static boolean isPDFDocument(DSSDocument document) {
        return DSSUtils.startsWithBytes((DSSDocument)document, (byte[])PDF_PREAMBLE);
    }

    public static SigFieldPermissions extractPermissionsDictionary(PdfDict wrapper) {
        Number permissions;
        SigFieldPermissions sigFieldPermissions = new SigFieldPermissions();
        String action = wrapper.getNameValue("Action");
        sigFieldPermissions.setAction(PdfLockAction.forName((String)action));
        ArrayList<String> fields = new ArrayList<String>();
        PdfArray fieldsArray = wrapper.getAsArray("Fields");
        if (fieldsArray != null) {
            for (int j = 0; j < fieldsArray.size(); ++j) {
                String field = fieldsArray.getString(j);
                if (field == null) continue;
                fields.add(field);
            }
        }
        sigFieldPermissions.setFields(fields);
        if ("SigFieldLock".equals(wrapper.getNameValue("Type")) && (permissions = wrapper.getNumberValue("P")) != null) {
            CertificationPermission certificationPermission = CertificationPermission.fromCode((int)permissions.intValue());
            sigFieldPermissions.setCertificationPermission(certificationPermission);
        }
        return sigFieldPermissions;
    }

    public static List<PdfVRIDict> getVRIsWithName(PdfDssDict pdfDssDict, String vriName) {
        List<PdfVRIDict> vris = pdfDssDict.getVRIs();
        if (Utils.isCollectionEmpty(vris)) {
            return Collections.emptyList();
        }
        if (vriName == null) {
            return vris;
        }
        for (PdfVRIDict vriDict : vris) {
            if (!vriName.equals(vriDict.getName())) continue;
            return Collections.singletonList(vriDict);
        }
        return Collections.emptyList();
    }

    public static DSSResourcesHandler initializeDSSResourcesHandler() {
        return DEFAULT_RESOURCES_HANDLER_BUILDER.createResourcesHandler();
    }
}

