/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSUtils;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class ByteRange {
    private final int[] byteRangeArray;

    public ByteRange(int[] byteRangeArray) {
        this.byteRangeArray = byteRangeArray;
    }

    public int getLength() {
        return this.byteRangeArray[1] - this.byteRangeArray[0] + (this.byteRangeArray[2] - this.byteRangeArray[1]) + this.byteRangeArray[3];
    }

    public int getFirstPartStart() {
        return this.byteRangeArray[0];
    }

    public int getFirstPartEnd() {
        return this.byteRangeArray[1];
    }

    public int getSecondPartStart() {
        return this.byteRangeArray[2];
    }

    public int getSecondPartEnd() {
        return this.byteRangeArray[3];
    }

    public List<BigInteger> toBigIntegerList() {
        return DSSUtils.toBigIntegerList((int[])this.byteRangeArray);
    }

    public void validate() {
        if (this.byteRangeArray == null || this.byteRangeArray.length != 4) {
            throw new DSSException("Incorrect ByteRange size");
        }
        int a = this.byteRangeArray[0];
        int b = this.byteRangeArray[1];
        int c = this.byteRangeArray[2];
        int d = this.byteRangeArray[3];
        if (a != 0) {
            throw new DSSException("The ByteRange must cover start of file");
        }
        if (b <= 0) {
            throw new DSSException("The first hash part doesn't cover anything");
        }
        if (c <= b) {
            throw new DSSException("The second hash part must start after the first hash part");
        }
        if (d <= 0) {
            throw new DSSException("The second hash part doesn't cover anything");
        }
    }

    public String toString() {
        return Arrays.toString(this.byteRangeArray);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.byteRangeArray);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteRange other = (ByteRange)obj;
        return Arrays.equals(this.byteRangeArray, other.byteRangeArray);
    }
}

