/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation.dss;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.dss.PdfCompositeDssDictCRLSource;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVRIDict;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PdfDssDictCRLSource
extends OfflineCRLSource {
    private static final long serialVersionUID = 7920126699012690199L;
    private final PdfCompositeDssDictCRLSource compositeCRLSource;
    private final PdfDssDict dssDictionary;
    private final String relatedVRIDictionaryName;
    private Map<Long, CRLBinary> crlMap;

    public PdfDssDictCRLSource(PdfCompositeDssDictCRLSource compositeCRLSource, PdfDssDict dssDictionary) {
        this(compositeCRLSource, dssDictionary, null);
    }

    public PdfDssDictCRLSource(PdfCompositeDssDictCRLSource compositeCRLSource, PdfDssDict dssDictionary, String vriDictionaryName) {
        this.compositeCRLSource = compositeCRLSource;
        this.dssDictionary = dssDictionary;
        this.relatedVRIDictionaryName = vriDictionaryName;
    }

    public Map<Long, CRLBinary> getCrlMap() {
        if (this.crlMap == null) {
            this.crlMap = new HashMap<Long, CRLBinary>();
            if (this.dssDictionary != null) {
                this.crlMap.putAll(this.dssDictionary.getCRLs());
                List<PdfVRIDict> vriDicts = PAdESUtils.getVRIsWithName(this.dssDictionary, this.relatedVRIDictionaryName);
                for (PdfVRIDict vriDict : vriDicts) {
                    this.crlMap.putAll(vriDict.getCRLs());
                }
            }
        }
        return this.crlMap;
    }

    public List<RevocationToken<CRL>> getRevocationTokens(CertificateToken certificateToken, CertificateToken issuerToken) {
        List<RevocationToken<CRL>> revocationTokens = this.compositeCRLSource.getRevocationTokens(certificateToken, issuerToken);
        revocationTokens = this.filterTokensFromCrlMap(revocationTokens);
        revocationTokens.addAll(super.getRevocationTokens(certificateToken, issuerToken));
        return revocationTokens;
    }

    public List<EncapsulatedRevocationTokenIdentifier<CRL>> getDSSDictionaryBinaries() {
        if (this.dssDictionary != null) {
            return this.filterBinariesFromKeys(this.compositeCRLSource.getDSSDictionaryBinaries(), this.dssDictionary.getCRLs().keySet());
        }
        return Collections.emptyList();
    }

    public List<RevocationToken<CRL>> getDSSDictionaryTokens() {
        if (this.dssDictionary != null) {
            return this.filterTokensFromKeys(this.compositeCRLSource.getDSSDictionaryTokens(), this.dssDictionary.getCRLs().keySet());
        }
        return Collections.emptyList();
    }

    public List<EncapsulatedRevocationTokenIdentifier<CRL>> getVRIDictionaryBinaries() {
        if (this.dssDictionary != null) {
            return this.filterBinariesFromKeys(this.compositeCRLSource.getVRIDictionaryBinaries(), this.getKeySetFromVRIDictionaries());
        }
        return Collections.emptyList();
    }

    public List<RevocationToken<CRL>> getVRIDictionaryTokens() {
        if (this.dssDictionary != null) {
            return this.filterTokensFromKeys(this.compositeCRLSource.getVRIDictionaryTokens(), this.getKeySetFromVRIDictionaries());
        }
        return Collections.emptyList();
    }

    private Set<Long> getKeySetFromVRIDictionaries() {
        if (this.dssDictionary != null) {
            HashSet<Long> result = new HashSet<Long>();
            List<PdfVRIDict> vris = PAdESUtils.getVRIsWithName(this.dssDictionary, this.relatedVRIDictionaryName);
            for (PdfVRIDict vriDict : vris) {
                result.addAll(vriDict.getCRLs().keySet());
            }
            return result;
        }
        return Collections.emptySet();
    }

    private List<EncapsulatedRevocationTokenIdentifier<CRL>> filterBinariesFromKeys(Collection<EncapsulatedRevocationTokenIdentifier<CRL>> crlBinaries, Collection<Long> keySet) {
        ArrayList<EncapsulatedRevocationTokenIdentifier<CRL>> result = new ArrayList<EncapsulatedRevocationTokenIdentifier<CRL>>();
        for (EncapsulatedRevocationTokenIdentifier<CRL> crlBinary : crlBinaries) {
            Set<Long> objectIds = this.compositeCRLSource.getTokenBinaryObjectIds(crlBinary);
            if (!Utils.containsAny(keySet, objectIds)) continue;
            result.add(crlBinary);
        }
        return result;
    }

    private List<RevocationToken<CRL>> filterTokensFromCrlMap(List<RevocationToken<CRL>> revocationTokens) {
        return this.filterTokensFromKeys(revocationTokens, this.getCrlMap().keySet());
    }

    private List<RevocationToken<CRL>> filterTokensFromKeys(Collection<RevocationToken<CRL>> revocationTokens, Collection<Long> keySet) {
        ArrayList<RevocationToken<CRL>> result = new ArrayList<RevocationToken<CRL>>();
        for (RevocationToken<CRL> crlToken : revocationTokens) {
            Set<Long> objectIds = this.compositeCRLSource.getRevocationTokenIds(crlToken);
            if (!Utils.containsAny(keySet, objectIds)) continue;
            result.add(crlToken);
        }
        return result;
    }

    public Map<EncapsulatedRevocationTokenIdentifier<CRL>, Set<RevocationOrigin>> getAllRevocationBinariesWithOrigins() {
        HashMap<EncapsulatedRevocationTokenIdentifier<CRL>, Set<RevocationOrigin>> result = new HashMap<EncapsulatedRevocationTokenIdentifier<CRL>, Set<RevocationOrigin>>();
        Set binaries = this.compositeCRLSource.getAllRevocationBinaries();
        List<EncapsulatedRevocationTokenIdentifier<CRL>> filteredBinaries = this.filterBinariesFromKeys(binaries, this.getCrlMap().keySet());
        for (EncapsulatedRevocationTokenIdentifier<CRL> CRLBinary2 : filteredBinaries) {
            result.put(CRLBinary2, this.getRevocationDataOrigins(CRLBinary2));
        }
        return result;
    }

    private Set<RevocationOrigin> getRevocationDataOrigins(EncapsulatedRevocationTokenIdentifier<CRL> crlBinary) {
        HashSet<RevocationOrigin> result = new HashSet<RevocationOrigin>();
        Set<Long> tokenBinaryObjectIds = this.compositeCRLSource.getTokenBinaryObjectIds(crlBinary);
        if (Utils.containsAny(this.dssDictionary.getCRLs().keySet(), tokenBinaryObjectIds)) {
            result.add(RevocationOrigin.DSS_DICTIONARY);
        }
        for (PdfVRIDict vriDict : PAdESUtils.getVRIsWithName(this.dssDictionary, this.relatedVRIDictionaryName)) {
            if (!Utils.containsAny(vriDict.getCRLs().keySet(), tokenBinaryObjectIds)) continue;
            result.add(RevocationOrigin.VRI_DICTIONARY);
        }
        return result;
    }

    public Map<RevocationToken<CRL>, Set<RevocationOrigin>> getAllRevocationTokensWithOrigins() {
        HashMap<RevocationToken<CRL>, Set<RevocationOrigin>> result = new HashMap<RevocationToken<CRL>, Set<RevocationOrigin>>();
        Set tokens = this.compositeCRLSource.getAllRevocationTokens();
        List<RevocationToken<CRL>> filteredBinaries = this.filterTokensFromKeys(tokens, this.getCrlMap().keySet());
        for (RevocationToken<CRL> CRLToken2 : filteredBinaries) {
            result.put(CRLToken2, this.getRevocationDataOrigins(CRLToken2));
        }
        return result;
    }

    private Set<RevocationOrigin> getRevocationDataOrigins(RevocationToken<CRL> crlToken) {
        HashSet<RevocationOrigin> result = new HashSet<RevocationOrigin>();
        Set<Long> tokenObjectIds = this.compositeCRLSource.getRevocationTokenIds(crlToken);
        if (Utils.containsAny(this.dssDictionary.getCRLs().keySet(), tokenObjectIds)) {
            result.add(RevocationOrigin.DSS_DICTIONARY);
        }
        for (PdfVRIDict vriDict : PAdESUtils.getVRIsWithName(this.dssDictionary, this.relatedVRIDictionaryName)) {
            if (!Utils.containsAny(vriDict.getCRLs().keySet(), tokenObjectIds)) continue;
            result.add(RevocationOrigin.VRI_DICTIONARY);
        }
        return result;
    }
}

