/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation.timestamp;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.timestamp.CAdESTimestampDataBuilder;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PdfRevision;
import eu.europa.esig.dss.pdf.PdfDocTimestampRevision;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.List;

public class PAdESTimestampDataBuilder
extends CAdESTimestampDataBuilder {
    private final List<PdfRevision> documentRevisions;
    private List<TimestampToken> signatureTimestamps = new ArrayList<TimestampToken>();

    public PAdESTimestampDataBuilder(List<PdfRevision> documentRevisions, PAdESSignature signature, ListCertificateSource certificateSource) {
        super((CAdESSignature)signature, certificateSource);
        this.documentRevisions = documentRevisions;
    }

    public void setSignatureTimestamps(List<TimestampToken> signatureTimestamps) {
        this.signatureTimestamps = signatureTimestamps;
    }

    public DSSDocument getSignatureTimestampData(TimestampToken timestampToken) {
        DSSDocument signedData = this.getSignedDataInPDFRevisions(timestampToken);
        if (signedData != null) {
            return signedData;
        }
        if (this.signatureTimestamps.contains(timestampToken)) {
            return super.getSignatureTimestampData(timestampToken);
        }
        throw new DSSException("Timestamp Data not found");
    }

    public DSSDocument getTimestampX1Data(TimestampToken timestampToken) {
        return null;
    }

    public DSSDocument getTimestampX2Data(TimestampToken timestampToken) {
        return null;
    }

    public DSSDocument getArchiveTimestampData(TimestampToken timestampToken) {
        DSSDocument signedData = this.getSignedDataInPDFRevisions(timestampToken);
        if (signedData != null) {
            return signedData;
        }
        throw new DSSException("Timestamp Data not found");
    }

    private final DSSDocument getSignedDataInPDFRevisions(TimestampToken timestampToken) {
        for (PdfRevision signatureInfo : this.documentRevisions) {
            PdfDocTimestampRevision pdfTimestampInfo;
            if (!(signatureInfo instanceof PdfDocTimestampRevision) || !(pdfTimestampInfo = (PdfDocTimestampRevision)signatureInfo).getTimestampToken().equals(timestampToken)) continue;
            return pdfTimestampInfo.getSignedData();
        }
        return null;
    }
}

