/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation.timestamp;

import eu.europa.esig.dss.cades.validation.CAdESAttribute;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.timestamp.CAdESTimestampSource;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PdfRevision;
import eu.europa.esig.dss.pades.validation.RevocationInfoArchival;
import eu.europa.esig.dss.pades.validation.timestamp.PAdESTimestampDataBuilder;
import eu.europa.esig.dss.pades.validation.timestamp.PdfRevisionTimestampSource;
import eu.europa.esig.dss.pades.validation.timestamp.PdfTimestampToken;
import eu.europa.esig.dss.pdf.PdfDocDssRevision;
import eu.europa.esig.dss.pdf.PdfDocTimestampRevision;
import eu.europa.esig.dss.pdf.PdfSignatureRevision;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.SignatureProperties;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ocsp.OCSPResponse;

public class PAdESTimestampSource
extends CAdESTimestampSource {
    private final List<PdfRevision> documentRevisions;
    protected List<TimestampToken> documentTimestamps;

    public PAdESTimestampSource(PAdESSignature signature, List<PdfRevision> documentRevisions) {
        super((CAdESSignature)signature);
        Objects.requireNonNull(documentRevisions, "List of Document revisions must be provided!");
        this.documentRevisions = Utils.reverseList(documentRevisions);
    }

    public List<TimestampToken> getDocumentTimestamps() {
        if (this.documentTimestamps == null) {
            this.createAndValidate();
        }
        return this.documentTimestamps;
    }

    protected PAdESTimestampDataBuilder getTimestampDataBuilder() {
        PAdESTimestampDataBuilder padesTimestampDataBuilder = new PAdESTimestampDataBuilder(this.documentRevisions, (PAdESSignature)this.signature, this.certificateSource);
        padesTimestampDataBuilder.setSignatureTimestamps(this.getSignatureTimestamps());
        return padesTimestampDataBuilder;
    }

    protected void makeTimestampTokensFromSignedAttributes() {
        if (this.signature != null) {
            super.makeTimestampTokensFromSignedAttributes();
        }
    }

    protected void makeTimestampTokensFromUnsignedAttributes() {
        super.makeTimestampTokensFromUnsignedAttributes();
        List cadesSignatureTimestamps = this.getSignatureTimestamps();
        ArrayList<PdfTimestampToken> processedDocumentTimestamps = new ArrayList<PdfTimestampToken>();
        this.unsignedPropertiesReferences = new ArrayList();
        this.documentTimestamps = new ArrayList<TimestampToken>();
        boolean signatureRevisionReached = false;
        boolean dssRevisionReached = false;
        for (PdfRevision pdfRevision : this.documentRevisions) {
            PAdESSignature padesSignature;
            if (pdfRevision instanceof PdfDocTimestampRevision) {
                ArrayList individualTimestampReferences = new ArrayList();
                PdfDocTimestampRevision timestampRevision = (PdfDocTimestampRevision)pdfRevision;
                PdfTimestampToken timestampToken = timestampRevision.getTimestampToken();
                if (dssRevisionReached) {
                    timestampToken.setArchiveTimestampType(ArchiveTimestampType.PAdES);
                }
                if (signatureRevisionReached) {
                    this.addReferences(individualTimestampReferences, this.getSignatureTimestampReferences());
                    this.addReferences(individualTimestampReferences, this.getSignatureSignedDataReferences());
                    this.addReferences(individualTimestampReferences, this.getEncapsulatedReferencesFromTimestamps(cadesSignatureTimestamps));
                }
                if (Utils.isCollectionNotEmpty((Collection)this.unsignedPropertiesReferences)) {
                    this.addReferences(individualTimestampReferences, this.unsignedPropertiesReferences);
                }
                this.addReferences(individualTimestampReferences, this.getEncapsulatedReferencesFromTimestamps(processedDocumentTimestamps));
                this.addReferences(timestampToken.getTimestampedReferences(), individualTimestampReferences);
                if (signatureRevisionReached) {
                    this.documentTimestamps.add(timestampToken);
                }
                this.populateSources(timestampToken);
                processedDocumentTimestamps.add(timestampToken);
                continue;
            }
            if (pdfRevision instanceof PdfDocDssRevision) {
                PdfDocDssRevision pdfDocDssRevision = (PdfDocDssRevision)pdfRevision;
                PdfRevisionTimestampSource pdfRevisionTimestampSource = new PdfRevisionTimestampSource(pdfDocDssRevision, this.certificateSource, (ListRevocationSource<CRL>)this.crlSource, (ListRevocationSource<OCSP>)this.ocspSource);
                this.addReferences(this.unsignedPropertiesReferences, pdfRevisionTimestampSource.getIncorporatedReferences());
                this.certificateSource.add((CertificateSource)pdfDocDssRevision.getCertificateSource());
                this.crlSource.add((OfflineRevocationSource)pdfDocDssRevision.getCRLSource());
                this.ocspSource.add((OfflineRevocationSource)pdfDocDssRevision.getOCSPSource());
                dssRevisionReached = true;
                continue;
            }
            if (!(pdfRevision instanceof PdfSignatureRevision) || (padesSignature = (PAdESSignature)this.signature).getPdfRevision() != pdfRevision) continue;
            signatureRevisionReached = true;
        }
    }

    protected boolean isCompleteCertificateRef(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isAttributeCertificateRef(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isCompleteRevocationRef(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isAttributeRevocationRef(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isRefsOnlyTimestamp(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isSigAndRefsTimestamp(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isCertificateValues(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isRevocationValues(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isArchiveTimestamp(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected List<TimestampedReference> getSignatureTimestampReferences() {
        List signatureTimestampReferences = super.getSignatureTimestampReferences();
        this.addReferences(signatureTimestampReferences, this.getAdbeRevocationInfoArchivalReferences());
        return signatureTimestampReferences;
    }

    protected List<TimestampedReference> getAdbeRevocationInfoArchivalReferences() {
        SignatureProperties signedSignatureProperties = this.getSignedSignatureProperties();
        if (!signedSignatureProperties.isExist()) {
            return Collections.emptyList();
        }
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        for (CAdESAttribute attribute : signedSignatureProperties.getAttributes()) {
            RevocationInfoArchival revValues;
            if (!this.isAdbeRevocationInfoArchival(attribute) || (revValues = PAdESUtils.getRevocationInfoArchival(attribute.getASN1Object())) == null) continue;
            List crlBinaries = this.buildCRLIdentifiers(revValues.getCrlVals());
            this.addReferences(references, this.createReferencesForCRLBinaries(crlBinaries));
            List ocspBinaries = this.buildOCSPIdentifiers(DSSASN1Utils.toBasicOCSPResps((OCSPResponse[])revValues.getOcspVals()));
            this.addReferences(references, this.createReferencesForOCSPBinaries(ocspBinaries, this.certificateSource));
        }
        return references;
    }

    protected boolean isAdbeRevocationInfoArchival(CAdESAttribute signedAttribute) {
        return OID.adbe_revocationInfoArchival.equals((ASN1Primitive)signedAttribute.getASN1Oid());
    }

    protected List<AdvancedSignature> getCounterSignatures(CAdESAttribute unsignedAttribute) {
        return Collections.emptyList();
    }
}

